/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicLabelUI;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualLexiconNode;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.vizmap.VisualPropertyDependency;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.gui.internal.view.DropDownMenuButton;
import org.cytoscape.view.vizmap.gui.internal.view.VisualPropertySheetItem;
import org.cytoscape.view.vizmap.gui.internal.view.VisualPropertySheetItemModel;
import org.cytoscape.view.vizmap.gui.internal.view.VisualPropertySheetModel;
import org.cytoscape.view.vizmap.gui.util.PropertySheetUtil;

public class VisualPropertySheet
extends JPanel {
    private JPanel vpListHeaderPnl;
    private JScrollPane vpListScr;
    private DropDownMenuButton vpsBtn;
    private JPopupMenu vpsMenu;
    private JButton expandAllBtn;
    private JButton collapseAllBtn;
    private final VisualPropertySheetModel model;
    private final TreeSet<VisualPropertySheetItem<?>> items;
    private final Map<VisualProperty<?>, VisualPropertySheetItem<?>> vpItemMap;
    private final Map<String, VisualPropertySheetItem<?>> depItemMap;
    private final Map<VisualPropertySheetItem<?>, JCheckBoxMenuItem> menuItemMap;
    private DefaultListSelectionModel selectionModel;
    private boolean doNotUpdateCollapseExpandButtons;
    private final ServicesUtil servicesUtil;

    public VisualPropertySheet(VisualPropertySheetModel model, ServicesUtil servicesUtil) {
        if (model == null) {
            throw new IllegalArgumentException("'model' must not be null");
        }
        if (servicesUtil == null) {
            throw new IllegalArgumentException("'servicesUtil' must not be null");
        }
        this.model = model;
        this.servicesUtil = servicesUtil;
        this.items = new TreeSet();
        this.vpItemMap = new HashMap();
        this.depItemMap = new HashMap();
        this.menuItemMap = new HashMap();
        this.selectionModel = new DefaultListSelectionModel();
        this.selectionModel.addListSelectionListener(evt -> {
            if (!evt.getValueIsAdjusting()) {
                List<VisualPropertySheetItem<?>> allItems = this.getAllItems(false);
                int first = evt.getFirstIndex();
                int last = evt.getLastIndex();
                for (int i = first; i <= last && i < allItems.size(); ++i) {
                    VisualPropertySheetItem<?> p = allItems.get(i);
                    boolean selected = this.selectionModel.isSelectedIndex(i);
                    if (p.isSelected() == selected) continue;
                    p.setSelected(selected);
                }
            }
        });
        this.init();
    }

    public VisualPropertySheetModel getModel() {
        return this.model;
    }

    public void setItems(Set<VisualPropertySheetItem<?>> newItems) {
        this.vpItemMap.clear();
        this.depItemMap.clear();
        this.items.clear();
        if (newItems != null) {
            this.items.addAll(newItems);
            JPanel p = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.anchor = 23;
            c.gridx = 0;
            c.weightx = 1.0;
            int y = 0;
            int minWidth = 120;
            for (final VisualPropertySheetItem<?> i : this.items) {
                c.gridy = y++;
                p.add(i, c);
                if (i.getModel().getVisualPropertyDependency() == null) {
                    this.vpItemMap.put(i.getModel().getVisualProperty(), i);
                } else {
                    this.depItemMap.put(i.getModel().getVisualPropertyDependency().getIdString(), i);
                }
                i.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        VisualPropertySheet.this.onMousePressedItem(e, i);
                    }
                });
                if (i.getModel().isVisualMappingAllowed()) {
                    i.addComponentListener(new ComponentAdapter(){

                        @Override
                        public void componentShown(ComponentEvent e) {
                            VisualPropertySheet.this.updateCollapseExpandButtons();
                        }

                        @Override
                        public void componentHidden(ComponentEvent e) {
                            VisualPropertySheet.this.updateCollapseExpandButtons();
                        }
                    });
                    i.addPropertyChangeListener("enabled", evt -> this.updateCollapseExpandButtons());
                    i.addPropertyChangeListener("expanded", evt -> this.updateCollapseExpandButtons());
                    i.getPropSheetPnl().getTable().addMouseListener((MouseListener)new MouseAdapter(){

                        @Override
                        public void mousePressed(MouseEvent e) {
                            if (!i.getPropSheetPnl().getTable().isEditing()) {
                                VisualPropertySheet.this.onMousePressedItem(e, i);
                            }
                        }
                    });
                }
                minWidth = Math.max(minWidth, i.getPreferredSize().width);
            }
            JPanel fillPnl = new JPanel();
            fillPnl.setBackground(VisualPropertySheetItem.getBackgroundColor());
            c.fill = 1;
            c.weighty = 1.0;
            p.add((Component)fillPnl, c);
            fillPnl.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (!e.isShiftDown() || e.isControlDown()) {
                        VisualPropertySheet.this.setSelectedItems(Collections.EMPTY_SET);
                    }
                }
            });
            this.getVpListScr().setViewportView(p);
            minWidth += 10;
            minWidth = Math.min(minWidth, 400);
            this.getVpListScr().setMinimumSize(new Dimension(minWidth, 140));
            if (this.getParent() != null) {
                minWidth = Math.max(minWidth + 8, this.getParent().getMinimumSize().width);
                this.getParent().setMinimumSize(new Dimension(minWidth, this.getParent().getMinimumSize().height));
            }
        }
        this.updateCollapseExpandButtons();
        this.createMenuItems();
    }

    public List<VisualPropertySheetItem<?>> getAllItems() {
        return this.getAllItems(true);
    }

    public List<VisualPropertySheetItem<?>> getAllItems(boolean includeInvisible) {
        ArrayList list = new ArrayList();
        for (VisualPropertySheetItem<?> i : this.items) {
            if (!includeInvisible && !i.isVisible()) continue;
            list.add(i);
        }
        return list;
    }

    public <T> VisualPropertySheetItem<T> getItem(VisualProperty<T> vp) {
        return this.vpItemMap.get(vp);
    }

    public <T> VisualPropertySheetItem<T> getItem(VisualPropertyDependency<T> dep) {
        return this.depItemMap.get(dep.getIdString());
    }

    public synchronized List<VisualPropertySheetItem<?>> getSelectedItems() {
        ArrayList list = new ArrayList();
        for (VisualPropertySheetItem<?> i : this.items) {
            if (!i.isVisible() || !i.isSelected()) continue;
            list.add(i);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setSelectedItems(Collection<VisualPropertySheetItem<?>> selectedItems) {
        this.selectionModel.setValueIsAdjusting(true);
        try {
            this.selectionModel.clearSelection();
            List<VisualPropertySheetItem<?>> allItems = this.getAllItems(false);
            int maxIdx = -1;
            for (VisualPropertySheetItem<?> i : selectedItems) {
                int idx = allItems.indexOf(i);
                if (idx < 0) continue;
                this.selectionModel.addSelectionInterval(idx, idx);
                maxIdx = Math.max(idx, maxIdx);
            }
            this.selectionModel.setAnchorSelectionIndex(maxIdx);
            this.selectionModel.moveLeadSelectionIndex(maxIdx);
        }
        finally {
            this.selectionModel.setValueIsAdjusting(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisibleItems(Collection<VisualPropertySheetItem<?>> visibleItems) {
        this.selectionModel.setValueIsAdjusting(true);
        try {
            List<VisualPropertySheetItem<?>> selectedItems = this.getSelectedItems();
            this.deselectAll();
            List<VisualPropertySheetItem<?>> allItems = this.getAllItems();
            for (VisualPropertySheetItem<?> i : allItems) {
                i.setVisible(visibleItems.contains(i));
                if (i.isVisible()) continue;
                selectedItems.remove(i);
            }
            this.setSelectedItems(selectedItems);
            this.updateCollapseExpandButtons();
        }
        finally {
            this.selectionModel.setValueIsAdjusting(false);
        }
    }

    private void init() {
        this.setOpaque(!LookAndFeelUtil.isAquaLAF());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getVpListHeaderPnl()).addComponent(this.getVpListScr()));
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.getVpListHeaderPnl()).addComponent(this.getVpListScr()));
    }

    private JPanel getVpListHeaderPnl() {
        if (this.vpListHeaderPnl == null) {
            this.vpListHeaderPnl = new JPanel();
            this.vpListHeaderPnl.setOpaque(!LookAndFeelUtil.isAquaLAF());
            GroupLayout layout = new GroupLayout(this.vpListHeaderPnl);
            this.vpListHeaderPnl.setLayout(layout);
            GroupLayout.SequentialGroup hGroup = layout.createSequentialGroup();
            GroupLayout.ParallelGroup vGroup = layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false);
            layout.setHorizontalGroup(hGroup);
            layout.setVerticalGroup(vGroup);
            hGroup.addGap(3);
            HeaderLabel defLbl = new HeaderLabel("Default");
            defLbl.setToolTipText("Default values");
            hGroup.addComponent(defLbl);
            vGroup.addComponent(defLbl);
            if (this.model.getLexiconType() != CyNetwork.class) {
                HeaderLabel mapLbl = new HeaderLabel("Mapping");
                mapLbl.setToolTipText("Values mapped from a table column");
                hGroup.addComponent(mapLbl);
                vGroup.addComponent(mapLbl);
            }
            if (this.model.getLexiconType() != CyColumn.class) {
                HeaderLabel bypassLbl = new HeaderLabel("Bypass");
                bypassLbl.setToolTipText("Overrides the Default and Mapping values");
                hGroup.addComponent(bypassLbl);
                vGroup.addComponent(bypassLbl);
            }
            hGroup.addComponent(this.getVpsBtn(), -2, -1, -2);
            vGroup.addComponent(this.getVpsBtn(), -2, -1, -2);
            hGroup.addGap(10, 10, Short.MAX_VALUE);
            if (this.model.getLexiconType() != CyNetwork.class) {
                hGroup.addComponent(this.getExpandAllBtn());
                vGroup.addComponent(this.getExpandAllBtn());
                hGroup.addComponent(this.getCollapseAllBtn());
                vGroup.addComponent(this.getCollapseAllBtn());
            }
        }
        return this.vpListHeaderPnl;
    }

    private JScrollPane getVpListScr() {
        if (this.vpListScr == null) {
            this.vpListScr = new JScrollPane(20, 31);
            this.vpListScr.getVerticalScrollBar().setUnitIncrement(8);
            this.vpListScr.getViewport().addChangeListener(evt -> {
                for (VisualPropertySheetItem<?> item : this.getAllItems()) {
                    item.fitToWidth(this.vpListScr.getViewport().getWidth());
                }
            });
        }
        return this.vpListScr;
    }

    private DropDownMenuButton getVpsBtn() {
        if (this.vpsBtn == null) {
            this.vpsBtn = new DropDownMenuButton(this.getVpsMenu(), false);
            this.vpsBtn.setText("More Properties...");
            this.vpsBtn.setToolTipText("Choose which properties to use");
            this.vpsBtn.setHorizontalAlignment(2);
        }
        return this.vpsBtn;
    }

    protected JPopupMenu getVpsMenu() {
        if (this.vpsMenu == null) {
            this.vpsMenu = new JPopupMenu();
            this.vpsMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    VisualPropertySheet.this.updateMenuItems();
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
        }
        return this.vpsMenu;
    }

    protected JButton getExpandAllBtn() {
        if (this.expandAllBtn == null) {
            IconManager iconManager = this.servicesUtil.get(IconManager.class);
            this.expandAllBtn = new JButton("\uf103");
            this.expandAllBtn.setToolTipText("Expand all mappings");
            this.expandAllBtn.setBorderPainted(false);
            this.expandAllBtn.setContentAreaFilled(false);
            this.expandAllBtn.setFocusPainted(false);
            this.expandAllBtn.setFont(iconManager.getIconFont(17.0f));
            this.expandAllBtn.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
            this.expandAllBtn.addActionListener(evt -> this.expandAllMappings());
        }
        return this.expandAllBtn;
    }

    protected JButton getCollapseAllBtn() {
        if (this.collapseAllBtn == null) {
            IconManager iconManager = this.servicesUtil.get(IconManager.class);
            this.collapseAllBtn = new JButton("\uf102");
            this.collapseAllBtn.setToolTipText("Collapse all mappings");
            this.collapseAllBtn.setBorderPainted(false);
            this.collapseAllBtn.setContentAreaFilled(false);
            this.collapseAllBtn.setFocusPainted(false);
            this.collapseAllBtn.setFont(iconManager.getIconFont(17.0f));
            this.collapseAllBtn.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
            this.collapseAllBtn.addActionListener(evt -> this.collapseAllMappings());
        }
        return this.collapseAllBtn;
    }

    private void createMenuItems() {
        JPopupMenu rootMenu = this.getVpsMenu();
        this.menuItemMap.clear();
        int length = rootMenu.getSubElements() != null ? rootMenu.getSubElements().length : 0;
        for (int i = 0; i < length; ++i) {
            rootMenu.remove(i);
        }
        VisualLexicon lexicon = this.model.getVisualLexicon();
        if (lexicon == null) {
            return;
        }
        VisualProperty<?> rootVp = this.model.getRootVisualProperty();
        VisualLexiconNode rootNode = lexicon.getVisualLexiconNode(rootVp);
        final Collator collator = Collator.getInstance(Locale.getDefault());
        PriorityQueue<VisualLexiconNode> queue = new PriorityQueue<VisualLexiconNode>(50, new Comparator<VisualLexiconNode>(){

            @Override
            public int compare(VisualLexiconNode n1, VisualLexiconNode n2) {
                collator.setStrength(0);
                return collator.compare(VisualPropertySheetItemModel.createTitle(n1.getVisualProperty()), VisualPropertySheetItemModel.createTitle(n2.getVisualProperty()));
            }
        });
        queue.addAll(rootNode.getChildren());
        HashMap<VisualLexiconNode, JComponent> menuMap = new HashMap<VisualLexiconNode, JComponent>();
        menuMap.put(rootNode, rootMenu);
        VisualStyle style = this.model.getVisualStyle();
        HashSet disabledProps = new HashSet();
        HashSet nextNodes = new HashSet();
        while (!queue.isEmpty()) {
            VisualLexiconNode curNode = queue.poll();
            VisualProperty vp = curNode.getVisualProperty();
            if (vp.getTargetDataType() == this.model.getLexiconType()) {
                Collection children = curNode.getChildren();
                nextNodes.addAll(children);
                if (PropertySheetUtil.isCompatible(vp).booleanValue()) {
                    String label;
                    VisualLexiconNode parentNode = curNode.getParent();
                    boolean leaf = children.isEmpty();
                    VisualPropertySheetItem vpSheetItem = this.getItem(vp);
                    String string = label = vpSheetItem != null ? vpSheetItem.getModel().getTitle() : VisualPropertySheetItemModel.createTitle(vp);
                    if (!leaf) {
                        JMenu nonLeafMenu = new JMenu(label);
                        menuMap.put(curNode, nonLeafMenu);
                        ((JComponent)menuMap.get(parentNode)).add(nonLeafMenu);
                        parentNode = curNode;
                    }
                    if (vpSheetItem != null) {
                        JCheckBoxMenuItem mi = new JCheckBoxMenuItem(label, vpSheetItem.isVisible());
                        mi.addActionListener(evt -> this.toggleVisibility(vpSheetItem));
                        ((JComponent)menuMap.get(parentNode)).add(mi);
                        this.menuItemMap.put(vpSheetItem, mi);
                        if (parentNode == curNode) {
                            ((JComponent)menuMap.get(parentNode)).add(new JSeparator());
                        }
                        if (disabledProps.contains(vp)) {
                            mi.setEnabled(false);
                        }
                    }
                }
            }
            queue.addAll(nextNodes);
            nextNodes.clear();
        }
        TreeSet depTreeSet = new TreeSet((d1, d2) -> {
            collator.setStrength(0);
            return collator.compare(d1.getDisplayName(), d2.getDisplayName());
        });
        depTreeSet.addAll(style.getAllVisualPropertyDependencies());
        for (VisualPropertyDependency dep : depTreeSet) {
            VisualPropertySheetItem vpSheetItem = this.getItem(dep);
            if (vpSheetItem == null) continue;
            JCheckBoxMenuItem mi = new JCheckBoxMenuItem(dep.getDisplayName(), vpSheetItem.isVisible());
            mi.addActionListener(evt -> this.toggleVisibility(vpSheetItem));
            VisualLexiconNode parentNode = lexicon.getVisualLexiconNode(dep.getParentVisualProperty());
            JComponent parentMenu = (JComponent)menuMap.get(parentNode);
            if (parentMenu == null) {
                parentMenu = rootMenu;
            }
            parentMenu.add(mi);
            this.menuItemMap.put(vpSheetItem, mi);
        }
    }

    private void updateMenuItems() {
        for (Map.Entry<VisualPropertySheetItem<?>, JCheckBoxMenuItem> entry : this.menuItemMap.entrySet()) {
            entry.getValue().setSelected(entry.getKey().isVisible());
        }
    }

    private void updateCollapseExpandButtons() {
        if (this.doNotUpdateCollapseExpandButtons || this.model.getLexiconType() == CyNetwork.class) {
            return;
        }
        boolean enableCollapse = false;
        boolean enableExpand = false;
        for (VisualPropertySheetItem<?> item : this.items) {
            if (item.isVisible() && item.isEnabled()) {
                if (item.isExpanded()) {
                    enableCollapse = true;
                } else if (!enableExpand && !item.isExpanded() && item.getModel().getVisualMappingFunction() != null) {
                    enableExpand = true;
                }
            }
            if (!enableExpand || !enableCollapse) continue;
            break;
        }
        this.getCollapseAllBtn().setEnabled(enableCollapse);
        this.getExpandAllBtn().setEnabled(enableExpand);
    }

    private void collapseAllMappings() {
        this.doNotUpdateCollapseExpandButtons = true;
        for (VisualPropertySheetItem<?> item : this.items) {
            item.collapse();
        }
        this.doNotUpdateCollapseExpandButtons = false;
        this.updateCollapseExpandButtons();
    }

    private void expandAllMappings() {
        this.doNotUpdateCollapseExpandButtons = true;
        for (VisualPropertySheetItem<?> item : this.items) {
            if (!item.isEnabled() || item.getModel().getVisualMappingFunction() == null) continue;
            item.expand();
        }
        this.doNotUpdateCollapseExpandButtons = false;
        this.updateCollapseExpandButtons();
    }

    void onMousePressedItem(MouseEvent e, VisualPropertySheetItem<?> item) {
        item.requestFocusInWindow();
        if (!e.isPopupTrigger() && SwingUtilities.isLeftMouseButton(e)) {
            boolean isControlDown;
            boolean isMac = LookAndFeelUtil.isMac();
            boolean bl = isControlDown = isMac && e.isMetaDown() || !isMac && e.isControlDown();
            if (isControlDown) {
                this.toggleSelection(item);
            } else if (e.isShiftDown()) {
                List<VisualPropertySheetItem<?>> allItems = this.getAllItems(false);
                int index = allItems.indexOf(item);
                this.shiftSelectTo(index);
            } else {
                List<VisualPropertySheetItem<?>> allItems = this.getAllItems(false);
                this.setSelectedIndex(allItems.indexOf(item));
            }
        }
    }

    private void shiftSelectTo(int index) {
        int size = this.items.size();
        if (index < 0 || index >= size) {
            return;
        }
        int anchor = this.selectionModel.getAnchorSelectionIndex();
        int lead = this.selectionModel.getLeadSelectionIndex();
        this.selectionModel.setValueIsAdjusting(true);
        if (anchor != lead && (anchor >= 0 || lead >= 0)) {
            this.selectionModel.removeSelectionInterval(Math.max(0, anchor), Math.max(0, lead));
        }
        this.selectionModel.addSelectionInterval(Math.max(0, anchor), index);
        this.selectionModel.setValueIsAdjusting(false);
        List<VisualPropertySheetItem<?>> allItems = this.getAllItems(false);
        allItems.get(index).requestFocusInWindow();
    }

    private void toggleSelection(VisualPropertySheetItem<?> item) {
        List<VisualPropertySheetItem<?>> allItems = this.getAllItems(false);
        int index = allItems.indexOf(item);
        if (this.selectionModel.isSelectedIndex(index)) {
            this.selectionModel.removeSelectionInterval(index, index);
        } else {
            this.selectionModel.addSelectionInterval(index, index);
        }
        this.selectionModel.setValueIsAdjusting(true);
        if (this.selectionModel.isSelectedIndex(index)) {
            this.selectionModel.setAnchorSelectionIndex(index);
            this.selectionModel.moveLeadSelectionIndex(index);
        } else {
            index = this.selectionModel.getMaxSelectionIndex();
            this.selectionModel.setAnchorSelectionIndex(index);
            this.selectionModel.moveLeadSelectionIndex(index);
        }
        this.selectionModel.setValueIsAdjusting(false);
    }

    void selectAll() {
        if (this.items.size() >= 0) {
            this.selectionModel.setSelectionInterval(0, this.items.size() - 1);
        }
    }

    void deselectAll() {
        this.selectionModel.clearSelection();
        this.selectionModel.setAnchorSelectionIndex(-1);
        this.selectionModel.setLeadSelectionIndex(-1);
    }

    void setSelectedIndex(int index) {
        if (index >= this.items.size()) {
            return;
        }
        this.selectionModel.setSelectionInterval(index, index);
    }

    private void toggleVisibility(VisualPropertySheetItem<?> item) {
        if (item.isVisible()) {
            if (item.isSelected()) {
                this.toggleSelection(item);
            }
        } else {
            this.deselectAll();
        }
        item.setVisible(!item.isVisible());
        if (item.isVisible()) {
            this.setSelectedItems(Collections.singleton(item));
        } else {
            List<VisualPropertySheetItem<?>> selectedItems = this.getSelectedItems();
            this.setSelectedItems(selectedItems);
        }
    }

    private static class HeaderLabel
    extends JLabel {
        static final int WIDTH = 36;
        static final int HEIGHT = 36;
        static final int BORDER_WIDTH = 2;
        static final int ROTATION = -45;

        HeaderLabel(String text) {
            super(text);
            if (LookAndFeelUtil.isNimbusLAF()) {
                this.setUI(new BasicLabelUI());
            }
            this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            this.setFont(this.getFont().deriveFont(10.0f));
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(3);
            Dimension d = new Dimension(36, 36);
            this.setMinimumSize(d);
            this.setPreferredSize(d);
            this.setMaximumSize(d);
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g.create();
            Font font = this.getFont();
            AffineTransform trans = new AffineTransform();
            trans.rotate(Math.toRadians(-45.0));
            trans.translate(3.0, 0.0);
            Font rotatedFont = font.deriveFont(trans);
            g2d.setFont(rotatedFont);
            super.paintComponent(g2d);
            g2d.dispose();
        }
    }
}

