/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CyColumnPresentationManager;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkTableManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.util.swing.TextIcon;
import org.cytoscape.view.vizmap.gui.internal.ColumnSpec;
import org.cytoscape.view.vizmap.gui.internal.GraphObjectType;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.gui.internal.view.ColumnStyleAddColumnPopup;

public class ColumnStylePicker {
    public static final float ICON_FONT_SIZE = 22.0f;
    private final ServicesUtil servicesUtil;
    private JPanel columnPanel;
    private JTable jtable;
    private JButton addButton;
    private JButton deleteButton;
    private List<BiConsumer<ColumnSpec, Action>> columnSelectionListeners = new ArrayList<BiConsumer<ColumnSpec, Action>>(2);

    public ColumnStylePicker(ServicesUtil servicesUtil) {
        this.servicesUtil = servicesUtil;
    }

    public void addColumnSelectionListener(BiConsumer<ColumnSpec, Action> listener) {
        this.columnSelectionListeners.add(listener);
    }

    public void removeColumnSelectionListener(BiConsumer<ColumnSpec, Action> listener) {
        this.columnSelectionListeners.remove(listener);
    }

    public JComponent getComponent() {
        return this.getColumnPanel();
    }

    private JPanel getColumnPanel() {
        if (this.columnPanel == null) {
            this.columnPanel = new JPanel();
            JLabel title = new JLabel("Styled Columns");
            JTable table = this.getJTable();
            JScrollPane scrollPane = new JScrollPane(table);
            GroupLayout layout = new GroupLayout(this.columnPanel);
            this.columnPanel.setLayout(layout);
            layout.setAutoCreateContainerGaps(true);
            layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
            layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(title).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.getAddButton()).addGap(5).addComponent(this.getDeleteButton())).addComponent(scrollPane));
            layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(title).addComponent(this.getAddButton()).addComponent(this.getDeleteButton())).addComponent(scrollPane, 150, 150, Short.MAX_VALUE));
        }
        return this.columnPanel;
    }

    private JButton getAddButton() {
        if (this.addButton == null) {
            IconManager iconManager = this.servicesUtil.get(IconManager.class);
            this.addButton = new JButton("\uf067");
            this.addButton.setFont(iconManager.getIconFont(17.6f));
            this.addButton.setToolTipText("Add Column Style...");
            this.addButton.setBorderPainted(false);
            this.addButton.setContentAreaFilled(false);
            this.addButton.setFocusPainted(false);
            this.addButton.setBorder(BorderFactory.createEmptyBorder());
            this.addButton.addActionListener(e -> {
                CyNetwork network = this.servicesUtil.get(CyApplicationManager.class).getCurrentNetwork();
                if (network == null) {
                    return;
                }
                ColumnStyleAddColumnPopup dialog = new ColumnStyleAddColumnPopup(this.servicesUtil);
                Point location = this.addButton.getLocationOnScreen();
                dialog.setLocation(location.x + 15, location.y + 5 + this.addButton.getHeight());
                dialog.setVisible(true);
                dialog.getAddButton().addActionListener(ev -> {
                    String colName = dialog.getColumnName();
                    GraphObjectType tableType = dialog.getTableType();
                    dialog.setVisible(false);
                    this.fireColumnStyleEvent(Action.CREATE, new ColumnSpec(tableType, colName));
                });
            });
        }
        return this.addButton;
    }

    private JButton getDeleteButton() {
        if (this.deleteButton == null) {
            IconManager iconManager = this.servicesUtil.get(IconManager.class);
            this.deleteButton = new JButton("\uf1f8");
            this.deleteButton.setFont(iconManager.getIconFont(17.6f));
            this.deleteButton.setToolTipText("Delete Selected Column Style...");
            this.deleteButton.setBorderPainted(false);
            this.deleteButton.setContentAreaFilled(false);
            this.deleteButton.setFocusPainted(false);
            this.deleteButton.setBorder(BorderFactory.createEmptyBorder());
            this.deleteButton.addActionListener(e -> this.fireColumnStyleEvent(Action.DELETE));
        }
        return this.deleteButton;
    }

    private JTable getJTable() {
        if (this.jtable == null) {
            ColumnStyleTableModel model = new ColumnStyleTableModel();
            this.jtable = new JTable(model);
            this.jtable.setAutoCreateColumnsFromModel(false);
            this.jtable.setDefaultRenderer(GraphObjectType.class, new TableNameRenderer());
            this.jtable.setDefaultRenderer(String.class, new ColumnNameRenderer());
            JTableHeader header = this.jtable.getTableHeader();
            header.setReorderingAllowed(false);
            this.jtable.getColumnModel().getColumn(0).setPreferredWidth(30);
            this.jtable.setSelectionMode(0);
            this.jtable.getSelectionModel().addListSelectionListener(e -> {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                this.fireColumnStyleEvent(Action.SELECT);
            });
        }
        return this.jtable;
    }

    private void fireColumnStyleEvent(Action action) {
        int row = this.jtable.getSelectedRow();
        if (row < 0) {
            return;
        }
        ColumnSpec column = ((ColumnStyleTableModel)this.jtable.getModel()).getColumnSpec(row);
        this.fireColumnStyleEvent(action, column);
    }

    private void fireColumnStyleEvent(Action action, ColumnSpec column) {
        for (BiConsumer<ColumnSpec, Action> listener : this.columnSelectionListeners) {
            listener.accept(column, action);
        }
    }

    public void updateColumnPickerWarnings() {
        int[] sel = this.getJTable().getSelectedRows();
        ((ColumnStyleTableModel)this.getJTable().getModel()).fireTableDataChanged();
        List<BiConsumer<ColumnSpec, Action>> savedListeners = this.columnSelectionListeners;
        this.columnSelectionListeners = List.of();
        for (int row : sel) {
            this.getJTable().addRowSelectionInterval(row, row);
        }
        this.columnSelectionListeners = savedListeners;
    }

    public void updateColumns(List<ColumnSpec> columns, ColumnSpec selectedCol) {
        ColumnStyleTableModel model = new ColumnStyleTableModel(columns);
        this.getJTable().setModel(model);
        if (columns.isEmpty()) {
            return;
        }
        if (selectedCol == null) {
            selectedCol = columns.get(0);
        }
        int row = model.getRowFor(selectedCol);
        this.getJTable().getSelectionModel().setSelectionInterval(row, row);
    }

    public ColumnSpec getSelectedColumn() {
        int row = this.getJTable().getSelectedRow();
        if (row >= 0) {
            return (ColumnSpec)this.getJTable().getModel().getValueAt(row, 1);
        }
        return null;
    }

    private class ColumnStyleTableModel
    extends AbstractTableModel {
        private final List<ColumnSpec> columns;

        private ColumnStyleTableModel(List<ColumnSpec> columns) {
            this.columns = columns;
        }

        private ColumnStyleTableModel() {
            this(List.of());
        }

        public int getRowFor(ColumnSpec column) {
            return this.columns.indexOf(column);
        }

        public ColumnSpec getColumnSpec(int row) {
            return this.columns.get(row);
        }

        @Override
        public int getRowCount() {
            return this.columns.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return switch (col) {
                case 0 -> this.columns.get(row).tableType();
                case 1 -> this.columns.get(row).columnName();
                default -> null;
            };
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return switch (col) {
                case 0 -> GraphObjectType.class;
                case 1 -> String.class;
                default -> null;
            };
        }

        @Override
        public String getColumnName(int col) {
            return switch (col) {
                case 0 -> "Table";
                case 1 -> "Column";
                default -> null;
            };
        }
    }

    public class TableNameRenderer
    extends DefaultTableCellRenderer {
        private final Icon nodeTableIcon;
        private final Icon edgeTableIcon;
        private final Icon netTableIcon;

        private TableNameRenderer() {
            IconManager iconManager = ColumnStylePicker.this.servicesUtil.get(IconManager.class);
            Font iconFont = iconManager.getIconFont("cytoscape-3", 14.0f);
            this.nodeTableIcon = new TextIcon("#", iconFont, 16, 16);
            this.edgeTableIcon = new TextIcon("!", iconFont, 16, 16);
            this.netTableIcon = new TextIcon("\"", iconFont, 16, 16);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jtable, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(jtable, value, isSelected, hasFocus, row, col);
            if (value instanceof GraphObjectType) {
                GraphObjectType type = (GraphObjectType)value;
                Class<? extends CyIdentifiable> t = type.type();
                if (t == CyNode.class) {
                    this.setText("Node");
                    this.setIcon(this.nodeTableIcon);
                } else if (t == CyEdge.class) {
                    this.setText("Edge");
                    this.setIcon(this.edgeTableIcon);
                } else if (t == CyNetwork.class) {
                    this.setText("Network");
                    this.setIcon(this.netTableIcon);
                }
            } else {
                this.setText("-- None --");
                this.setIcon(null);
            }
            return this;
        }
    }

    public class ColumnNameRenderer
    implements TableCellRenderer {
        private final CyColumnPresentationManager columnPresentationManager;
        private final JPanel panel;
        private final DefaultTableCellRenderer colLabel;
        private final DefaultTableCellRenderer warnLabel;

        private ColumnNameRenderer() {
            this.columnPresentationManager = ColumnStylePicker.this.servicesUtil.get(CyColumnPresentationManager.class);
            IconManager iconManager = ColumnStylePicker.this.servicesUtil.get(IconManager.class);
            Font iconFont = iconManager.getIconFont(14.0f);
            TextIcon warnIcon = new TextIcon("\uf071", iconFont, 16, 16);
            this.colLabel = new DefaultTableCellRenderer();
            this.warnLabel = new DefaultTableCellRenderer();
            this.warnLabel.setIcon((Icon)warnIcon);
            this.panel = new JPanel();
            this.panel.setOpaque(false);
            this.panel.setLayout(new BorderLayout());
            this.panel.add((Component)this.colLabel, "Center");
            this.panel.add((Component)this.warnLabel, "East");
        }

        @Override
        public Component getTableCellRendererComponent(JTable jtable, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            this.colLabel.getTableCellRendererComponent(jtable, null, isSelected, hasFocus, row, col);
            this.warnLabel.getTableCellRendererComponent(jtable, null, isSelected, false, row, col);
            if (value instanceof String) {
                String column = (String)value;
                this.columnPresentationManager.setLabel(column, (JLabel)this.colLabel);
                Object object = jtable.getModel().getValueAt(row, 0);
                if (object instanceof GraphObjectType) {
                    GraphObjectType tableType = (GraphObjectType)object;
                    this.warnLabel.setVisible(this.showWarning(tableType, column));
                } else {
                    this.warnLabel.setVisible(false);
                }
            } else {
                this.colLabel.setText("-- None --");
                this.colLabel.setIcon(null);
                this.warnLabel.setVisible(false);
            }
            this.warnLabel.setForeground(LookAndFeelUtil.getWarnColor());
            return this.panel;
        }

        private boolean showWarning(GraphObjectType tableType, String colName) {
            CyApplicationManager appManager = ColumnStylePicker.this.servicesUtil.get(CyApplicationManager.class);
            CyNetworkTableManager netTableManger = ColumnStylePicker.this.servicesUtil.get(CyNetworkTableManager.class);
            CyNetwork network = appManager.getCurrentNetwork();
            if (network == null) {
                return false;
            }
            CyTable table = netTableManger.getTable(network, tableType.type(), "USER");
            if (table == null) {
                return false;
            }
            return table.getColumn(colName) == null;
        }
    }

    public static enum Action {
        SELECT,
        CREATE,
        DELETE;

    }
}

