/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view;

import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CyColumnComboBox;
import org.cytoscape.application.swing.CyColumnPresentationManager;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.view.vizmap.TableVisualMappingManager;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.gui.internal.GraphObjectType;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;

public class ColumnStyleAddColumnPopup
extends JDialog {
    private final ServicesUtil servicesUtil;
    private JButton addButton;
    private JButton cancelButton;
    private JComboBox<String> tableCombo;
    private JComboBox<CyColumn> colCombo;

    public ColumnStyleAddColumnPopup(ServicesUtil servicesUtil) {
        this.servicesUtil = servicesUtil;
        this.setTitle("Add Column Style");
        this.initComponents();
        this.pack();
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                ColumnStyleAddColumnPopup.this.setVisible(false);
            }
        });
    }

    public JButton getAddButton() {
        if (this.addButton == null) {
            this.addButton = new JButton("Add");
        }
        return this.addButton;
    }

    public JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(e -> this.setVisible(false));
        }
        return this.cancelButton;
    }

    public GraphObjectType getTableType() {
        String tabName = this.tableCombo.getItemAt(this.tableCombo.getSelectedIndex());
        return "Node".equals(tabName) ? GraphObjectType.node() : GraphObjectType.edge();
    }

    public String getColumnName() {
        return this.colCombo.getItemAt(this.colCombo.getSelectedIndex()).getName();
    }

    private void initComponents() {
        JLabel tableLabel = new JLabel("Table:");
        JLabel colLabel = new JLabel("Column:");
        JButton addButton = this.getAddButton();
        JButton cancelButton = this.getCancelButton();
        JPanel buttonPanel = LookAndFeelUtil.createOkCancelPanel((JButton)addButton, (JButton)cancelButton);
        CyColumnPresentationManager presentationManager = this.servicesUtil.get(CyColumnPresentationManager.class);
        this.tableCombo = new JComboBox<String>(new String[]{"Node", "Edge"});
        this.colCombo = new CyColumnComboBox(presentationManager, List.of());
        int comboWidth = 300;
        this.updateColumns();
        this.tableCombo.addActionListener(e -> this.updateColumns());
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(tableLabel).addComponent(this.tableCombo)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(colLabel).addComponent(this.colCombo)).addGap(5).addComponent(buttonPanel));
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(tableLabel).addComponent(this.tableCombo, 300, 300, 300)).addGroup(layout.createSequentialGroup().addComponent(colLabel).addComponent(this.colCombo, 300, 300, 300)).addComponent(buttonPanel));
        layout.linkSize(0, tableLabel, colLabel);
        layout.linkSize(0, this.tableCombo, this.colCombo);
    }

    private void updateColumns() {
        CyApplicationManager appManager = this.servicesUtil.get(CyApplicationManager.class);
        TableVisualMappingManager tableVMM = this.servicesUtil.get(TableVisualMappingManager.class);
        VisualMappingManager vmm = this.servicesUtil.get(VisualMappingManager.class);
        VisualStyle netStyle = vmm.getCurrentVisualStyle();
        CyNetwork network = appManager.getCurrentNetwork();
        String tableName = this.tableCombo.getItemAt(this.tableCombo.getSelectedIndex());
        CyTable table = null;
        Class<CyNode> tableType = null;
        if ("Node".equals(tableName)) {
            table = network.getDefaultNodeTable();
            tableType = CyNode.class;
        } else if ("Edge".equals(tableName)) {
            table = network.getDefaultEdgeTable();
            tableType = CyEdge.class;
        }
        this.colCombo.removeAllItems();
        if (table != null) {
            ArrayList<CyColumn> columns = new ArrayList<CyColumn>(table.getColumns());
            columns.sort(ColumnStyleAddColumnPopup.comparingName());
            for (CyColumn col : columns) {
                VisualStyle existingStyle;
                String name = col.getName();
                if ("SUID".equals(name) || "selected".equals(name) || (existingStyle = tableVMM.getAssociatedColumnVisualStyle(netStyle, tableType, name)) != null) continue;
                this.colCombo.addItem(col);
            }
        }
    }

    private static Comparator<CyColumn> comparingName() {
        return (a, b) -> a.getName().compareToIgnoreCase(b.getName());
    }
}

