/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.JSplitPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BiModalJSplitPane
extends JSplitPane {
    private int defaultDividerSize;
    private int oldDividerLocation = -1;
    private boolean dividerManuallyMoved;
    private boolean updatingDivider;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public BiModalJSplitPane(int orientation, Component leftComponent, Component rightComponent) {
        super(orientation, leftComponent, rightComponent);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setOneTouchExpandable(false);
        this.defaultDividerSize = this.getDividerSize();
        this.update();
        this.addPropertyChangeListener("dividerLocation", evt -> {
            if (this.isBothComponentsVisible()) {
                this.oldDividerLocation = this.getDividerLocation();
            }
            if (!this.updatingDivider) {
                this.dividerManuallyMoved = true;
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.getParent().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (BiModalJSplitPane.this.getParent() != null) {
                    BiModalJSplitPane.this.oldDividerLocation = -1;
                }
            }
        });
    }

    public void update() {
        Container parent;
        boolean visible;
        if (this.isBothComponentsVisible()) {
            if (this.dividerSize <= 0 || this.getDividerLocation() < 0) {
                this.showSplit();
            }
        } else if (this.dividerSize > 0 || this.getDividerLocation() >= 0) {
            this.hideSplit();
        }
        Component lc = this.getLeftComponent();
        Component rc = this.getRightComponent();
        boolean bl = visible = lc != null && lc.isVisible() || rc != null && rc.isVisible();
        if (visible != this.isVisible()) {
            this.setVisible(visible);
        }
        if ((parent = this.getParent()) instanceof BiModalJSplitPane) {
            ((BiModalJSplitPane)parent).update();
        }
    }

    private void showSplit() {
        this.updatingDivider = true;
        try {
            this.setDividerSize(this.defaultDividerSize);
            if (this.oldDividerLocation != -1) {
                this.setDividerLocation(this.oldDividerLocation);
            }
            this.resetToPreferredSizes();
            this.validateParent();
        }
        finally {
            this.updatingDivider = false;
        }
    }

    private void hideSplit() {
        this.updatingDivider = true;
        try {
            this.setDividerSize(0);
            if (this.isBothComponentsVisible()) {
                this.oldDividerLocation = this.getDividerLocation();
            }
            this.setDividerLocation(-1);
            this.resetToPreferredSizes();
            this.validateParent();
        }
        finally {
            this.updatingDivider = false;
        }
    }

    private boolean isBothComponentsVisible() {
        Component lc = this.getLeftComponent();
        Component rc = this.getRightComponent();
        return lc != null && lc.isVisible() && rc != null && rc.isVisible();
    }

    private void validateParent() {
        Container container = this.getParent();
        if (container != null) {
            container.validate();
        }
    }
}

