/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.ImageIcon;
import org.cytoscape.view.presentation.property.values.VisualPropertyValue;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;
import org.cytoscape.view.vizmap.mappings.ContinuousMappingPoint;

public final class VisualPropertyUtil {
    public static String getDisplayString(Object value) {
        String s = null;
        if (value instanceof VisualPropertyValue) {
            s = ((VisualPropertyValue)value).getDisplayName();
        } else if (value instanceof Font) {
            s = ((Font)value).getFontName();
        } else if (value instanceof Color) {
            Color c = (Color)value;
            int r = c.getRed();
            int g = c.getGreen();
            int b = c.getBlue();
            s = String.format("R:%s G:%s B:%s - #%02x%02x%02x", r, g, b, r, g, b).toUpperCase();
        } else if (value != null) {
            s = value.toString();
        }
        return s;
    }

    public static Double getMaxValue(ContinuousMapping<?, ?> mapping) {
        List points;
        Double max = null;
        if (mapping != null && !(points = mapping.getAllPoints()).isEmpty()) {
            max = Double.NEGATIVE_INFINITY;
            for (ContinuousMappingPoint p : points) {
                Object value = p.getValue();
                if (!(value instanceof Number)) continue;
                double v = ((Number)value).doubleValue();
                max = Math.max(v, max);
            }
        }
        return max;
    }

    public static Double getMinValue(ContinuousMapping<?, ?> mapping) {
        List points;
        Double min = null;
        if (mapping != null && !(points = mapping.getAllPoints()).isEmpty()) {
            min = Double.POSITIVE_INFINITY;
            for (ContinuousMappingPoint p : points) {
                Object value = p.getValue();
                if (!(value instanceof Number)) continue;
                double v = ((Number)value).doubleValue();
                min = Math.min(v, min);
            }
        }
        return min;
    }

    public static ImageIcon resizeIcon(ImageIcon icon, int width, int height) {
        Image img = icon.getImage().getScaledInstance(width, height, 16);
        BufferedImage bi = new BufferedImage(width, height, 2);
        Graphics2D g = bi.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.drawImage(img, 0, 0, width, height, null);
        g.dispose();
        return new ImageIcon(bi);
    }

    public static Color getContrastingColor(Color color) {
        int d = 0;
        double a = 1.0 - (0.299 * (double)color.getRed() + 0.587 * (double)color.getGreen() + 0.114 * (double)color.getBlue()) / 255.0;
        d = a < 0.5 ? 0 : 255;
        return new Color(d, d, d);
    }

    private VisualPropertyUtil() {
    }
}

