/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.task;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public class SetLockedValuesTask
extends AbstractTask {
    private final Map<VisualProperty<?>, Object> values;
    private final Set<View<? extends CyIdentifiable>> views;
    private final ServicesUtil servicesUtil;
    private final CyNetworkView netView;
    private Map<View<? extends CyIdentifiable>, Map<VisualProperty<?>, Object>> previousViewValues;

    public SetLockedValuesTask(Map<VisualProperty<?>, Object> values, Set<View<? extends CyIdentifiable>> views, CyNetworkView netView, ServicesUtil servicesUtil) {
        this.values = values;
        this.views = views;
        this.netView = netView;
        this.servicesUtil = servicesUtil;
        this.previousViewValues = new HashMap();
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        boolean removed;
        if (this.values != null && this.views != null && this.netView != null && (removed = this.setLockedValues(true))) {
            UndoSupport undo = this.servicesUtil.get(UndoSupport.class);
            undo.postEdit((AbstractCyEdit)new SetLockedValuesEdit());
        }
    }

    private boolean setLockedValues(boolean firstTime) {
        boolean removed = false;
        HashMap previousValues = null;
        for (View<? extends CyIdentifiable> view : this.views) {
            if (firstTime) {
                previousValues = new HashMap();
            }
            for (VisualProperty<?> vp : this.values.keySet()) {
                Object value = this.values.get(vp);
                if (!vp.getTargetDataType().isAssignableFrom(((CyIdentifiable)view.getModel()).getClass())) continue;
                if (firstTime) {
                    previousValues.put(vp, view.isDirectlyLocked(vp) ? view.getVisualProperty(vp) : null);
                }
                view.setLockedValue(vp, value);
                removed = true;
            }
            if (!firstTime || previousValues.isEmpty()) continue;
            this.previousViewValues.put(view, previousValues);
        }
        if (removed) {
            this.updateView();
        }
        return removed;
    }

    private void updateView() {
        VisualStyle style = this.servicesUtil.get(VisualMappingManager.class).getVisualStyle(this.netView);
        style.apply(this.netView);
        this.netView.updateView();
    }

    private boolean isNetworkViewRegistered() {
        CyNetworkViewManager netViewMgr = this.servicesUtil.get(CyNetworkViewManager.class);
        return netViewMgr.getNetworkViews((CyNetwork)this.netView.getModel()).contains(this.netView);
    }

    private class SetLockedValuesEdit
    extends AbstractCyEdit {
        public SetLockedValuesEdit() {
            super("Set Bypass");
        }

        public void undo() {
            if (SetLockedValuesTask.this.isNetworkViewRegistered()) {
                for (Map.Entry<View<CyIdentifiable>, Map<VisualProperty<?>, Object>> entry : SetLockedValuesTask.this.previousViewValues.entrySet()) {
                    View<? extends CyIdentifiable> view = entry.getKey();
                    Map<VisualProperty<?>, Object> previousValues = entry.getValue();
                    for (VisualProperty<?> vp : previousValues.keySet()) {
                        Object value = previousValues.get(vp);
                        if (value != null) {
                            view.setLockedValue(vp, value);
                            continue;
                        }
                        view.clearValueLock(vp);
                    }
                }
                SetLockedValuesTask.this.updateView();
            }
        }

        public void redo() {
            if (SetLockedValuesTask.this.isNetworkViewRegistered()) {
                SetLockedValuesTask.this.setLockedValues(false);
            }
        }
    }
}

