/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.task;

import java.io.IOException;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.VisualStyleFactory;
import org.cytoscape.view.vizmap.gui.internal.model.VizMapperProxy;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.TunableValidator;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public class CreateNewVisualStyleTask
extends AbstractTask
implements TunableValidator {
    public static final String TITLE = "Create New Style";
    @Tunable(description="Name of new Style:")
    public String vsName;
    private VisualStyle newStyle;
    private VisualStyle previousCurrentStyle;
    private final ServicesUtil servicesUtil;

    public CreateNewVisualStyleTask(ServicesUtil servicesUtil) {
        this.servicesUtil = servicesUtil;
    }

    @ProvidesTitle
    public String getTitle() {
        return TITLE;
    }

    public void run(TaskMonitor tm) {
        if (this.vsName != null) {
            this.createVisualStyle();
            UndoSupport undo = this.servicesUtil.get(UndoSupport.class);
            undo.postEdit((AbstractCyEdit)new CreateNewVisualStyleEdit());
        }
    }

    public TunableValidator.ValidationState getValidationState(Appendable errMsg) {
        VisualMappingManager vmMgr = this.servicesUtil.get(VisualMappingManager.class);
        for (VisualStyle vs : vmMgr.getAllVisualStyles()) {
            if (!vs.getTitle().equalsIgnoreCase(this.vsName)) continue;
            try {
                errMsg.append("Visual style " + this.vsName + " already existed.");
                return TunableValidator.ValidationState.INVALID;
            }
            catch (IOException iOException) {
            }
        }
        return TunableValidator.ValidationState.OK;
    }

    private void createVisualStyle() {
        VisualStyleFactory vsFactory = this.servicesUtil.get(VisualStyleFactory.class);
        VizMapperProxy proxy = (VizMapperProxy)this.servicesUtil.getProxy("VisualStyleProxy");
        this.newStyle = vsFactory.createVisualStyle(proxy.getOriginalDefaultVisualStyle());
        this.newStyle.setTitle(this.vsName);
        VisualMappingManager vmMgr = this.servicesUtil.get(VisualMappingManager.class);
        this.previousCurrentStyle = vmMgr.getCurrentVisualStyle();
        vmMgr.addVisualStyle(this.newStyle);
        vmMgr.setCurrentVisualStyle(this.newStyle);
    }

    private class CreateNewVisualStyleEdit
    extends AbstractCyEdit {
        public CreateNewVisualStyleEdit() {
            super(CreateNewVisualStyleTask.this.getTitle());
        }

        public void undo() {
            VisualMappingManager vmMgr = CreateNewVisualStyleTask.this.servicesUtil.get(VisualMappingManager.class);
            if (CreateNewVisualStyleTask.this.newStyle != null && vmMgr.getAllVisualStyles().contains(CreateNewVisualStyleTask.this.newStyle)) {
                vmMgr.removeVisualStyle(CreateNewVisualStyleTask.this.newStyle);
                if (CreateNewVisualStyleTask.this.previousCurrentStyle != null) {
                    vmMgr.setCurrentVisualStyle(CreateNewVisualStyleTask.this.previousCurrentStyle);
                }
            }
        }

        public void redo() {
            VisualMappingManager vmMgr = CreateNewVisualStyleTask.this.servicesUtil.get(VisualMappingManager.class);
            if (CreateNewVisualStyleTask.this.newStyle != null && !vmMgr.getAllVisualStyles().contains(CreateNewVisualStyleTask.this.newStyle)) {
                vmMgr.addVisualStyle(CreateNewVisualStyleTask.this.newStyle);
                vmMgr.setCurrentVisualStyle(CreateNewVisualStyleTask.this.newStyle);
            }
        }
    }
}

