/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.task;

import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.mappings.BoundaryRangeValues;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;
import org.cytoscape.view.vizmap.mappings.ContinuousMappingPoint;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public class CopyContinuousMappingTask
extends AbstractTask {
    private final VisualStyle sourceStyle;
    private final VisualProperty<?> sourceVP;
    private final VisualStyle targetStyle;
    private final VisualProperty<?> targetVP;
    private final ServicesUtil servicesUtil;

    public CopyContinuousMappingTask(VisualStyle sourceStyle, VisualProperty<?> sourceVP, VisualStyle targetStyle, VisualProperty<?> targetVP, ServicesUtil servicesUtil) {
        this.sourceStyle = sourceStyle;
        this.sourceVP = sourceVP;
        this.targetStyle = targetStyle;
        this.targetVP = targetVP;
        this.servicesUtil = servicesUtil;
    }

    public void run(TaskMonitor tm) {
        VisualMappingFunction sourceMapping = this.sourceStyle.getVisualMappingFunction(this.sourceVP);
        if (sourceMapping instanceof ContinuousMapping) {
            ContinuousMapping cm = (ContinuousMapping)sourceMapping;
            VisualMappingFunction existingMapping = this.targetStyle.getVisualMappingFunction(this.targetVP);
            VisualMappingFunction newMapping = this.cloneMapping(cm);
            this.targetStyle.addVisualMappingFunction(newMapping);
            this.servicesUtil.get(UndoSupport.class).postEdit((AbstractCyEdit)new CopyContinuousMappingEdit(this.targetStyle, existingMapping, newMapping));
        }
    }

    private <K, V> VisualMappingFunction<K, V> cloneMapping(ContinuousMapping<K, V> mapping) {
        VisualMappingFunctionFactory factory = this.servicesUtil.get(VisualMappingFunctionFactory.class, "(mapping.type=continuous)");
        String attrName = mapping.getMappingColumnName();
        Class attrType = mapping.getMappingColumnType();
        ContinuousMapping newMapping = (ContinuousMapping)factory.createVisualMappingFunction(attrName, attrType, this.targetVP);
        for (ContinuousMappingPoint point : mapping.getAllPoints()) {
            newMapping.addPoint(point.getValue(), new BoundaryRangeValues(point.getRange()));
        }
        return newMapping;
    }

    private static class CopyContinuousMappingEdit
    extends AbstractCyEdit {
        private final VisualStyle targetStyle;
        private final VisualMappingFunction<?, ?> originalMapping;
        private final VisualMappingFunction<?, ?> newMapping;

        public CopyContinuousMappingEdit(VisualStyle targetStyle, VisualMappingFunction<?, ?> originalMapping, VisualMappingFunction<?, ?> newMapping) {
            super("Copy Mapping");
            this.originalMapping = originalMapping;
            this.newMapping = newMapping;
            this.targetStyle = targetStyle;
        }

        public void undo() {
            if (this.originalMapping == null) {
                this.targetStyle.removeVisualMappingFunction(this.newMapping.getVisualProperty());
            } else {
                this.targetStyle.addVisualMappingFunction(this.originalMapping);
            }
        }

        public void redo() {
            this.targetStyle.addVisualMappingFunction(this.newMapping);
        }
    }
}

