/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.model;

import java.text.Collator;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JPanel;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.NetworkViewRenderer;
import org.cytoscape.application.TableViewRenderer;
import org.cytoscape.application.events.CyStartEvent;
import org.cytoscape.application.events.CyStartListener;
import org.cytoscape.application.events.SetCurrentNetworkEvent;
import org.cytoscape.application.events.SetCurrentNetworkListener;
import org.cytoscape.application.events.SetCurrentNetworkViewEvent;
import org.cytoscape.application.events.SetCurrentNetworkViewListener;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableFactory;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.session.CySessionManager;
import org.cytoscape.session.events.SessionAboutToBeLoadedEvent;
import org.cytoscape.session.events.SessionAboutToBeLoadedListener;
import org.cytoscape.session.events.SessionLoadedEvent;
import org.cytoscape.session.events.SessionLoadedListener;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.model.table.CyTableView;
import org.cytoscape.view.model.table.CyTableViewFactory;
import org.cytoscape.view.model.table.CyTableViewManager;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.RenderingEngineFactory;
import org.cytoscape.view.presentation.RenderingEngineManager;
import org.cytoscape.view.vizmap.TableVisualMappingManager;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualPropertyDependency;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.VisualStyleFactory;
import org.cytoscape.view.vizmap.events.SetCurrentVisualStyleEvent;
import org.cytoscape.view.vizmap.events.SetCurrentVisualStyleListener;
import org.cytoscape.view.vizmap.events.VisualStyleAboutToBeRemovedEvent;
import org.cytoscape.view.vizmap.events.VisualStyleAboutToBeRemovedListener;
import org.cytoscape.view.vizmap.events.VisualStyleAddedEvent;
import org.cytoscape.view.vizmap.events.VisualStyleAddedListener;
import org.cytoscape.view.vizmap.events.VisualStyleChangedEvent;
import org.cytoscape.view.vizmap.events.VisualStyleChangedListener;
import org.cytoscape.view.vizmap.events.table.ColumnAssociatedVisualStyleSetEvent;
import org.cytoscape.view.vizmap.events.table.ColumnAssociatedVisualStyleSetListener;
import org.cytoscape.view.vizmap.gui.internal.VisualStyleSet;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.gui.util.PropertySheetUtil;
import org.puremvc.java.multicore.patterns.proxy.Proxy;

public class VizMapperProxy
extends Proxy
implements VisualStyleAddedListener,
VisualStyleAboutToBeRemovedListener,
VisualStyleChangedListener,
SetCurrentVisualStyleListener,
SetCurrentNetworkListener,
SetCurrentNetworkViewListener,
ColumnAssociatedVisualStyleSetListener,
SessionAboutToBeLoadedListener,
SessionLoadedListener,
CyStartListener {
    public static final String NAME = "VisualStyleProxy";
    public static final String PRESET_VIZMAP_FILE = "default_vizmap.xml";
    private final SortedSet<VisualStyle> visualStyles;
    private final ServicesUtil servicesUtil;
    private VisualStyle originalDefaultVisualStyle;
    private RenderingEngine<CyTable> dummyTableRenderingEngine;
    private volatile boolean cytoscapeStarted;
    private volatile boolean loadingSession;
    private final AtomicBoolean ignoreStyleEvents = new AtomicBoolean(false);
    private final Object lock = new Object();

    public VizMapperProxy(ServicesUtil servicesUtil) {
        super(NAME, new TreeSet<VisualStyle>(new Comparator<VisualStyle>(){

            @Override
            public int compare(VisualStyle vs1, VisualStyle vs2) {
                Collator collator = Collator.getInstance(Locale.getDefault());
                collator.setStrength(0);
                return collator.compare(vs1.getTitle(), vs2.getTitle());
            }
        }));
        this.visualStyles = (SortedSet)this.getData();
        this.servicesUtil = servicesUtil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<VisualStyle> getVisualStyles() {
        Object object = this.lock;
        synchronized (object) {
            return new TreeSet<VisualStyle>(this.visualStyles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadVisualStyles() {
        boolean changed = false;
        SortedSet<VisualStyle> updatedStyles = null;
        Object object = this.lock;
        synchronized (object) {
            Set<VisualStyle> allStyles = this.getAllVisualStyles();
            if (!allStyles.isEmpty() || !this.visualStyles.isEmpty()) {
                VisualStyle defStyle = this.servicesUtil.get(VisualMappingManager.class).getDefaultVisualStyle();
                this.originalDefaultVisualStyle = this.servicesUtil.get(VisualStyleFactory.class).createVisualStyle(defStyle);
                this.visualStyles.clear();
                this.visualStyles.addAll(allStyles);
                updatedStyles = this.getVisualStyles();
                changed = true;
            }
        }
        if (changed && this.cytoscapeStarted) {
            this.sendNotification("VISUAL_STYLE_SET_CHANGED", updatedStyles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVisualStyle(VisualStyle vs) {
        Object object = this.lock;
        synchronized (object) {
            if (vs != null) {
                this.servicesUtil.get(VisualMappingManager.class).addVisualStyle(vs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVisualStyle(VisualStyle vs) {
        Object object = this.lock;
        synchronized (object) {
            if (vs != null) {
                this.servicesUtil.get(VisualMappingManager.class).removeVisualStyle(vs);
            }
        }
    }

    public VisualStyle getOriginalDefaultVisualStyle() {
        return this.originalDefaultVisualStyle;
    }

    public boolean isDefaultStyle(VisualStyle vs) {
        return vs.equals(this.getDefaultVisualStyle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VisualStyle getDefaultVisualStyle() {
        Object object = this.lock;
        synchronized (object) {
            return this.servicesUtil.get(VisualMappingManager.class).getDefaultVisualStyle();
        }
    }

    public RenderingEngine<CyTable> getDummyTableRenderingEngine() {
        if (this.dummyTableRenderingEngine == null) {
            TableViewRenderer tableViewRenderer = this.servicesUtil.get(CyApplicationManager.class).getDefaultTableViewRenderer();
            RenderingEngineFactory factory = tableViewRenderer.getRenderingEngineFactory("");
            CyTableFactory tableFactory = this.servicesUtil.get(CyTableFactory.class);
            CyTable table = tableFactory.createTable("dummy_table", "pk", Long.class, false, false);
            CyTableView tableView = this.servicesUtil.get(CyTableViewFactory.class).createTableView(table);
            this.dummyTableRenderingEngine = factory.createRenderingEngine((Object)new JPanel(), (View)tableView);
        }
        return this.dummyTableRenderingEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VisualStyle getCurrentNetworkVisualStyle() {
        Object object = this.lock;
        synchronized (object) {
            VisualMappingManager vmm = this.servicesUtil.get(VisualMappingManager.class);
            return vmm.getCurrentVisualStyle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VisualStyleSet getCurrentVisualStyleSet() {
        Object object = this.lock;
        synchronized (object) {
            VisualMappingManager vmm = this.servicesUtil.get(VisualMappingManager.class);
            VisualStyle netStyle = vmm.getCurrentVisualStyle();
            if (netStyle == null) {
                return null;
            }
            TableVisualMappingManager tvmm = this.servicesUtil.get(TableVisualMappingManager.class);
            Map nodeColStyles = tvmm.getAssociatedColumnVisualStyles(netStyle, CyNode.class);
            Map edgeColStyles = tvmm.getAssociatedColumnVisualStyles(netStyle, CyEdge.class);
            return new VisualStyleSet(netStyle, nodeColStyles, edgeColStyles);
        }
    }

    public void setCurrentNetworkVisualStyle(VisualStyle vs) {
        VisualStyle curVs = this.getCurrentNetworkVisualStyle();
        VisualMappingManager vmMgr = this.servicesUtil.get(VisualMappingManager.class);
        if (vs != null && !vs.equals(curVs)) {
            vmMgr.setCurrentVisualStyle(vs);
        }
    }

    public VisualStyle getNetworkVisualStyle(CyNetworkView view) {
        return this.servicesUtil.get(VisualMappingManager.class).getVisualStyle(view);
    }

    public CyNetwork getCurrentNetwork() {
        return this.servicesUtil.get(CyApplicationManager.class).getCurrentNetwork();
    }

    public CyNetworkView getCurrentNetworkView() {
        return this.servicesUtil.get(CyApplicationManager.class).getCurrentNetworkView();
    }

    public RenderingEngine<CyNetwork> getCurrentNetworkRenderingEngine() {
        return this.servicesUtil.get(CyApplicationManager.class).getCurrentRenderingEngine();
    }

    public RenderingEngine<?> getRenderingEngine(Class<? extends CyIdentifiable> lexiconType) {
        if (lexiconType == CyNode.class || lexiconType == CyEdge.class || lexiconType == CyNetwork.class) {
            return this.getCurrentNetworkRenderingEngine();
        }
        RenderingEngineManager engineManager = this.servicesUtil.get(RenderingEngineManager.class);
        CyTableViewManager tableViewManager = this.servicesUtil.get(CyTableViewManager.class);
        CyNetwork net = this.getCurrentNetwork();
        if (net == null) {
            return null;
        }
        CyTable table = net.getDefaultNodeTable();
        CyTableView tableView = tableViewManager.getTableView(table);
        Collection engines = engineManager.getRenderingEngines((View)tableView);
        return engines.isEmpty() ? null : (RenderingEngine)engines.iterator().next();
    }

    public RenderingEngineFactory<CyNetwork> getCurrentNetworkRenderingEngineFactory() {
        NetworkViewRenderer nvRenderer = this.servicesUtil.get(CyApplicationManager.class).getCurrentNetworkViewRenderer();
        if (nvRenderer != null) {
            return nvRenderer.getRenderingEngineFactory("");
        }
        return this.servicesUtil.get(RenderingEngineFactory.class);
    }

    public NetworkViewRenderer getNetworkViewRenderer(CyNetworkView netView) {
        return this.getNetworkViewRenderer(netView.getRendererId());
    }

    public NetworkViewRenderer getNetworkViewRenderer(String rendererId) {
        return this.servicesUtil.get(CyApplicationManager.class).getNetworkViewRenderer(rendererId);
    }

    public RenderingEngineFactory<CyNetwork> getNetworkRenderingEngineFactory(CyNetworkView netView) {
        return this.getNetworkViewRenderer(netView).getRenderingEngineFactory("");
    }

    public VisualLexicon getCurrentLexicon(Class<? extends CyIdentifiable> lexiconType) {
        if (lexiconType == CyNode.class || lexiconType == CyEdge.class || lexiconType == CyNetwork.class) {
            return this.getCurrentNetworkVisualLexicon();
        }
        return this.getCurrentTableVisualLexicon();
    }

    public VisualLexicon getCurrentNetworkVisualLexicon() {
        RenderingEngine<CyNetwork> engine;
        VisualLexicon lexicon = null;
        RenderingEngineFactory<CyNetwork> factory = this.getCurrentNetworkRenderingEngineFactory();
        if (factory != null) {
            lexicon = factory.getVisualLexicon();
        }
        if (lexicon == null && (engine = this.getCurrentNetworkRenderingEngine()) != null) {
            lexicon = engine.getVisualLexicon();
        }
        if (lexicon == null) {
            lexicon = this.servicesUtil.get(RenderingEngineManager.class).getDefaultVisualLexicon();
        }
        return lexicon;
    }

    public VisualLexicon getCurrentTableVisualLexicon() {
        VisualLexicon defaultTableLexicon = this.servicesUtil.get(RenderingEngineManager.class).getDefaultTableVisualLexicon();
        CyNetwork currNet = this.servicesUtil.get(CyApplicationManager.class).getCurrentNetwork();
        if (currNet == null) {
            return defaultTableLexicon;
        }
        CyTable nodeTable = currNet.getDefaultNodeTable();
        CyTableView tableView = this.servicesUtil.get(CyTableViewManager.class).getTableView(nodeTable);
        if (tableView == null) {
            return defaultTableLexicon;
        }
        Collection engines = this.servicesUtil.get(RenderingEngineManager.class).getRenderingEngines((View)tableView);
        if (engines == null || engines.isEmpty()) {
            return defaultTableLexicon;
        }
        return ((RenderingEngine)engines.iterator().next()).getVisualLexicon();
    }

    public Set<View<CyNode>> getSelectedNodeViews(CyNetworkView netView) {
        HashSet<View<CyNode>> views = new HashSet<View<CyNode>>();
        if (netView != null) {
            List nodes = CyTableUtil.getNodesInState((CyNetwork)((CyNetwork)netView.getModel()), (String)"selected", (boolean)true);
            for (CyNode n : nodes) {
                View nv = netView.getNodeView(n);
                if (nv == null) continue;
                views.add((View<CyNode>)nv);
            }
        }
        return views;
    }

    public Set<View<CyEdge>> getSelectedEdgeViews(CyNetworkView netView) {
        HashSet<View<CyEdge>> views = new HashSet<View<CyEdge>>();
        if (netView != null) {
            List edges = CyTableUtil.getEdgesInState((CyNetwork)((CyNetwork)netView.getModel()), (String)"selected", (boolean)true);
            for (CyEdge e : edges) {
                View ev = netView.getEdgeView(e);
                if (ev == null) continue;
                views.add((View<CyEdge>)ev);
            }
        }
        return views;
    }

    public Set<CyNetworkView> getNetworkViewsWithStyle(VisualStyle style) {
        HashSet<CyNetworkView> views = new HashSet<CyNetworkView>();
        if (style != null) {
            VisualMappingManager vmMgr = this.servicesUtil.get(VisualMappingManager.class);
            Set allNetViews = this.servicesUtil.get(CyNetworkViewManager.class).getNetworkViewSet();
            for (CyNetworkView nv : allNetViews) {
                if (!style.equals(vmMgr.getVisualStyle(nv))) continue;
                views.add(nv);
            }
        }
        return views;
    }

    public int countNetworkViewsWithStyle(VisualStyle style) {
        int count = 0;
        if (style != null) {
            VisualMappingManager vmMgr = this.servicesUtil.get(VisualMappingManager.class);
            Set allNetViews = this.servicesUtil.get(CyNetworkViewManager.class).getNetworkViewSet();
            for (CyNetworkView nv : allNetViews) {
                if (!style.equals(vmMgr.getVisualStyle(nv))) continue;
                ++count;
            }
        }
        return count;
    }

    public static boolean isSupported(VisualLexicon lexicon, VisualProperty<?> vp) {
        return PropertySheetUtil.isCompatible(vp) != false && lexicon.isSupported(vp);
    }

    public static boolean isSupported(VisualLexicon lexicon, VisualPropertyDependency<?> dependency) {
        if (!VizMapperProxy.isSupported(lexicon, dependency.getParentVisualProperty())) {
            return false;
        }
        for (VisualProperty vp : dependency.getVisualProperties()) {
            if (VizMapperProxy.isSupported(lexicon, vp)) continue;
            return false;
        }
        return true;
    }

    public void setIgnoreStyleEvents(boolean b) {
        this.ignoreStyleEvents.set(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(VisualStyleAddedEvent e) {
        if (!this.cytoscapeStarted || this.ignoreStyleEvents.get()) {
            return;
        }
        VisualStyle vs = e.getVisualStyleAdded();
        boolean changed = false;
        Object object = this.lock;
        synchronized (object) {
            changed = this.visualStyles.add(vs);
        }
        if (changed && !this.loadingSession) {
            this.sendNotification("VISUAL_STYLE_ADDED", vs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(VisualStyleAboutToBeRemovedEvent e) {
        if (!this.cytoscapeStarted || this.ignoreStyleEvents.get()) {
            return;
        }
        VisualStyle vs = e.getVisualStyleToBeRemoved();
        boolean changed = false;
        Object object = this.lock;
        synchronized (object) {
            changed = this.visualStyles.remove(vs);
        }
        if (changed && !this.loadingSession) {
            this.sendNotification("VISUAL_STYLE_REMOVED", vs);
        }
    }

    public void handleEvent(VisualStyleChangedEvent e) {
        if (this.ignoreStyleEvents.get()) {
            return;
        }
        if (this.cytoscapeStarted && !this.loadingSession) {
            this.sendNotification("VISUAL_STYLE_UPDATED", e.getSource());
        }
    }

    public void handleEvent(SetCurrentVisualStyleEvent e) {
        if (this.cytoscapeStarted && !this.loadingSession) {
            this.sendNotification("CURRENT_VISUAL_STYLE_CHANGED", e.getVisualStyle());
        }
    }

    public void handleEvent(ColumnAssociatedVisualStyleSetEvent e) {
        if (this.cytoscapeStarted && !this.loadingSession) {
            this.sendNotification("TABLE_ASSOCIATED_VISUAL_STYLE_UPDATED", e.getAssociation());
        }
    }

    public void handleEvent(SetCurrentNetworkEvent e) {
        if (this.cytoscapeStarted && !this.loadingSession) {
            this.sendNotification("CURRENT_NETWORK_CHANGED", e.getNetwork());
        }
    }

    public void handleEvent(SetCurrentNetworkViewEvent e) {
        if (this.cytoscapeStarted && !this.loadingSession) {
            this.sendNotification("CURRENT_NETWORK_VIEW_CHANGED", e.getNetworkView());
        }
    }

    public void handleEvent(CyStartEvent e) {
        this.cytoscapeStarted = true;
        if (this.servicesUtil.get(CySessionManager.class).getCurrentSessionFileName() == null) {
            this.sendNotification("LOAD_DEFAULT_VISUAL_STYLES");
        } else {
            this.loadVisualStyles();
        }
    }

    public void handleEvent(SessionAboutToBeLoadedEvent e) {
        this.loadingSession = true;
    }

    public void handleEvent(SessionLoadedEvent e) {
        this.loadingSession = false;
        if (e.getLoadedFileName() == null) {
            this.sendNotification("LOAD_DEFAULT_VISUAL_STYLES");
        } else {
            this.sendNotification("VISUAL_STYLE_SET_CHANGED", this.getVisualStyles());
        }
    }

    private Set<VisualStyle> getAllVisualStyles() {
        return this.servicesUtil.get(VisualMappingManager.class).getAllVisualStyles();
    }
}

