/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.model;

import java.text.Collator;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.gui.MappingFunctionFactoryManager;
import org.cytoscape.view.vizmap.gui.internal.GraphObjectType;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;
import org.puremvc.java.multicore.patterns.proxy.Proxy;

public class MappingFunctionFactoryProxy
extends Proxy {
    public static final String NAME = "MappingFunctionFactoryProxy";
    private String currentColumnName;
    private GraphObjectType currentTargetDataType;
    private final ServicesUtil servicesUtil;

    public MappingFunctionFactoryProxy(ServicesUtil servicesUtil) {
        super(NAME);
        this.servicesUtil = servicesUtil;
    }

    public void setCurrentColumnName(String name) {
        this.currentColumnName = name;
    }

    public String getCurrentColumnName() {
        return this.currentColumnName;
    }

    public void setCurrentTargetDataType(GraphObjectType type) {
        this.currentTargetDataType = type;
    }

    public GraphObjectType getCurrentTargetDataType() {
        return this.currentTargetDataType;
    }

    public Set<VisualMappingFunctionFactory> getMappingFactories() {
        CyTable table;
        CyColumn column;
        CyApplicationManager appMgr;
        CyNetwork net;
        Collator collator = Collator.getInstance(Locale.getDefault());
        collator.setStrength(0);
        TreeSet<VisualMappingFunctionFactory> set = new TreeSet<VisualMappingFunctionFactory>((f1, f2) -> collator.compare(f1.toString(), f2.toString()));
        MappingFunctionFactoryManager mappingFactoryMgr = this.servicesUtil.get(MappingFunctionFactoryManager.class);
        set.addAll(mappingFactoryMgr.getFactories());
        if (this.currentColumnName != null && this.currentTargetDataType != null && (net = (appMgr = this.servicesUtil.get(CyApplicationManager.class)).getCurrentNetwork()) != null && (column = (table = net.getTable(this.currentTargetDataType.type(), "USER")).getColumn(this.currentColumnName)) != null && !Number.class.isAssignableFrom(column.getType())) {
            set.remove(mappingFactoryMgr.getFactory(ContinuousMapping.class));
        }
        return set;
    }
}

