/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.event;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.HashMap;
import java.util.Map;
import org.cytoscape.view.presentation.RenderingEngineFactory;
import org.cytoscape.view.vizmap.gui.editor.EditorManager;
import org.cytoscape.view.vizmap.gui.event.VizMapEventHandler;
import org.cytoscape.view.vizmap.gui.event.VizMapEventHandlerManager;
import org.cytoscape.view.vizmap.gui.internal.event.CellEditorEventHandler;
import org.cytoscape.view.vizmap.gui.internal.model.AttributeSetProxy;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.gui.internal.view.VizMapPropertyBuilder;
import org.cytoscape.view.vizmap.gui.internal.view.VizMapperMediator;
import org.cytoscape.view.vizmap.gui.internal.view.util.ViewUtil;

public class VizMapEventHandlerManagerImpl
implements VizMapEventHandlerManager,
PropertyChangeListener {
    private static final String VALUE = "VALUE";
    private final Map<String, VizMapEventHandler> eventHandlers;
    private final EditorManager editorManager;
    private final AttributeSetProxy attrManager;
    private final ServicesUtil servicesUtil;

    public VizMapEventHandlerManagerImpl(EditorManager editorManager, AttributeSetProxy attrManager, ServicesUtil servicesUtil, VizMapPropertyBuilder vizMapPropertyBuilder, VizMapperMediator vizMapperMediator) {
        this.editorManager = editorManager;
        this.attrManager = attrManager;
        this.servicesUtil = servicesUtil;
        this.eventHandlers = new HashMap<String, VizMapEventHandler>();
        this.createHandlers(vizMapPropertyBuilder, vizMapperMediator);
    }

    public void registerPCL(RenderingEngineFactory<?> factory, Map props) {
        this.registerCellEditorListeners();
    }

    public void unregisterPCL(RenderingEngineFactory<?> factory, Map props) {
    }

    @Override
    public VizMapEventHandler getHandler(String name) {
        return this.eventHandlers.get(name);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String handlerKey = e.getPropertyName();
        if (handlerKey == null) {
            return;
        }
        VizMapEventHandler handler = this.getHandler(handlerKey.toUpperCase());
        if (handler != null) {
            ViewUtil.invokeOnEDT(() -> handler.processEvent(e));
        }
    }

    private void createHandlers(VizMapPropertyBuilder vizMapPropertyBuilder, VizMapperMediator vizMapperMediator) {
        this.eventHandlers.put(VALUE, new CellEditorEventHandler(this.attrManager, this.servicesUtil, vizMapPropertyBuilder, vizMapperMediator));
    }

    private void registerCellEditorListeners() {
        for (PropertyEditor p : this.editorManager.getCellEditors()) {
            p.removePropertyChangeListener(this);
            p.addPropertyChangeListener(this);
        }
        for (PropertyEditor p : this.editorManager.getAttributeSelectors()) {
            p.removePropertyChangeListener(this);
            p.addPropertyChangeListener(this);
        }
        PropertyEditor mappingSelector = this.editorManager.getMappingFunctionSelector();
        mappingSelector.addPropertyChangeListener(this);
    }
}

