/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.event;

import com.l2fprod.common.propertysheet.PropertySheetPanel;
import com.l2fprod.common.propertysheet.PropertySheetTableModel;
import java.beans.PropertyChangeEvent;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import javax.swing.JOptionPane;
import javax.swing.event.TableModelListener;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkTableManager;
import org.cytoscape.model.CyTable;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.gui.event.VizMapEventHandler;
import org.cytoscape.view.vizmap.gui.internal.GraphObjectType;
import org.cytoscape.view.vizmap.gui.internal.VizMapperProperty;
import org.cytoscape.view.vizmap.gui.internal.event.CellType;
import org.cytoscape.view.vizmap.gui.internal.model.AttributeSet;
import org.cytoscape.view.vizmap.gui.internal.model.AttributeSetProxy;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.gui.internal.view.VisualPropertySheetItem;
import org.cytoscape.view.vizmap.gui.internal.view.VizMapPropertyBuilder;
import org.cytoscape.view.vizmap.gui.internal.view.VizMapperMediator;
import org.cytoscape.view.vizmap.gui.internal.view.editor.propertyeditor.AttributeComboBoxPropertyEditor;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;
import org.cytoscape.view.vizmap.mappings.ContinuousMappingPoint;
import org.cytoscape.view.vizmap.mappings.DiscreteMapping;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public final class CellEditorEventHandler
implements VizMapEventHandler {
    private final AttributeSetProxy attrProxy;
    private final ServicesUtil servicesUtil;
    private final VizMapperMediator vizMapperMediator;
    private final VizMapPropertyBuilder vizMapPropertyBuilder;

    public CellEditorEventHandler(AttributeSetProxy attrProxy, ServicesUtil servicesUtil, VizMapPropertyBuilder vizMapPropertyBuilder, VizMapperMediator vizMapperMediator) {
        this.attrProxy = attrProxy;
        this.servicesUtil = servicesUtil;
        this.vizMapPropertyBuilder = vizMapPropertyBuilder;
        this.vizMapperMediator = vizMapperMediator;
    }

    @Override
    public void processEvent(PropertyChangeEvent e) {
        PropertySheetPanel propSheetPnl;
        Object oldVal;
        Object newVal = e.getNewValue();
        if (Objects.equals(newVal, oldVal = e.getOldValue())) {
            return;
        }
        final VisualPropertySheetItem<?> vpSheetItem = this.vizMapperMediator.getCurrentVisualPropertySheetItem();
        PropertySheetPanel propertySheetPanel = propSheetPnl = vpSheetItem != null ? vpSheetItem.getPropSheetPnl() : null;
        if (propSheetPnl == null) {
            return;
        }
        VizMapperProperty<?, ?, ?> prop = this.vizMapperMediator.getCurrentVizMapperProperty();
        if (prop == null) {
            return;
        }
        VisualProperty<?> vp = vpSheetItem.getModel().getVisualProperty();
        final VisualMappingFunction<?, ?> mapping = vpSheetItem.getModel().getVisualMappingFunction();
        GraphObjectType graphObjectType = vpSheetItem.getModel().getTableType();
        if (prop.getCellType() == CellType.DISCRETE && mapping instanceof DiscreteMapping) {
            DiscreteMapping discMap = (DiscreteMapping)mapping;
            this.setDiscreteMappingEntry(prop.getKey(), oldVal, newVal, (DiscreteMapping<Object, Object>)discMap);
        } else {
            VisualMappingFunction<?, ?> newMapping = mapping;
            String undoName = null;
            if (prop.getCellType() == CellType.VISUAL_PROPERTY_TYPE) {
                if (newVal != null && e.getSource() instanceof AttributeComboBoxPropertyEditor) {
                    AttributeComboBoxPropertyEditor editor = (AttributeComboBoxPropertyEditor)e.getSource();
                    VisualMappingFunctionFactory factory = (VisualMappingFunctionFactory)propSheetPnl.getTable().getValueAt(1, 1);
                    newMapping = this.switchColumn(factory, editor, prop, newVal.toString(), propSheetPnl);
                    vpSheetItem.getModel().setVisualMappingFunction(newMapping);
                    if (newMapping == null) {
                        vpSheetItem.getModel().setMappingColumnName(prop.getValue() != null ? prop.getValue().toString() : null);
                    }
                    undoName = "Set Mapping Column";
                }
            } else if (prop.getCellType() == CellType.MAPPING_TYPE) {
                Object controllingAttrName = propSheetPnl.getTable().getValueAt(0, 1);
                if (vp != null && controllingAttrName != null && (newVal == null || newVal instanceof VisualMappingFunctionFactory)) {
                    newMapping = this.switchMappingType(prop, vp, graphObjectType, (VisualMappingFunctionFactory)oldVal, (VisualMappingFunctionFactory)newVal, controllingAttrName.toString(), propSheetPnl);
                    vpSheetItem.getModel().setVisualMappingFunction(newMapping);
                    undoName = "Set Mapping Type";
                }
            }
            if (newMapping != mapping && undoName != null) {
                final VisualMappingFunction<?, ?> myNewMapping = newMapping;
                UndoSupport undo = this.servicesUtil.get(UndoSupport.class);
                undo.postEdit(new AbstractCyEdit(undoName){

                    public void undo() {
                        vpSheetItem.getModel().setVisualMappingFunction(mapping);
                    }

                    public void redo() {
                        vpSheetItem.getModel().setVisualMappingFunction(myNewMapping);
                    }
                });
            }
        }
    }

    private VisualMappingFunction<?, ?> switchColumn(VisualMappingFunctionFactory factory, AttributeComboBoxPropertyEditor editor, VizMapperProperty<?, ?, ?> prop, String columnName, PropertySheetPanel propertySheetPanel) {
        VisualStyle currentStyle = this.servicesUtil.get(VisualMappingManager.class).getCurrentVisualStyle();
        VisualProperty vp = (VisualProperty)prop.getKey();
        VisualMappingFunction mapping = currentStyle.getVisualMappingFunction(vp);
        CyNetworkTableManager netTblMgr = this.servicesUtil.get(CyNetworkTableManager.class);
        CyApplicationManager appMgr = this.servicesUtil.get(CyApplicationManager.class);
        GraphObjectType type = editor.getGraphObjectType();
        CyTable table = netTblMgr.getTable(appMgr.getCurrentNetwork(), type.type(), "USER");
        CyColumn column = table.getColumn(columnName);
        if (column == null) {
            JOptionPane.showMessageDialog(null, "The current table does not have the selected column (\"" + columnName + "\").\nPlease select another column.", "Invalid Column.", 2);
            prop.setValue(mapping != null ? mapping.getMappingColumnName() : null);
            return mapping;
        }
        Class dataType = column.getType();
        if (!(factory == null || mapping != null && columnName.equals(mapping.getMappingColumnName()))) {
            if (ContinuousMapping.class.isAssignableFrom(factory.getMappingFunctionType()) && !Number.class.isAssignableFrom(dataType)) {
                JOptionPane.showMessageDialog(null, "Continuous Mapper can be used with numbers only.\nPlease select a numerical column type.", "Incompatible Mapping Type.", 1);
                prop.setValue(mapping != null ? mapping.getMappingColumnName() : null);
                return mapping;
            }
            return this.switchMappingType(prop, vp, type, factory, factory, columnName, propertySheetPanel);
        }
        return mapping;
    }

    private VisualMappingFunction<?, ?> switchMappingType(VizMapperProperty<?, ?, ?> prop, VisualProperty<?> vp, GraphObjectType targetType, VisualMappingFunctionFactory oldFactory, VisualMappingFunctionFactory newFactory, String controllingAttrName, PropertySheetPanel propertySheetPanel) {
        TableModelListener[] modelListeners;
        VisualMappingFunction mapping;
        VisualStyle style = this.servicesUtil.get(VisualMappingManager.class).getCurrentVisualStyle();
        VisualMappingFunction newMapping = mapping = style.getVisualMappingFunction(vp);
        Class newMappingType = newFactory.getMappingFunctionType();
        if (mapping == null || mapping.getClass() != newMappingType || !mapping.getMappingColumnName().equals(controllingAttrName)) {
            CyApplicationManager appMgr = this.servicesUtil.get(CyApplicationManager.class);
            CyNetwork currentNet = appMgr.getCurrentNetwork();
            if (currentNet == null) {
                return newMapping;
            }
            AttributeSet attrSet = this.attrProxy.getAttributeSet(currentNet, targetType);
            Class<Object> attributeDataType = attrSet.getAttrMap().get(controllingAttrName);
            if (attributeDataType == null) {
                JOptionPane.showMessageDialog(null, "The current table does not have the selected column (\"" + controllingAttrName + "\").\nPlease select another column.", "Invalid Column.", 2);
                prop.setValue(oldFactory);
                return newMapping;
            }
            if (newMappingType == ContinuousMapping.class) {
                if (!Number.class.isAssignableFrom(attributeDataType)) {
                    JOptionPane.showMessageDialog(null, "Selected column data type is not Number.\nPlease select a numerical column type.", "Incompatible Column Type.", 2);
                    prop.setValue(oldFactory);
                    return newMapping;
                }
            } else if (newMappingType == DiscreteMapping.class && attributeDataType == List.class) {
                attributeDataType = String.class;
            }
            newMapping = newFactory.createVisualMappingFunction(controllingAttrName, attributeDataType, vp);
            if (oldFactory != null && oldFactory.getMappingFunctionType() == newMappingType) {
                this.copyMappingValues(mapping, newMapping, targetType);
            }
        }
        PropertySheetTableModel model = (PropertySheetTableModel)propertySheetPanel.getTable().getModel();
        for (TableModelListener tm : modelListeners = model.getTableModelListeners()) {
            model.removeTableModelListener(tm);
        }
        this.vizMapPropertyBuilder.createMappingProperties(newMapping, propertySheetPanel, newFactory, targetType);
        for (TableModelListener tm : modelListeners) {
            model.addTableModelListener(tm);
        }
        return newMapping;
    }

    private void setDiscreteMappingEntry(final Object key, final Object oldVal, final Object newVal, final DiscreteMapping<Object, Object> mapping) {
        VisualProperty vp = mapping.getVisualProperty();
        if (newVal == null || vp.getRange().getType().isAssignableFrom(newVal.getClass())) {
            mapping.putMapValue(key, newVal);
            if (!Objects.equals(oldVal, newVal)) {
                UndoSupport undo = this.servicesUtil.get(UndoSupport.class);
                undo.postEdit(new AbstractCyEdit("Set Discrete Mapping Value"){

                    public void undo() {
                        mapping.putMapValue(key, oldVal);
                    }

                    public void redo() {
                        mapping.putMapValue(key, newVal);
                    }
                });
            }
        }
    }

    private void copyMappingValues(VisualMappingFunction<?, ?> source, VisualMappingFunction<?, ?> target, GraphObjectType graphObjecType) {
        if (source instanceof ContinuousMapping && target instanceof ContinuousMapping) {
            CyNetwork curNet = this.servicesUtil.get(CyApplicationManager.class).getCurrentNetwork();
            if (curNet != null) {
                ContinuousMapping cm1 = (ContinuousMapping)source;
                ContinuousMapping cm2 = (ContinuousMapping)target;
                List points1 = cm1.getAllPoints();
                if (points1 == null || points1.isEmpty()) {
                    return;
                }
                for (ContinuousMappingPoint p : points1) {
                    Object v = p.getValue();
                    if (v instanceof Number && !Double.isInfinite(((Number)v).doubleValue()) && !Double.isNaN(((Number)v).doubleValue())) continue;
                    return;
                }
                VisualProperty vp = source.getVisualProperty();
                CyTable dataTable = curNet.getTable(graphObjecType.type(), "USER");
                CyColumn col = dataTable.getColumn(target.getMappingColumnName());
                if (col == null) {
                    return;
                }
                TreeSet srcPoints = new TreeSet(new Comparator<ContinuousMappingPoint<?, ?>>(){

                    @Override
                    public int compare(ContinuousMappingPoint<?, ?> o1, ContinuousMappingPoint<?, ?> o2) {
                        double v1 = ((Number)o1.getValue()).doubleValue();
                        double v2 = ((Number)o2.getValue()).doubleValue();
                        return Double.compare(v1, v2);
                    }
                });
                srcPoints.addAll(points1);
                int tgtPointsSize = cm2.getPointCount();
                for (int i = 0; i < tgtPointsSize; ++i) {
                    cm2.removePoint(i);
                }
                int srcPointsSize = srcPoints.size();
                for (int i = 0; i < srcPointsSize; ++i) {
                    ContinuousMappingPoint mp = cm1.getPoint(i);
                    double srcVal = ((Number)cm1.getPoint(i).getValue()).doubleValue();
                    cm2.addPoint((Object)srcVal, mp.getRange());
                }
            }
        } else if (!(source instanceof DiscreteMapping) || target instanceof DiscreteMapping) {
            // empty if block
        }
    }
}

