/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal.action;

import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertySheetPanel;
import com.l2fprod.common.propertysheet.PropertySheetTableModel;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.gui.internal.VizMapperProperty;
import org.cytoscape.view.vizmap.gui.internal.action.AbstractVizMapperAction;
import org.cytoscape.view.vizmap.gui.internal.event.CellType;
import org.cytoscape.view.vizmap.gui.internal.util.ServicesUtil;
import org.cytoscape.view.vizmap.gui.internal.util.mapgenerator.FitLabelMappingGenerator;
import org.cytoscape.view.vizmap.gui.internal.util.mapgenerator.NumberSeriesMappingGenerator;
import org.cytoscape.view.vizmap.gui.internal.util.mapgenerator.RandomNumberMappingGenerator;
import org.cytoscape.view.vizmap.gui.internal.view.VisualPropertySheet;
import org.cytoscape.view.vizmap.gui.internal.view.VisualPropertySheetItem;
import org.cytoscape.view.vizmap.gui.internal.view.VisualPropertySheetItemModel;
import org.cytoscape.view.vizmap.gui.util.DiscreteMappingGenerator;
import org.cytoscape.view.vizmap.mappings.DiscreteMapping;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public class GenerateDiscreteValuesAction
extends AbstractVizMapperAction {
    private static final long serialVersionUID = 3227895615738968589L;
    private final DiscreteMappingGenerator<?> generator;

    public GenerateDiscreteValuesAction(String name, DiscreteMappingGenerator<?> generator, ServicesUtil servicesUtil) {
        super(name, servicesUtil);
        this.generator = generator;
    }

    public void actionPerformed(ActionEvent e) {
        VisualPropertySheet selVpSheet = this.getVizMapperMainPanel().getSelectedVisualPropertySheet();
        if (selVpSheet == null) {
            return;
        }
        final List<VisualPropertySheetItem<?>> vpSheetItems = selVpSheet.getSelectedItems();
        new Thread(){

            @Override
            public void run() {
                HashMap previousMappingValues = new HashMap();
                HashMap newMappingValues = new HashMap();
                for (VisualPropertySheetItem vpsItem : vpSheetItems) {
                    VisualPropertySheetItemModel model = vpsItem.getModel();
                    VisualProperty vp = model.getVisualProperty();
                    Class vpValueType = vp.getRange().getType();
                    Class<?> generatorType = GenerateDiscreteValuesAction.this.generator.getDataType();
                    PropertySheetPanel propSheetPnl = vpsItem.getPropSheetPnl();
                    PropertySheetTableModel.Item value = (PropertySheetTableModel.Item)propSheetPnl.getTable().getValueAt(0, 0);
                    if (!value.isProperty()) continue;
                    VizMapperProperty prop = (VizMapperProperty)value.getProperty();
                    if (!vpValueType.isAssignableFrom(generatorType) && (!(GenerateDiscreteValuesAction.this.generator instanceof NumberSeriesMappingGenerator) && !(GenerateDiscreteValuesAction.this.generator instanceof RandomNumberMappingGenerator) || !Number.class.isAssignableFrom(vpValueType))) continue;
                    GenerateDiscreteValuesAction.this.generateValues(vpsItem, prop.getValue().toString(), vp, previousMappingValues, newMappingValues);
                }
                if (!previousMappingValues.isEmpty()) {
                    UndoSupport undo = GenerateDiscreteValuesAction.this.servicesUtil.get(UndoSupport.class);
                    undo.postEdit((AbstractCyEdit)new GenerateValuesEdit(previousMappingValues, newMappingValues));
                }
            }
        }.start();
    }

    public void updateEnableState() {
        boolean enabled = false;
        VisualPropertySheet vpSheet = this.getVizMapperMainPanel().getSelectedVisualPropertySheet();
        if (vpSheet != null) {
            for (VisualPropertySheetItem<?> item : vpSheet.getSelectedItems()) {
                VisualMappingFunction<?, ?> mapping = item.getModel().getVisualMappingFunction();
                if (mapping == null || !(mapping instanceof DiscreteMapping)) continue;
                VisualProperty<?> vp = item.getModel().getVisualProperty();
                Class vpValueType = vp.getRange().getType();
                Class<?> generatorType = this.generator.getDataType();
                if (this.generator instanceof FitLabelMappingGenerator) {
                    enabled = vp == BasicVisualLexicon.NODE_SIZE || vp == BasicVisualLexicon.NODE_WIDTH;
                    break;
                }
                if (!vpValueType.isAssignableFrom(generatorType) && (!(this.generator instanceof NumberSeriesMappingGenerator) && !(this.generator instanceof RandomNumberMappingGenerator) || !Number.class.isAssignableFrom(vpValueType))) continue;
                enabled = true;
                break;
            }
        }
        this.setEnabled(enabled);
    }

    public DiscreteMappingGenerator<?> getGenerator() {
        return this.generator;
    }

    private void generateValues(VisualPropertySheetItem<?> vpsItem, String attrName, VisualProperty<?> vp, Map<DiscreteMapping<?, ?>, Map<Object, Object>> previousMappingValues, Map<DiscreteMapping<?, ?>, Map<Object, ?>> newMappingValues) {
        VisualStyle style = this.servicesUtil.get(VisualMappingManager.class).getCurrentVisualStyle();
        VisualMappingFunction mapping = style.getVisualMappingFunction(vp);
        if (!(mapping instanceof DiscreteMapping)) {
            return;
        }
        DiscreteMapping dm = (DiscreteMapping)mapping;
        PropertySheetPanel propSheetPnl = vpsItem.getPropSheetPnl();
        TreeSet keySet = new TreeSet();
        HashMap previousValues = new HashMap();
        for (Property p : propSheetPnl.getProperties()) {
            VizMapperProperty vmp = (VizMapperProperty)p;
            if (!vmp.getCellType().equals((Object)CellType.DISCRETE)) continue;
            keySet.add(vmp.getKey());
            previousValues.put(vmp.getKey(), vmp.getValue());
        }
        if (!keySet.isEmpty()) {
            Map newValues = this.generator.generateMap(keySet);
            previousMappingValues.put(dm, previousValues);
            newMappingValues.put(dm, newValues);
            dm.putAll(newValues);
        }
    }

    public void setIsInMenuBar(boolean b) {
    }

    public void setIsInToolBar(boolean b) {
    }

    public void setPreferredMenu(String menu) {
    }

    public void setToolbarGravity(float f) {
    }

    public void setMenuGravity(float f) {
    }

    private class GenerateValuesEdit
    extends AbstractCyEdit {
        private final Map<DiscreteMapping<?, ?>, Map<Object, Object>> previousMappingValues;
        private final Map<DiscreteMapping<?, ?>, Map<Object, ?>> newMappingValues;

        public GenerateValuesEdit(Map<DiscreteMapping<?, ?>, Map<Object, Object>> previousMappingValues, Map<DiscreteMapping<?, ?>, Map<Object, ?>> newMappingValues) {
            super("Mapping Value Generators");
            this.previousMappingValues = previousMappingValues;
            this.newMappingValues = newMappingValues;
        }

        public void undo() {
            for (Map.Entry<DiscreteMapping<?, ?>, Map<Object, Object>> entry : this.previousMappingValues.entrySet()) {
                DiscreteMapping<?, ?> dm = entry.getKey();
                dm.putAll(entry.getValue());
            }
        }

        public void redo() {
            for (Map.Entry<DiscreteMapping<?, ?>, Map<Object, ?>> entry : this.newMappingValues.entrySet()) {
                DiscreteMapping<?, ?> dm = entry.getKey();
                dm.putAll(entry.getValue());
            }
        }
    }
}

