/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal;

import com.l2fprod.common.propertysheet.DefaultProperty;
import org.cytoscape.view.vizmap.gui.internal.event.CellType;

public class VizMapperProperty<K, V, T>
extends DefaultProperty {
    private static final long serialVersionUID = 1202339868680341L;
    private final CellType cellType;
    private final K key;
    private T internalValue;

    public <S extends V> VizMapperProperty(CellType cellType, K key, Class<S> valueType) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null.");
        }
        if (cellType == null) {
            throw new NullPointerException("CellType cannot be null.");
        }
        if (valueType == null) {
            throw new NullPointerException("Value Type cannot be null.");
        }
        this.cellType = cellType;
        this.key = key;
        super.setName(key.toString());
        super.setType(valueType);
    }

    public VizMapperProperty(VizMapperProperty<K, V, T> original) {
        if (original == null) {
            throw new NullPointerException("Original value cannot be null.");
        }
        this.cellType = original.getCellType();
        this.key = original.getKey();
        super.setName(this.key.toString());
        super.setType(original.getType());
        super.setValue(original.getValue());
        this.internalValue = original.getInternalValue();
    }

    public void setName(String name) {
        throw new UnsupportedOperationException("Name is immutable in this implementation.");
    }

    public String getName() {
        return this.key.toString();
    }

    public void setInternalValue(T internalValue) {
        this.internalValue = internalValue;
    }

    public CellType getCellType() {
        return this.cellType;
    }

    public T getInternalValue() {
        return this.internalValue;
    }

    public K getKey() {
        return this.key;
    }

    public String toString() {
        return "VizMapperProperty [key=" + this.key + ", value=" + this.getValue() + "]";
    }
}

