/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.view.vizmap.gui.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.cytoscape.view.vizmap.VisualStyle;

public class VisualStyleSet {
    private final VisualStyle networkStyle;
    private final Map<String, VisualStyle> nodeColumnStyles;
    private final Map<String, VisualStyle> edgeColumnStyles;

    public VisualStyleSet(VisualStyle networkStyle, Map<String, VisualStyle> nodeColumnStyles, Map<String, VisualStyle> edgeColumnStyles) {
        this.networkStyle = Objects.requireNonNull(networkStyle);
        this.nodeColumnStyles = nodeColumnStyles == null ? Map.of() : nodeColumnStyles;
        this.edgeColumnStyles = edgeColumnStyles == null ? Map.of() : edgeColumnStyles;
    }

    public VisualStyle getNetworkStyle() {
        return this.networkStyle;
    }

    public Map<String, VisualStyle> getNodeColumnStyles() {
        return this.nodeColumnStyles;
    }

    public Map<String, VisualStyle> getEdgeColumnStyles() {
        return this.edgeColumnStyles;
    }

    public Collection<VisualStyle> getAllStyles() {
        ArrayList<VisualStyle> list = new ArrayList<VisualStyle>();
        list.add(this.networkStyle);
        list.addAll(this.nodeColumnStyles.values());
        list.addAll(this.edgeColumnStyles.values());
        return list;
    }
}

