/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.diagnostics.internal;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.cytoscape.diagnostics.SystemDetails;
import org.cytoscape.diagnostics.internal.heuristics.Heuristic;
import org.cytoscape.diagnostics.internal.heuristics.ProcHeuristic;
import org.cytoscape.diagnostics.internal.heuristics.Sw_VersHeuristic;
import org.cytoscape.diagnostics.internal.heuristics.SysctlHeuristic;
import org.cytoscape.diagnostics.internal.heuristics.UnameHeuristic;
import org.cytoscape.diagnostics.internal.heuristics.Vm_StatHeuristic;
import org.cytoscape.diagnostics.internal.heuristics.WmicHeuristic;

public class SystemDetailsImpl
implements SystemDetails {
    Map<Class<? extends Heuristic<?>>, Heuristic<?>> singletonCache = new HashMap();

    public static void main(String[] args) {
        SystemDetailsImpl details = new SystemDetailsImpl();
        System.out.println(details.getOSName());
        System.out.println(details.getProcessorName());
        System.out.println(details.getTotalMemory());
        System.out.println(details.getFreeMemory());
        System.out.println(details.getTotalSwap());
        System.out.println(details.getFreeSwap());
    }

    @Override
    public Long getFreeSwap() {
        return (Long)this.tryHeuristics(WmicHeuristic.FreeSwap.class, SysctlHeuristic.FreeSwap.class, ProcHeuristic.FreeSwap.class);
    }

    @Override
    public Long getTotalSwap() {
        return (Long)this.tryHeuristics(WmicHeuristic.TotalSwap.class, SysctlHeuristic.TotalSwap.class, ProcHeuristic.TotalSwap.class);
    }

    @Override
    public Long getFreeMemory() {
        return (Long)this.tryHeuristics(WmicHeuristic.FreeMemory.class, Vm_StatHeuristic.FreeMemory.class, ProcHeuristic.FreeMemory.class);
    }

    @Override
    public Long getTotalMemory() {
        return (Long)this.tryHeuristics(WmicHeuristic.TotalMemory.class, SysctlHeuristic.TotalMemory.class, ProcHeuristic.TotalMemory.class);
    }

    @Override
    public String getProcessorName() {
        return (String)this.tryHeuristics(WmicHeuristic.ProcessorName.class, SysctlHeuristic.ProcessorName.class, ProcHeuristic.ProcessorName.class);
    }

    @Override
    public String getOSName() {
        return (String)this.tryHeuristics(WmicHeuristic.OSName.class, Sw_VersHeuristic.class, UnameHeuristic.class);
    }

    private <T> T tryHeuristics(Class<? extends Heuristic<T>> ... heuristicTypes) {
        for (Class<Heuristic<T>> clazz : heuristicTypes) {
            try {
                Object value;
                Heuristic<Object> heuristic = this.singletonCache.get(clazz);
                if (heuristic == null) {
                    try {
                        heuristic = clazz.newInstance();
                    }
                    catch (InstantiationException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    this.singletonCache.put(clazz, heuristic);
                }
                if ((value = heuristic.computeValue()) == null) continue;
                return (T)value;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }
}

