/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.diagnostics.internal;

import org.cytoscape.diagnostics.internal.PerformanceDetailsBuilder;
import org.cytoscape.launcher.internal.Launcher;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.startlevel.StartLevel;

public class PerformanceTracker
implements FrameworkListener,
SynchronousBundleListener {
    private BundleContext context;
    private PerformanceDetailsBuilder performanceDetails;
    private boolean finishedStarting;

    public PerformanceTracker(BundleContext context, PerformanceDetailsBuilder performanceDetails) {
        this.context = context;
        this.performanceDetails = performanceDetails;
        performanceDetails.setSystemLaunchStartTime(Launcher.getStartTime());
        performanceDetails.setFrameworkLaunchEndTime(System.currentTimeMillis());
    }

    public void frameworkEvent(FrameworkEvent event) {
        if (event.getType() == 8 && !this.finishedStarting) {
            ServiceReference reference = this.context.getServiceReference(StartLevel.class.getName());
            StartLevel level = (StartLevel)this.context.getService(reference);
            if (level.getStartLevel() == 200) {
                this.performanceDetails.setSystemLaunchEndTime(System.currentTimeMillis());
                this.finishedStarting = true;
            }
            this.context.ungetService(reference);
        }
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 128: {
                this.performanceDetails.logBundleStarting(event.getBundle());
                break;
            }
            case 2: {
                this.performanceDetails.logBundleStarted(event.getBundle());
            }
        }
    }
}

