/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.webservice.psicquic.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.cytoscape.webservice.psicquic.mapper.CyNetworkBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PSIMITagManager {
    private static final Logger logger = LoggerFactory.getLogger(PSIMITagManager.class);
    private static final Pattern SPLIT_PTTR = Pattern.compile("\t");
    private final Map<String, String> tag2name = new HashMap<String, String>();

    public PSIMITagManager() {
        try {
            this.createMap();
        }
        catch (IOException e) {
            logger.warn("Could not create tag map.", (Throwable)e);
        }
        if (this.tag2name.size() == 0) {
            logger.warn("Tag map is empty.");
        }
    }

    private final void createMap() throws IOException {
        String line;
        URL tableURL = CyNetworkBuilder.class.getClassLoader().getResource("psimi_terms.txt");
        BufferedReader reader = new BufferedReader(new InputStreamReader(tableURL.openStream(), Charset.forName("UTF-8").newDecoder()));
        while ((line = reader.readLine()) != null) {
            String[] result = SPLIT_PTTR.split(line);
            if (result == null || result.length != 2) continue;
            this.tag2name.put(result[0], result[1]);
        }
        reader.close();
    }

    public String toName(String tag) {
        return this.tag2name.get(tag);
    }
}

