/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.webservice.psicquic.simpleclient;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;

public final class PSICQUICSimpleClient {
    public static final String XML25 = "xml25";
    public static final String MITAB25 = "tab25";
    public static final String MITAB27 = "tab27";
    public static final String MITAB25_COMPRESSED = "tab25-bin";
    public static final String COUNT = "count";
    private String serviceRestUrl;

    public PSICQUICSimpleClient(String serviceRestUrl) {
        this.serviceRestUrl = serviceRestUrl;
    }

    public InputStream getByQuery(String query) throws IOException {
        return this.getByQuery(query, MITAB25);
    }

    public InputStream getByInteractor(String query) throws IOException {
        return this.getByQuery(query, MITAB25);
    }

    public InputStream getByInteraction(String query) throws IOException {
        return this.getByQuery(query, MITAB25);
    }

    public InputStream getByQuery(String query, String format) throws IOException {
        return this.getByQuery(query, format, 0, Integer.MAX_VALUE);
    }

    public InputStream getByInteractor(String query, String format) throws IOException {
        return this.getByInteractor(query, format, 0, Integer.MAX_VALUE);
    }

    public InputStream getByInteraction(String query, String format) throws IOException {
        return this.getByInteraction(query, format, 0, Integer.MAX_VALUE);
    }

    public InputStream getByQuery(String query, String format, int firstResult, int maxResults) throws IOException {
        return this.getBy("query", query, format, firstResult, maxResults);
    }

    public InputStream getByInteractor(String query, String format, int firstResult, int maxResults) throws IOException {
        return this.getBy("interactor", query, format, firstResult, maxResults);
    }

    public InputStream getByInteraction(String query, String format, int firstResult, int maxResults) throws IOException {
        return this.getBy("interaction", query, format, firstResult, maxResults);
    }

    public long countByQuery(String query) throws IOException {
        return this.countBy("query", query);
    }

    public long countByInteractor(String query) throws IOException {
        return this.countBy("interactor", query);
    }

    public long countByInteraction(String query) throws IOException {
        return this.countBy("interaction", query);
    }

    private InputStream getBy(String queryType, String query, String format, int firstResult, int maxResults) throws IOException {
        String encodedQuery = this.encodeQuery(query);
        URL url = this.createUrl(queryType, encodedQuery, format, firstResult, maxResults);
        return url.openStream();
    }

    private long countBy(String queryType, String query) throws IOException {
        InputStream result = this.getBy(queryType, query, COUNT, 0, 0);
        String strCount = this.streamToString(result);
        strCount = strCount.replaceAll("\n", "");
        result.close();
        return Long.parseLong(strCount);
    }

    private String encodeQuery(String query) {
        String encodedQuery;
        try {
            encodedQuery = URLEncoder.encode(query, "UTF-8");
            encodedQuery = encodedQuery.replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 should be supported");
        }
        return encodedQuery;
    }

    private URL createUrl(String queryType, String encodedQuery, String format, int firstResult, int maxResults) {
        URL url;
        Object strUrl = this.serviceRestUrl + "/" + queryType + "/" + encodedQuery + "?format=" + format + "&firstResult=" + firstResult + "&maxResults=" + maxResults;
        strUrl = ((String)strUrl).replaceAll("//" + queryType, "/" + queryType);
        try {
            url = new URL((String)strUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Problem creating URL: " + (String)strUrl, e);
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String streamToString(InputStream is) throws IOException {
        if (is == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
            reader.close();
        }
        finally {
            is.close();
        }
        return sb.toString();
    }
}

