/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.webservice.psicquic.mapper;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.webservice.psicquic.mapper.InteractionClusterMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.enfin.mi.cluster.EncoreInteraction;
import uk.ac.ebi.enfin.mi.cluster.InteractionCluster;

public class CyNetworkBuilder {
    private static final Logger logger = LoggerFactory.getLogger(CyNetworkBuilder.class);
    private static final int MINIMUM_COLUMN_COUNT = 15;
    private static final String UNIPROT_AC = "uniprotkb_accession";
    private static final String NCBI_GENE = "ncbi_gene_id";
    private static final String CHEBI = "chebi_id";
    private static final String REFSEQ = "refseq_id";
    private static final Pattern SPLITTER_TAB = Pattern.compile("\t");
    private static final Pattern SPLITTER = Pattern.compile("\\|");
    private static final Pattern SPLITTER_NAME_SPACE = Pattern.compile("\\:");
    private static final Pattern NCBI = Pattern.compile("^d+$");
    private static final Pattern UNIPROT_PATTERN = Pattern.compile("^([A-N,R-Z][0-9][A-Z][A-Z, 0-9][A-Z, 0-9][0-9])|([O,P,Q][0-9][A-Z, 0-9][A-Z, 0-9][A-Z, 0-9][0-9])(.d+)?$");
    private final InteractionClusterMapper mapper;
    final String fisrtSeparator = "\t";
    final String secondSeparator = ",";
    volatile boolean cancel = false;
    private Map<String, CyNode> nodeMap;
    private final CyServiceRegistrar serviceRegistrar;

    public CyNetworkBuilder(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.mapper = new InteractionClusterMapper();
        this.mapper.ensureInitialized();
    }

    public CyNetwork buildNetwork(InteractionCluster iC) throws IOException {
        CyNetwork network = ((CyNetworkFactory)this.serviceRegistrar.getService(CyNetworkFactory.class)).createNetwork();
        this.process(iC, network, null, null);
        return network;
    }

    public CyNetwork buildNetwork(BufferedReader reader, String networkTitle) throws IOException {
        String line;
        CyNetwork network = ((CyNetworkFactory)this.serviceRegistrar.getService(CyNetworkFactory.class)).createNetwork();
        network.getDefaultNetworkTable().createColumn("source", String.class, true);
        network.getRow((CyIdentifiable)network).set("source", (Object)networkTitle);
        network.getRow((CyIdentifiable)network).set("name", (Object)networkTitle);
        this.prepareColumns(network);
        HashMap<String, CyNode> nodes = new HashMap<String, CyNode>();
        while ((line = reader.readLine()) != null) {
            if (this.cancel) {
                logger.warn("Network bulilder interrupted.");
                network.getRow((CyIdentifiable)network).set("name", (Object)("<Incomplete!> " + networkTitle));
                break;
            }
            String[] parts = SPLITTER_TAB.split(line);
            if (parts.length < 15) continue;
            String[] sourceIds = SPLITTER.split(parts[0]);
            String[] targetIds = SPLITTER.split(parts[1]);
            String sourceFirst = sourceIds[0];
            String targetFirst = targetIds[0];
            if (targetFirst.equals("-")) {
                targetIds[0] = sourceFirst;
            } else if (sourceFirst.equals("-")) {
                sourceIds[0] = targetFirst;
            }
            String[] sourceID = this.getID(sourceIds);
            String[] targetID = this.getID(targetIds);
            CyNode sourceNode = this.addNode(nodes, sourceID[1], network);
            CyNode targetNode = this.addNode(nodes, targetID[1], network);
            if (network.getDefaultNodeTable().getColumn(sourceID[0]) == null) {
                network.getDefaultNodeTable().createColumn(sourceID[0], String.class, false);
            }
            network.getRow((CyIdentifiable)sourceNode).set(sourceID[0], (Object)sourceID[1]);
            if (network.getDefaultNodeTable().getColumn(targetID[0]) == null) {
                network.getDefaultNodeTable().createColumn(targetID[0], String.class, false);
            }
            network.getRow((CyIdentifiable)targetNode).set(targetID[0], (Object)targetID[1]);
            this.mapper.mapNodeColumn(parts, network.getRow((CyIdentifiable)sourceNode), network.getRow((CyIdentifiable)targetNode));
            CyEdge newEdge = network.addEdge(sourceNode, targetNode, true);
            this.mapper.mapEdgeColumn(parts, network.getRow((CyIdentifiable)newEdge), newEdge, sourceID[1], targetID[1]);
        }
        reader.close();
        return network;
    }

    private final String[] getID(String[] nodeIDs) {
        String[] firstParts = this.mapper.parseValues(nodeIDs[0]);
        HashMap<String, String> nodes = new HashMap<String, String>();
        for (String entry : nodeIDs) {
            String[] nodeParts = this.mapper.parseValues(entry);
            nodes.put(nodeParts[0], nodeParts[1]);
        }
        String[] primaryID = new String[2];
        if (nodes.get("uniprotkb") != null) {
            primaryID[0] = UNIPROT_AC;
            primaryID[1] = (String)nodes.get("uniprotkb");
        } else if (nodes.get("entrez gene/locuslink") != null) {
            primaryID[0] = NCBI_GENE;
            primaryID[1] = (String)nodes.get("entrez gene/locuslink");
        } else if (nodes.get("chebi") != null) {
            primaryID[0] = CHEBI;
            primaryID[1] = (String)nodes.get("chebi");
        } else {
            primaryID[0] = firstParts[0] + "_id";
            primaryID[1] = firstParts[1];
        }
        return primaryID;
    }

    private final CyNode addNode(Map<String, CyNode> nodes, String id, CyNetwork network) {
        CyNode node = nodes.get(id);
        if (node == null) {
            node = network.addNode();
            network.getRow((CyIdentifiable)node).set("name", (Object)id);
            nodes.put(id, node);
        }
        return node;
    }

    public void addToNetwork(InteractionCluster iC, CyNetworkView networkView, View<CyNode> hubNode) {
        CyNetwork network = (CyNetwork)networkView.getModel();
        CyNode hub = (CyNode)hubNode.getModel();
        String hubName = (String)network.getRow((CyIdentifiable)hub).get("name", String.class);
        CyTable hubNodeTable = network.getDefaultNodeTable();
        if (hubNodeTable.getColumn("identifier") != null) {
            hubName = (String)network.getRow((CyIdentifiable)hub).get("identifier", String.class);
        }
        this.mapper.ensureInitialized();
        this.nodeMap = new HashMap<String, CyNode>();
        this.nodeMap.put(hubName, hub);
        network.getRow((CyIdentifiable)hub).set("selected", (Object)true);
        for (CyNode existingNode : network.getNodeList()) {
            this.nodeMap.put((String)network.getRow((CyIdentifiable)existingNode).get("name", String.class), existingNode);
        }
        Map interactions = iC.getInteractionMapping();
        this.prepareColumns(network);
        for (Integer interactionKey : interactions.keySet()) {
            if (this.cancel) {
                logger.warn("Network bulilder interrupted.");
            }
            EncoreInteraction interaction = (EncoreInteraction)interactions.get(interactionKey);
            String source = interaction.getInteractorA();
            String target = interaction.getInteractorB();
            if (!source.equals(hubName) && !target.equals(hubName)) continue;
            String newNodeName = source.equals(hubName) ? target : source;
            CyNode newNode = this.nodeMap.get(newNodeName);
            if (newNode == null) {
                newNode = network.addNode();
                network.getRow((CyIdentifiable)newNode).set("name", (Object)newNodeName);
                network.getRow((CyIdentifiable)newNode).set("selected", (Object)true);
                this.nodeMap.put(newNodeName, newNode);
            }
            this.mapper.mapNodeColumn(interaction, network.getRow((CyIdentifiable)newNode), null);
            CyEdge newEdge = network.addEdge(hub, newNode, true);
            this.mapper.mapEdgeColumn(interaction, network.getRow((CyIdentifiable)newEdge));
        }
    }

    private final Map<String, CyNode> process(InteractionCluster iC, CyNetwork network, CyNetworkView netView, View<CyNode> hubNode) {
        this.mapper.ensureInitialized();
        this.nodeMap = new HashMap<String, CyNode>();
        if (hubNode != null) {
            this.nodeMap.put((String)network.getRow((CyIdentifiable)hubNode.getModel()).get("name", String.class), (CyNode)hubNode.getModel());
            if (netView != null) {
                network.getRow((CyIdentifiable)hubNode.getModel()).set("selected", (Object)true);
            }
        }
        if (network.getNodeCount() != 0) {
            for (CyNode existingNode : network.getNodeList()) {
                this.nodeMap.put((String)network.getRow((CyIdentifiable)existingNode).get("name", String.class), existingNode);
            }
        }
        Map interactions = iC.getInteractionMapping();
        this.prepareColumns(network);
        for (Integer interactionKey : interactions.keySet()) {
            String target;
            CyNode targetNode;
            EncoreInteraction interaction;
            String source;
            CyNode sourceNode;
            if (this.cancel) {
                logger.warn("Network bulilder interrupted.");
                network = null;
            }
            if ((sourceNode = this.nodeMap.get(source = (interaction = (EncoreInteraction)interactions.get(interactionKey)).getInteractorA())) == null) {
                sourceNode = network.addNode();
                network.getRow((CyIdentifiable)sourceNode).set("name", (Object)source);
                if (netView != null) {
                    network.getRow((CyIdentifiable)sourceNode).set("selected", (Object)true);
                }
                this.nodeMap.put(source, sourceNode);
            }
            if ((targetNode = this.nodeMap.get(target = interaction.getInteractorB())) == null) {
                targetNode = network.addNode();
                network.getRow((CyIdentifiable)targetNode).set("name", (Object)target);
                if (netView != null) {
                    network.getRow((CyIdentifiable)targetNode).set("selected", (Object)true);
                }
                this.nodeMap.put(target, targetNode);
            }
            this.mapper.mapNodeColumn(interaction, network.getRow((CyIdentifiable)sourceNode), network.getRow((CyIdentifiable)targetNode));
            CyEdge newEdge = network.addEdge(sourceNode, targetNode, true);
            this.mapper.mapEdgeColumn(interaction, network.getRow((CyIdentifiable)newEdge));
        }
        logger.info("Import Done: " + network.getSUID());
        return this.nodeMap;
    }

    private final void prepareColumns(CyNetwork network) {
        CyTable nodeTable = network.getDefaultNodeTable();
        CyTable edgeTable = network.getDefaultEdgeTable();
        if (nodeTable.getColumn("Taxonomy ID") == null) {
            nodeTable.createColumn("Taxonomy ID", String.class, false);
        }
        if (nodeTable.getColumn("Taxonomy Name") == null) {
            nodeTable.createColumn("Taxonomy Name", String.class, false);
        }
        if (nodeTable.getColumn("Human Readable Label") == null) {
            nodeTable.createColumn("Human Readable Label", String.class, false);
        }
        if (edgeTable.getColumn("Author") == null) {
            edgeTable.createListColumn("Author", String.class, false);
        }
        if (edgeTable.getColumn("Primary Interaction Type") == null) {
            edgeTable.createColumn("Primary Interaction Type", String.class, false);
        }
        if (edgeTable.getColumn("Interaction Type") == null) {
            edgeTable.createListColumn("Interaction Type", String.class, false);
        }
        if (edgeTable.getColumn("Publication DB") == null) {
            edgeTable.createListColumn("Publication DB", String.class, false);
        }
        if (edgeTable.getColumn("Publication ID") == null) {
            edgeTable.createListColumn("Publication ID", String.class, false);
        }
        if (edgeTable.getColumn("Detection Method ID") == null) {
            edgeTable.createListColumn("Detection Method ID", String.class, false);
        }
        if (edgeTable.getColumn("Detection Method") == null) {
            edgeTable.createListColumn("Detection Method", String.class, false);
        }
        if (edgeTable.getColumn("Source Database") == null) {
            edgeTable.createColumn("Source Database", String.class, false);
        }
    }

    public void cancel() {
        this.cancel = true;
    }
}

