/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.jobs.internal;

import org.apache.log4j.Logger;
import org.cytoscape.jobs.CyJob;
import org.cytoscape.jobs.CyJobMonitor;
import org.cytoscape.jobs.CyJobStatus;
import org.cytoscape.work.TaskMonitor;

public class SimpleCyJobMonitor
implements CyJobMonitor {
    final Logger logger = Logger.getLogger((String)"org.cytoscape.application.userlog");

    public void jobStatusChanged(CyJob job, CyJobStatus status) {
        String jobId = job.getJobId();
        CyJobStatus.Status stat = status.getStatus();
        switch (stat) {
            case FAILED: {
                this.logger.error((Object)("Job " + jobId + " has failed!"));
                break;
            }
            case ERROR: {
                this.logger.error((Object)("Job " + jobId + " has experienced an error!"));
                break;
            }
            case CANCELED: {
                this.logger.warn((Object)("Job " + jobId + " has been canceled!"));
                break;
            }
            case PURGED: {
                this.logger.warn((Object)("Job " + jobId + " has been purged!"));
                break;
            }
            case TERMINATED: {
                this.logger.warn((Object)("Job " + jobId + " was terminated"));
                break;
            }
            case FINISHED: {
                this.logger.info((Object)("Job " + jobId + " has finished"));
                break;
            }
            case SUBMITTED: {
                this.logger.info((Object)("Job " + jobId + " was submitted"));
                break;
            }
            case QUEUED: {
                this.logger.info((Object)("Job " + jobId + " has been queued"));
                break;
            }
            case RUNNING: {
                this.logger.info((Object)("Job " + jobId + " is running"));
            }
        }
    }

    public void loadData(CyJob job, TaskMonitor monitor) {
    }
}

