/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.work;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.filter.internal.MemoizableTransformer;
import org.cytoscape.filter.internal.view.FilterElement;
import org.cytoscape.filter.internal.view.TransformerPanel;
import org.cytoscape.filter.internal.view.TransformerPanelController;
import org.cytoscape.filter.internal.work.AbstractWorker;
import org.cytoscape.filter.internal.work.DiscreteProgressMonitor;
import org.cytoscape.filter.internal.work.LazyWorkQueue;
import org.cytoscape.filter.internal.work.ProgressMonitor;
import org.cytoscape.filter.internal.work.SubProgressMonitor;
import org.cytoscape.filter.internal.work.TransformerManagerImpl;
import org.cytoscape.filter.model.CompositeFilter;
import org.cytoscape.filter.model.Transformer;
import org.cytoscape.filter.model.TransformerSink;
import org.cytoscape.filter.model.TransformerSource;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.hide.HideTaskFactory;
import org.cytoscape.task.hide.UnHideTaskFactory;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.SynchronousTaskManager;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

public class TransformerWorker
extends AbstractWorker<TransformerPanel, TransformerPanelController> {
    private TransformerManagerImpl transformerManager;

    public TransformerWorker(LazyWorkQueue queue, TransformerManagerImpl transformerManager, CyServiceRegistrar serviceRegistrar) {
        super(queue, serviceRegistrar);
        this.transformerManager = transformerManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doWork(ProgressMonitor monitor) {
        if (this.controller == null) {
            return;
        }
        CyApplicationManager applicationManager = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        CyNetworkView networkView = applicationManager.getCurrentNetworkView();
        CyNetwork network = networkView != null ? (CyNetwork)networkView.getModel() : applicationManager.getCurrentNetwork();
        if (network == null) {
            return;
        }
        SubProgressMonitor filterMonitor = new SubProgressMonitor(monitor, 0.0, 0.4);
        SubProgressMonitor chainMonitor = new SubProgressMonitor(monitor, 0.4, 0.98);
        monitor.setProgress(0.0);
        monitor.setStatusMessage(null);
        Sink sink = this.applyAction == AbstractWorker.ApplyAction.SHOW ? new FilterSink(networkView) : new SelectSink(network);
        long startTime = System.currentTimeMillis();
        try {
            List transformers = ((TransformerPanelController)this.controller).getTransformers((TransformerPanel)this.view);
            FilterElement selected = (FilterElement)((TransformerPanelController)this.controller).getStartWithComboBoxModel().getSelectedItem();
            TransformerSource<CyNetwork, CyIdentifiable> source = this.createSource(network, selected, filterMonitor);
            for (Transformer<CyNetwork, CyIdentifiable> transformer : transformers) {
                if (!(transformer instanceof MemoizableTransformer)) continue;
                ((MemoizableTransformer)transformer).startCaching();
            }
            try {
                this.transformerManager.execute(network, source, transformers, sink, chainMonitor);
            }
            catch (Throwable throwable) {
                for (Transformer<CyNetwork, CyIdentifiable> transformer : transformers) {
                    if (!(transformer instanceof MemoizableTransformer)) continue;
                    ((MemoizableTransformer)transformer).clearCache();
                }
                throw throwable;
            }
            for (Transformer transformer : transformers) {
                if (!(transformer instanceof MemoizableTransformer)) continue;
                ((MemoizableTransformer)transformer).clearCache();
            }
            sink.done();
            if (networkView != null) {
                networkView.updateView();
            }
        }
        catch (Throwable throwable) {
            long duration = System.currentTimeMillis() - startTime;
            monitor.setProgress(1.0);
            monitor.setStatusMessage(String.format("Selected %d %s and %d %s in %dms", sink.getNodeCount(), sink.getNodeCount() == 1 ? "node" : "nodes", sink.getEdgeCount(), sink.getEdgeCount() == 1 ? "edge" : "edges", duration));
            throw throwable;
        }
        long duration = System.currentTimeMillis() - startTime;
        monitor.setProgress(1.0);
        monitor.setStatusMessage(String.format("Selected %d %s and %d %s in %dms", sink.getNodeCount(), sink.getNodeCount() == 1 ? "node" : "nodes", sink.getEdgeCount(), sink.getEdgeCount() == 1 ? "edge" : "edges", duration));
    }

    private TransformerSource<CyNetwork, CyIdentifiable> createSource(CyNetwork network, FilterElement selected, ProgressMonitor monitor) {
        if (selected.getFilter() == null) {
            return new SelectionSource(monitor);
        }
        return new FilterSource(selected.getFilter(), monitor);
    }

    class FilterSink
    extends Sink {
        private final CyNetworkView networkView;
        private List<CyNode> selectedNodes;
        private List<CyEdge> selectedEdges;

        FilterSink(CyNetworkView networkView) {
            super((CyNetwork)networkView.getModel());
            this.selectedNodes = new ArrayList<CyNode>();
            this.selectedEdges = new ArrayList<CyEdge>();
            this.networkView = networkView;
        }

        @Override
        public void collect(CyIdentifiable element) {
            super.collect(element);
            if (element instanceof CyNode) {
                this.selectedNodes.add((CyNode)element);
            } else if (element instanceof CyEdge) {
                this.selectedEdges.add((CyEdge)element);
            }
        }

        @Override
        public void done() {
            if (this.networkView != null) {
                HideTaskFactory hideFactory = (HideTaskFactory)TransformerWorker.this.serviceRegistrar.getService(HideTaskFactory.class);
                TaskIterator hideTasks = hideFactory.createTaskIterator(this.networkView, (Collection)this.network.getNodeList(), (Collection)this.network.getEdgeList());
                UnHideTaskFactory unhideFactory = (UnHideTaskFactory)TransformerWorker.this.serviceRegistrar.getService(UnHideTaskFactory.class);
                TaskIterator unhideTasks = unhideFactory.createTaskIterator(this.networkView, this.selectedNodes, this.selectedEdges);
                TaskIterator taskIterator = new TaskIterator(new Task[0]);
                taskIterator.append(hideTasks);
                taskIterator.append(unhideTasks);
                SynchronousTaskManager taskManager = (SynchronousTaskManager)TransformerWorker.this.serviceRegistrar.getService(SynchronousTaskManager.class);
                taskManager.execute(taskIterator);
            }
        }
    }

    class SelectSink
    extends Sink {
        SelectSink(CyNetwork network) {
            super(network);
        }

        @Override
        public void collect(CyIdentifiable element) {
            super.collect(element);
            this.network.getRow(element).set("selected", (Object)true);
        }
    }

    private abstract class Sink
    implements TransformerSink<CyIdentifiable> {
        final CyNetwork network;
        int nodeCount;
        int edgeCount;

        Sink(CyNetwork network) {
            this.network = network;
        }

        public void collect(CyIdentifiable element) {
            if (element instanceof CyNode) {
                ++this.nodeCount;
            } else if (element instanceof CyEdge) {
                ++this.edgeCount;
            }
        }

        public int getNodeCount() {
            return this.nodeCount;
        }

        public int getEdgeCount() {
            return this.edgeCount;
        }

        void done() {
        }
    }

    private static class SelectionSource
    extends AbstractSource {
        private ProgressMonitor monitor;

        SelectionSource(ProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public List<CyIdentifiable> getElementList(CyNetwork context) {
            this.monitor.start();
            int maximum = this.getElementCount(context);
            ArrayList<CyIdentifiable> elements = new ArrayList<CyIdentifiable>(maximum);
            DiscreteProgressMonitor discreteMonitor = new DiscreteProgressMonitor(this.monitor);
            discreteMonitor.setTotalWork(maximum);
            List nodes = context.getNodeList();
            for (CyNode node : nodes) {
                CyRow row = context.getRow((CyIdentifiable)node);
                if (((Boolean)row.get("selected", Boolean.class)).booleanValue()) {
                    row.set("selected", (Object)false);
                    elements.add((CyIdentifiable)node);
                }
                discreteMonitor.addWork(1);
            }
            List edges = context.getEdgeList();
            for (CyEdge edge : edges) {
                CyRow row = context.getRow((CyIdentifiable)edge);
                if (((Boolean)row.get("selected", Boolean.class)).booleanValue()) {
                    row.set("selected", (Object)false);
                    elements.add((CyIdentifiable)edge);
                }
                discreteMonitor.addWork(1);
            }
            this.monitor.done();
            return elements;
        }
    }

    private static class FilterSource
    extends AbstractSource {
        private CompositeFilter<CyNetwork, CyIdentifiable> filter;
        private ProgressMonitor monitor;

        FilterSource(CompositeFilter<CyNetwork, CyIdentifiable> filter, ProgressMonitor monitor) {
            this.filter = filter;
            this.monitor = monitor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<CyIdentifiable> getElementList(CyNetwork context) {
            this.monitor.start();
            this.monitor.setStatusMessage("Filtering");
            int maximum = this.getElementCount(context);
            ArrayList<CyIdentifiable> elements = new ArrayList<CyIdentifiable>(maximum);
            DiscreteProgressMonitor discreteMonitor = new DiscreteProgressMonitor(this.monitor);
            discreteMonitor.setTotalWork(maximum);
            if (this.filter instanceof MemoizableTransformer) {
                ((MemoizableTransformer)this.filter).startCaching();
            }
            try {
                CyRow row;
                for (CyNode node : context.getNodeList()) {
                    row = context.getRow((CyIdentifiable)node);
                    if (((Boolean)row.get("selected", Boolean.class)).booleanValue()) {
                        row.set("selected", (Object)false);
                    }
                    if (this.filter.accepts((Object)context, (Object)node)) {
                        elements.add((CyIdentifiable)node);
                    }
                    discreteMonitor.addWork(1);
                }
                for (CyEdge edge : context.getEdgeList()) {
                    row = context.getRow((CyIdentifiable)edge);
                    if (((Boolean)row.get("selected", Boolean.class)).booleanValue()) {
                        row.set("selected", (Object)false);
                    }
                    if (this.filter.accepts((Object)context, (Object)edge)) {
                        elements.add((CyIdentifiable)edge);
                    }
                    discreteMonitor.addWork(1);
                }
            }
            finally {
                if (this.filter instanceof MemoizableTransformer) {
                    ((MemoizableTransformer)this.filter).clearCache();
                }
            }
            this.monitor.done();
            return elements;
        }
    }

    private static abstract class AbstractSource
    implements TransformerSource<CyNetwork, CyIdentifiable> {
        private AbstractSource() {
        }

        public Class<CyNetwork> getContextType() {
            return CyNetwork.class;
        }

        public Class<CyIdentifiable> getElementType() {
            return CyIdentifiable.class;
        }

        public int getElementCount(CyNetwork context) {
            return context.getNodeCount() + context.getEdgeCount();
        }
    }
}

