/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.work;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.cytoscape.filter.internal.work.LazyWorker;

public class LazyWorkQueue {
    transient boolean hasNewWork;
    Lock lock = new ReentrantLock();
    Condition working = this.lock.newCondition();
    LazyWorker worker;

    public LazyWorkQueue() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    LazyWorkQueue.this.lock.lock();
                    try {
                        if (!LazyWorkQueue.this.hasNewWork) {
                            LazyWorkQueue.this.working.awaitUninterruptibly();
                        }
                        LazyWorkQueue.this.hasNewWork = false;
                    }
                    finally {
                        LazyWorkQueue.this.lock.unlock();
                    }
                    try {
                        LazyWorkQueue.this.worker.doWork();
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        }).start();
    }

    public void assignWorker(LazyWorker worker) {
        this.lock.lock();
        try {
            this.hasNewWork = true;
            this.worker = worker;
            this.working.signal();
        }
        finally {
            this.lock.unlock();
        }
    }
}

