/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.work;

import java.util.Objects;
import javax.swing.JProgressBar;
import org.cytoscape.filter.internal.view.AbstractPanel;
import org.cytoscape.filter.internal.view.AbstractPanelController;
import org.cytoscape.filter.internal.work.LazyWorkQueue;
import org.cytoscape.filter.internal.work.LazyWorker;
import org.cytoscape.filter.internal.work.ProgressMonitor;
import org.cytoscape.filter.model.TransformerListener;
import org.cytoscape.service.util.CyServiceRegistrar;

public abstract class AbstractWorker<V extends AbstractPanel<?, ?>, C extends AbstractPanelController<?, ?>>
implements LazyWorker,
TransformerListener {
    public static final int PROGRESS_BAR_MAXIMUM = Integer.MAX_VALUE;
    protected LazyWorkQueue queue;
    private ProgressMonitor currentMonitor;
    protected V view;
    protected C controller;
    protected boolean isInteractive;
    protected ApplyAction applyAction = ApplyAction.SELECT;
    protected final CyServiceRegistrar serviceRegistrar;

    public AbstractWorker(LazyWorkQueue queue, CyServiceRegistrar serviceRegistrar) {
        this.queue = queue;
        this.serviceRegistrar = serviceRegistrar;
    }

    public void handleSettingsChanged() {
        if (!this.isInteractive) {
            return;
        }
        this.queue.assignWorker(this);
    }

    public void handleFilterStructureChanged() {
        if (!this.isInteractive) {
            return;
        }
        this.queue.assignWorker(this);
    }

    public void cancel() {
        if (this.currentMonitor != null) {
            this.currentMonitor.cancel();
        }
    }

    public void setInteractive(boolean isInteractive) {
        this.isInteractive = isInteractive;
    }

    public void setApplyAction(ApplyAction action) {
        this.applyAction = Objects.requireNonNull(action);
    }

    public ApplyAction getApplyAction() {
        return this.applyAction;
    }

    public void requestWork() {
        this.queue.assignWorker(this);
    }

    public void setView(V view) {
        this.view = view;
    }

    public void setController(C controller) {
        this.controller = controller;
    }

    @Override
    public final synchronized void doWork() {
        this.currentMonitor = new ProgressMonitor(){
            private boolean cancelled = false;

            @Override
            public void cancel() {
                this.cancelled = true;
            }

            @Override
            public boolean isCancelled() {
                return this.cancelled;
            }

            @Override
            public void setProgress(double progress) {
                JProgressBar progressBar = ((AbstractPanel)AbstractWorker.this.view).getProgressBar();
                if (progress < 0.0) {
                    progressBar.setIndeterminate(true);
                    ((AbstractPanel)AbstractWorker.this.view).getCancelApplyButton().setEnabled(true);
                } else {
                    if (progressBar.isIndeterminate()) {
                        progressBar.setIndeterminate(false);
                    }
                    boolean done = progress == 1.0;
                    ((AbstractPanel)AbstractWorker.this.view).getApplyButton().setEnabled(done);
                    ((AbstractPanel)AbstractWorker.this.view).getCancelApplyButton().setEnabled(!done);
                    progressBar.setValue(done ? 0 : (int)(progress * 2.147483647E9));
                }
            }

            @Override
            public void setStatusMessage(String message) {
                ((AbstractPanel)AbstractWorker.this.view).setStatus(message);
            }
        };
        this.doWork(this.currentMonitor);
    }

    protected abstract void doWork(ProgressMonitor var1);

    public static enum ApplyAction {
        SELECT,
        SHOW;

    }
}

