/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.text.NumberFormatter;

public class ViewUtil {
    public static final Color SELECTED_BACKGROUND_COLOR = UIManager.getColor("Table.selectionBackground");
    public static final Color UNSELECTED_BACKGROUND_COLOR = UIManager.getColor("Table.background");
    public static final int INTERNAL_VERTICAL_PADDING = 4;
    public static final Border COMPOSITE_PANEL_BORDER = BorderFactory.createCompoundBorder(new DashedBorder(UIManager.getColor("Separator.foreground"), 3), BorderFactory.createEmptyBorder(4, 0, 4, 0));

    public static void configureFilterView(JComponent component) {
        component.setBackground(UNSELECTED_BACKGROUND_COLOR);
        component.setBorder(COMPOSITE_PANEL_BORDER);
    }

    public static NumberFormatter createIntegerFormatter(int minimum, int maximum) {
        NumberFormat format = NumberFormat.getIntegerInstance();
        NumberFormatter formatter = new NumberFormatter(format);
        formatter.setMinimum(Integer.valueOf(minimum));
        formatter.setMaximum(Integer.valueOf(maximum));
        formatter.setValueClass(Integer.class);
        formatter.setCommitsOnValidEdit(true);
        return formatter;
    }

    public static NumberFormatter createIntegerFormatter() {
        NumberFormat format = NumberFormat.getIntegerInstance();
        NumberFormatter formatter = new NumberFormatter(format);
        formatter.setValueClass(Integer.class);
        formatter.setCommitsOnValidEdit(true);
        return formatter;
    }

    public static JFormattedTextField.AbstractFormatterFactory createIntegerFormatterFactory() {
        return new JFormattedTextField.AbstractFormatterFactory(){

            @Override
            public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField tf) {
                return ViewUtil.createIntegerFormatter();
            }
        };
    }

    public static NumberFormatter createNumberFormatter() {
        NumberFormat format = NumberFormat.getNumberInstance();
        NumberFormatter formatter = new NumberFormatter(format);
        formatter.setValueClass(Double.class);
        formatter.setCommitsOnValidEdit(true);
        return formatter;
    }

    public static NumberFormatterFactory createNumberFormatterFactory() {
        return new NumberFormatterFactory();
    }

    public static String abbreviate(String s, int maxLength) {
        if (((String)(s = String.valueOf(s))).length() > maxLength) {
            s = ((String)s).substring(0, maxLength) + "...";
        }
        return s;
    }

    public static ListCellRenderer<Object> createElipsisRenderer(final int maxLength) {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                String longText = String.valueOf(value);
                String shortText = ViewUtil.abbreviate(longText, maxLength);
                this.setToolTipText(longText);
                this.setText(shortText);
                return this;
            }
        };
    }

    private static class NumberFormatterFactory
    extends JFormattedTextField.AbstractFormatterFactory {
        NumberFormatter decimal = ViewUtil.createNumberFormatter();
        NumberFormatter scientific = ViewUtil.createNumberFormatter();

        public NumberFormatterFactory() {
            Format scientificFormat = this.scientific.getFormat();
            if (scientificFormat instanceof DecimalFormat) {
                ((DecimalFormat)scientificFormat).applyPattern("0.0####E0");
            }
        }

        @Override
        public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField tf) {
            Double dx = 0.0;
            if (tf.getValue() != null && tf.getValue() instanceof Double) {
                dx = Math.abs((Double)tf.getValue());
            }
            if (dx != 0.0 && (dx > 1000000.0 || dx < 0.001)) {
                return this.scientific;
            }
            return this.decimal;
        }
    }

    private static class DashedBorder
    extends AbstractBorder {
        private static final long serialVersionUID = 3637717695720415472L;
        private final Color color;
        private final int width;

        public DashedBorder(Color color, int width) {
            this.color = color;
            this.width = width;
        }

        @Override
        public void paintBorder(Component comp, Graphics g, int x, int y, int w, int h) {
            Graphics2D gg = (Graphics2D)g;
            gg.setColor(this.color);
            gg.setStroke(new BasicStroke(this.width, 0, 2, 0.0f, new float[]{this.width}, 0.0f));
            gg.drawLine(x, y + comp.getHeight(), x + w - 1, y + comp.getHeight());
        }
    }
}

