/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.view;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.cytoscape.filter.TransformerManager;
import org.cytoscape.filter.internal.FilterIO;
import org.cytoscape.filter.internal.ModelMonitor;
import org.cytoscape.filter.internal.ModelUtil;
import org.cytoscape.filter.internal.filters.composite.CompositeFilterController;
import org.cytoscape.filter.internal.filters.composite.CompositeFilterPanel;
import org.cytoscape.filter.internal.filters.composite.CompositeSeparator;
import org.cytoscape.filter.internal.view.AbstractPanelController;
import org.cytoscape.filter.internal.view.CompositePanelComponent;
import org.cytoscape.filter.internal.view.DynamicComboBoxModel;
import org.cytoscape.filter.internal.view.FilterElement;
import org.cytoscape.filter.internal.view.FilterPanel;
import org.cytoscape.filter.internal.view.TransformerElementViewModel;
import org.cytoscape.filter.internal.view.TransformerViewManager;
import org.cytoscape.filter.internal.view.look.FilterPanelStyle;
import org.cytoscape.filter.internal.work.FilterWorker;
import org.cytoscape.filter.internal.work.ValidationManager;
import org.cytoscape.filter.model.CompositeFilter;
import org.cytoscape.filter.model.Filter;
import org.cytoscape.filter.model.NamedTransformer;
import org.cytoscape.filter.model.Transformer;
import org.cytoscape.filter.model.TransformerListener;
import org.cytoscape.filter.view.InteractivityChangedListener;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;

public class FilterPanelController
extends AbstractPanelController<FilterElement, FilterPanel> {
    private TransformerManager transformerManager;
    private TransformerViewManager transformerViewManager;
    private ModelMonitor modelMonitor;
    private boolean isInteractive;

    public FilterPanelController(TransformerManager transformerManager, TransformerViewManager transformerViewManager, ValidationManager validationManager, FilterWorker worker, ModelMonitor modelMonitor, FilterIO filterIo, FilterPanelStyle style, CyServiceRegistrar serviceRegistrar) {
        super(worker, transformerManager, transformerViewManager, validationManager, filterIo, style, serviceRegistrar);
        worker.setController(this);
        this.transformerManager = transformerManager;
        this.transformerViewManager = transformerViewManager;
        this.modelMonitor = modelMonitor;
        worker.setController(this);
        this.addNewElement("Default filter");
    }

    @Override
    public JComponent createView(FilterPanel parent, Transformer<CyNetwork, CyIdentifiable> filter, int depth) {
        JComponent view = this.transformerViewManager.createView(filter);
        if (view instanceof InteractivityChangedListener) {
            ((InteractivityChangedListener)view).handleInteractivityChanged(this.isInteractive);
        }
        if (filter instanceof CompositeFilter) {
            String addButtonTT = this.transformerViewManager.getAddButtonTooltip(filter);
            CompositeFilterController controller = CompositeFilterController.createFor(view, addButtonTT);
            return new CompositeFilterPanel<FilterPanel>(parent, this, controller, (CompositeFilter<CyNetwork, CyIdentifiable>)((CompositeFilter)filter), depth);
        }
        if (view == null) {
            throw new IllegalArgumentException("view could not be created for: " + filter.getId());
        }
        return view;
    }

    @Override
    protected FilterElement createElement(String name) {
        CompositeFilter filter = this.transformerManager.createCompositeFilter(CyNetwork.class, CyIdentifiable.class);
        filter.addListener((TransformerListener)this.worker);
        return new FilterElement(name, (CompositeFilter<CyNetwork, CyIdentifiable>)filter);
    }

    @Override
    protected void handleElementSelected(FilterElement selected, FilterPanel panel) {
        this.setFilter(selected.getFilter(), panel);
        this.worker.handleFilterStructureChanged();
    }

    private void setFilter(CompositeFilter<CyNetwork, CyIdentifiable> filter, FilterPanel parent) {
        CompositeFilterPanel root = (CompositeFilterPanel)this.createView(parent, (Transformer<CyNetwork, CyIdentifiable>)filter, 0);
        new TransformerElementViewModel<FilterPanel>(root, this, parent);
        parent.setRootPanel(root);
    }

    public Filter<CyNetwork, CyIdentifiable> getFilter() {
        FilterElement selected = (FilterElement)this.namedElementComboBoxModel.getSelectedItem();
        return selected.getFilter();
    }

    public boolean isInteractive() {
        return this.isInteractive;
    }

    public void setInteractive(boolean isInteractive, FilterPanel panel) {
        this.modelMonitor.setInteractive(isInteractive);
        this.worker.setInteractive(isInteractive);
        if (this.isInteractive == isInteractive) {
            return;
        }
        panel.getApplyAutomaticallyCheckBox().setSelected(isInteractive);
        this.isInteractive = isInteractive;
        CompositePanelComponent root = panel.getRootPanel();
        if (root != null) {
            this.setInteractive(isInteractive, (CompositeFilterPanel<FilterPanel>)root);
        }
    }

    private void setInteractive(boolean isInteractive, CompositeFilterPanel<FilterPanel> panel) {
        for (TransformerElementViewModel<FilterPanel> viewModel : panel.getViewModels()) {
            if (viewModel.view instanceof InteractivityChangedListener) {
                ((InteractivityChangedListener)viewModel.view).handleInteractivityChanged(isInteractive);
            }
            if (!(viewModel.view instanceof CompositeFilterPanel)) continue;
            this.setInteractive(isInteractive, (CompositeFilterPanel)viewModel.view);
        }
    }

    @Override
    public void synchronize(FilterPanel panel) {
        this.setInteractive(panel.getApplyAutomaticallyCheckBox().isSelected(), panel);
    }

    @Override
    protected String getPrompt() {
        return "Please provide a name for your filter.";
    }

    @Override
    protected String getCreateElementTitle() {
        return "Create New Filter";
    }

    @Override
    protected String getRenameElementTitle() {
        return "Rename Filter";
    }

    @Override
    protected String getElementTemplate() {
        return "My filter %1$d";
    }

    @Override
    protected String getElementExistsWarningTemplate() {
        return "The name '%1$s' is already being used by another filter.  Please provide a different name.";
    }

    @Override
    protected String getCreateMenuLabel() {
        return "New filter";
    }

    @Override
    protected String getDeleteMenuLabel() {
        return "Remove current filter";
    }

    @Override
    protected String getRenameMenuLabel() {
        return "Rename current filter";
    }

    @Override
    protected String getCopyMenuLabel() {
        return "Copy current filter";
    }

    @Override
    protected String getExportLabel() {
        return "Export filters...";
    }

    @Override
    protected String getImportLabel() {
        return "Import filters...";
    }

    @Override
    public String getHandleToolTip() {
        return "Drag this condition to another condition to group them, or drop it in a gap to reorder.";
    }

    @Override
    public void addNamedTransformer(FilterPanel panel, NamedTransformer<CyNetwork, CyIdentifiable> namedTransformer, boolean strictName) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(() -> this.addNamedTransformer(panel, namedTransformer, strictName));
            }
            catch (InterruptedException e) {
                this.logger.error("An unexpected error occurred", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                this.logger.error("An unexpected error occurred", (Throwable)e);
            }
            return;
        }
        int validated = 0;
        for (Transformer transformer : namedTransformer.getTransformers()) {
            if (!(transformer instanceof Filter)) continue;
            ++validated;
        }
        if (validated == 0) {
            return;
        }
        String name = strictName ? namedTransformer.getName() : this.findUniqueName(namedTransformer.getName());
        if (this.getElementByName(name) != null) {
            throw new IllegalArgumentException("Filter with name '" + name + "' already exists.");
        }
        boolean interactive = this.isInteractive();
        if (interactive) {
            this.setInteractive(false, panel);
        }
        FilterElement element = (FilterElement)this.addNewElement(name);
        List transformers = namedTransformer.getTransformers();
        if (transformers.size() == 1) {
            Transformer first = (Transformer)transformers.get(0);
            if (first instanceof CompositeFilter) {
                this.addCompositeFilter(element, (CompositeFilter<CyNetwork, CyIdentifiable>)((CompositeFilter)first));
            } else {
                this.addTransformers(element, transformers);
            }
        } else {
            this.addTransformers(element, transformers);
        }
        FilterElement selected = (FilterElement)this.namedElementComboBoxModel.getSelectedItem();
        if (selected == null) {
            return;
        }
        this.setFilter(selected.getFilter(), panel);
        if (interactive) {
            this.setInteractive(true, panel);
        }
    }

    private void addCompositeFilter(FilterElement element, CompositeFilter<CyNetwork, CyIdentifiable> composite) {
        element.getFilter().setType(composite.getType());
        for (int i = 0; i < composite.getLength(); ++i) {
            Filter filter = composite.get(i);
            this.addListeners((Filter<CyNetwork, CyIdentifiable>)filter);
            element.getFilter().append(filter);
        }
    }

    private void addTransformers(FilterElement element, List<Transformer<CyNetwork, CyIdentifiable>> transformers) {
        for (Transformer<CyNetwork, CyIdentifiable> transformer : transformers) {
            if (!(transformer instanceof Filter)) continue;
            Filter filter = (Filter)transformer;
            this.addListeners((Filter<CyNetwork, CyIdentifiable>)filter);
            element.getFilter().append(filter);
        }
    }

    private void addListeners(Filter<CyNetwork, CyIdentifiable> filter) {
        filter.addListener((TransformerListener)this.worker);
        if (filter instanceof CompositeFilter) {
            CompositeFilter composite = (CompositeFilter)filter;
            for (int i = 0; i < composite.getLength(); ++i) {
                this.addListeners((Filter<CyNetwork, CyIdentifiable>)composite.get(i));
            }
        }
    }

    @Override
    public NamedTransformer<CyNetwork, CyIdentifiable>[] getNamedTransformers() {
        DynamicComboBoxModel model = this.getElementComboBoxModel();
        NamedTransformer[] namedTransformers = new NamedTransformer[model.getSize()];
        int i = 0;
        for (FilterElement element : model) {
            if (element.getFilter() == null) continue;
            namedTransformers[i] = this.toNamedController(element);
            ++i;
        }
        return namedTransformers;
    }

    private NamedTransformer<CyNetwork, CyIdentifiable> toNamedController(FilterElement element) {
        Transformer[] transformers = new Transformer[]{element.getFilter()};
        return ModelUtil.createNamedTransformer(element.name, transformers);
    }

    @Override
    public NamedTransformer<CyNetwork, CyIdentifiable> getSelectedNamedTransformer() {
        DynamicComboBoxModel model = this.getElementComboBoxModel();
        return this.toNamedController((FilterElement)model.getSelectedItem());
    }

    @Override
    public void unregisterView(JComponent elementView) {
        this.modelMonitor.unregisterView(elementView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleDrop(FilterPanel parent, JComponent source, List<Integer> sourcePath, JComponent target, List<Integer> targetPath) {
        CompositePanelComponent root = parent.getRootPanel();
        CompositeFilterPanel sourceParent = (CompositeFilterPanel)source.getParent();
        try {
            if (targetPath.isEmpty()) {
                int sourceIndex = sourcePath.get(sourcePath.size() - 1);
                Filter<CyNetwork, CyIdentifiable> filter = sourceParent.getTransformerAt(sourceIndex);
                TransformerElementViewModel viewModel = sourceParent.getViewModel((Transformer<CyNetwork, CyIdentifiable>)filter);
                sourceParent.removeTransformer(sourceIndex, false);
                ((CompositeFilterPanel)root).addViewModel(filter, viewModel);
            } else {
                super.handleFilterDrop(parent, source, sourcePath, target, targetPath);
            }
        }
        finally {
            ((CompositeFilterPanel)root).setDepth(0);
            ((CompositeFilterPanel)root).updateLayout();
            this.worker.handleFilterStructureChanged();
        }
    }

    @Override
    public void handleDelete(FilterPanel view, JComponent component) {
        try {
            super.handleDelete(view, component);
        }
        finally {
            this.worker.handleFilterStructureChanged();
        }
    }

    @Override
    public boolean isDropMove(FilterPanel view, JComponent source, List<Integer> sourcePath, JComponent target, List<Integer> targetPath) {
        return target instanceof CompositeSeparator || target instanceof CompositeFilterPanel;
    }
}

