/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import org.cytoscape.filter.internal.filters.composite.CompositeSeparator;
import org.cytoscape.filter.internal.view.AbstractPanelController;
import org.cytoscape.filter.internal.view.Handle;
import org.cytoscape.filter.internal.view.PathDataFlavor;
import org.cytoscape.filter.internal.view.SelectPanelComponent;
import org.cytoscape.filter.internal.view.ViewUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DragHandler<V extends SelectPanelComponent>
implements DragGestureListener,
DragSourceListener,
DropTargetListener {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private JComponent view;
    private final AbstractPanelController<?, V> controller;
    private final V parent;
    private Transferable transferable;
    private static Cursor nextCursor;

    public DragHandler(JComponent view, AbstractPanelController<?, V> controller, V parent, JComponent handle) {
        this.view = view;
        this.controller = controller;
        this.parent = parent;
        this.transferable = this.createTransferable();
        if (handle != null) {
            DragSource source = DragSource.getDefaultDragSource();
            source.createDefaultDragGestureRecognizer(handle, 3, this);
        }
    }

    @Override
    public void dragExit(DragSourceEvent event) {
    }

    void setBackground(JComponent view, Color color) {
        view.setBackground(color);
        if (view instanceof Handle) {
            JComponent sibling = ((Handle)view).getSiblingView();
            sibling.setBackground(color);
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent event) {
        JComponent lastComponent = this.controller.getLastHoveredComponent();
        if (lastComponent != null) {
            this.setBackground(lastComponent, ViewUtil.UNSELECTED_BACKGROUND_COLOR);
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent event) {
    }

    @Override
    public void dragOver(DragSourceDragEvent event) {
        if (this.isMac()) {
            return;
        }
        if (nextCursor == null) {
            return;
        }
        event.getDragSourceContext().setCursor(nextCursor);
        nextCursor = null;
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent event) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent event) {
        int width = this.view.getWidth();
        int height = this.view.getHeight();
        BufferedImage image = this.view.getGraphicsConfiguration().createCompatibleImage(width, height);
        Graphics2D graphics = image.createGraphics();
        this.view.setBackground(ViewUtil.UNSELECTED_BACKGROUND_COLOR);
        this.view.paint(graphics);
        Point offset = this.computeOffset(width, height);
        event.startDrag(null, image, offset, this.transferable, this);
    }

    private Point computeOffset(int width, int height) {
        if (this.isMac()) {
            return new Point(0, -height);
        }
        return new Point(0, 0);
    }

    private boolean isMac() {
        return System.getProperty("os.name").startsWith("Mac OS X");
    }

    Transferable createTransferable() {
        return new Transferable(){

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavour) {
                return flavour instanceof PathDataFlavor;
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{PathDataFlavor.instance};
            }

            @Override
            public Object getTransferData(DataFlavor flavour) throws UnsupportedFlavorException, IOException {
                if (flavour instanceof PathDataFlavor) {
                    return DragHandler.this.controller.getPath(DragHandler.this.parent, DragHandler.this.view);
                }
                return null;
            }
        };
    }

    JComponent getPrimaryView(JComponent view) {
        if (view instanceof Handle) {
            return ((Handle)view).getSiblingView();
        }
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dragEnter(DropTargetDragEvent event) {
        JComponent lastComponent = this.controller.getLastHoveredComponent();
        if (lastComponent != null) {
            this.setBackground(lastComponent, ViewUtil.UNSELECTED_BACKGROUND_COLOR);
        }
        JComponent target = this.getPrimaryView(this.view);
        try {
            List sourcePath = (List)event.getTransferable().getTransferData(PathDataFlavor.instance);
            List<Integer> targetPath = this.controller.getPath(this.parent, target);
            JComponent sourceView = this.controller.getChild(this.parent, (List<Integer>)sourcePath);
            if (!this.controller.supportsDrop(this.parent, sourcePath, sourceView, targetPath, target) || this.isEquivalentLocation(sourcePath, targetPath, target)) {
                this.setCursor(DragSource.DefaultCopyNoDrop, target);
                return;
            }
            if (this.controller.isDropMove(this.parent, sourceView, sourcePath, target, targetPath)) {
                event.acceptDrag(2);
                this.setCursor(DragSource.DefaultMoveDrop, this.view);
            } else {
                event.acceptDrag(1);
                this.setCursor(DragSource.DefaultCopyDrop, this.view);
            }
        }
        catch (UnsupportedFlavorException e) {
            logger.error("Unexpected error", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Unexpected error", (Throwable)e);
        }
        finally {
            this.controller.setLastHoveredComponent(this.view);
        }
        target.setBackground(ViewUtil.SELECTED_BACKGROUND_COLOR);
    }

    private void setCursor(Cursor cursor, Component hoveredView) {
        if (this.isMac()) {
            hoveredView.setCursor(cursor);
        } else {
            if (cursor == null) {
                cursor = Cursor.getDefaultCursor();
            }
            nextCursor = cursor;
        }
    }

    private boolean isEquivalentLocation(List<Integer> source, List<Integer> target, JComponent targetComponent) {
        int targetIndex;
        int size = source.size();
        if (size != target.size()) {
            return false;
        }
        for (int i = 0; i < size - 2; ++i) {
            if (source.get(i) == target.get(i)) continue;
            return false;
        }
        int sourceIndex = source.get(size - 1);
        return sourceIndex == (targetIndex = target.get(size - 1).intValue()) || sourceIndex - 1 == targetIndex && targetComponent instanceof CompositeSeparator;
    }

    @Override
    public void dragExit(DropTargetEvent event) {
        this.setCursor(null, this.view.getParent());
        this.setCursor(null, this.view);
        if (this.view instanceof Handle) {
            JComponent sibling = ((Handle)this.view).getSiblingView();
            this.setCursor(null, sibling);
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent event) {
    }

    @Override
    public void drop(DropTargetDropEvent event) {
        JComponent target = this.getPrimaryView(this.view);
        this.setCursor(null, this.view);
        try {
            List path = (List)event.getTransferable().getTransferData(PathDataFlavor.instance);
            JComponent sourceView = this.controller.getChild(this.parent, (List<Integer>)path);
            if (sourceView == target) {
                event.rejectDrop();
                return;
            }
            List<Integer> targetPath = this.controller.getPath(this.parent, target);
            if (targetPath == null) {
                event.rejectDrop();
                return;
            }
            if (!this.controller.supportsDrop(this.parent, path, sourceView, targetPath, target) || this.isEquivalentLocation(path, targetPath, target)) {
                event.rejectDrop();
                return;
            }
            this.controller.handleDrop(this.parent, sourceView, path, target, targetPath);
            event.acceptDrop(0x40000000);
            event.dropComplete(true);
        }
        catch (UnsupportedFlavorException e) {
            logger.error("Unexpected error", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Unexpected error", (Throwable)e);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent event) {
    }
}

