/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.view;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.cytoscape.filter.internal.view.look.FilterPanelStyle;

public class BooleanComboBox
extends JPanel {
    private final JComboBox<Element> combo;
    private Map<StateChangeListener, ActionListener> actionListeners = new IdentityHashMap<StateChangeListener, ActionListener>();

    public BooleanComboBox(FilterPanelStyle style, String trueLabel, String falseLabel) {
        this.combo = style.createCombo(new Element[]{new Element(trueLabel, true), new Element(falseLabel, false)});
        this.setLayout(new BorderLayout());
        this.add(this.combo, "Center");
        this.setOpaque(false);
    }

    public boolean booleanValue() {
        return this.combo.getItemAt((int)this.combo.getSelectedIndex()).value;
    }

    public void setState(boolean state) {
        this.combo.setSelectedIndex(state ? 0 : 1);
    }

    public void addStateChangeListener(final StateChangeListener listener) {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                listener.stateChanged(BooleanComboBox.this.booleanValue());
            }
        };
        this.actionListeners.put(listener, actionListener);
        this.combo.addActionListener(actionListener);
    }

    public void removeStateChangeListener(StateChangeListener listener) {
        this.combo.removeActionListener(this.actionListeners.remove(listener));
    }

    private class Element {
        final String name;
        final boolean value;

        Element(String name, boolean value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return this.name;
        }
    }

    public static interface StateChangeListener {
        public void stateChanged(boolean var1);
    }
}

