/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.filter.TransformerManager;
import org.cytoscape.filter.internal.FilterIO;
import org.cytoscape.filter.internal.filters.composite.CompositeFilterPanel;
import org.cytoscape.filter.internal.filters.composite.CompositeSeparator;
import org.cytoscape.filter.internal.tasks.ExportNamedTransformersTask;
import org.cytoscape.filter.internal.tasks.ImportNamedTransformersTask;
import org.cytoscape.filter.internal.view.AbstractPanel;
import org.cytoscape.filter.internal.view.CompositePanelComponent;
import org.cytoscape.filter.internal.view.DynamicComboBoxModel;
import org.cytoscape.filter.internal.view.NamedElement;
import org.cytoscape.filter.internal.view.NamedElementListener;
import org.cytoscape.filter.internal.view.SelectPanelComponent;
import org.cytoscape.filter.internal.view.TransformerElementViewModel;
import org.cytoscape.filter.internal.view.TransformerViewManager;
import org.cytoscape.filter.internal.view.look.FilterPanelStyle;
import org.cytoscape.filter.internal.work.AbstractWorker;
import org.cytoscape.filter.internal.work.ValidationManager;
import org.cytoscape.filter.model.CompositeFilter;
import org.cytoscape.filter.model.Filter;
import org.cytoscape.filter.model.NamedTransformer;
import org.cytoscape.filter.model.Transformer;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.hide.UnHideAllTaskFactory;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.SynchronousTaskManager;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPanelController<T extends NamedElement, V extends SelectPanelComponent> {
    public static final int PROGRESS_BAR_MAXIMUM = Integer.MAX_VALUE;
    static final Pattern NAME_PATTERN = Pattern.compile("(.*?)( (\\d+))?");
    private final TransformerManager transformerManager;
    private final TransformerViewManager transformerViewManager;
    private final ValidationManager validationManager;
    private final FilterPanelStyle style;
    private List<NamedElementListener<T>> namedElementListeners;
    protected DynamicComboBoxModel<T> namedElementComboBoxModel;
    protected AbstractWorker<?, ?> worker;
    private FilterIO filterIo;
    private JComponent lastHoveredComponent;
    protected final CyServiceRegistrar serviceRegistrar;
    final Logger logger;

    public AbstractPanelController(AbstractWorker<?, ?> worker, TransformerManager transformerManager, TransformerViewManager transformerViewManager, ValidationManager validationManager, FilterIO filterIo, FilterPanelStyle style, CyServiceRegistrar serviceRegistrar) {
        this.worker = worker;
        this.filterIo = filterIo;
        this.transformerManager = transformerManager;
        this.transformerViewManager = transformerViewManager;
        this.validationManager = validationManager;
        this.style = style;
        this.serviceRegistrar = serviceRegistrar;
        this.logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
        ArrayList modelItems = new ArrayList();
        this.namedElementComboBoxModel = new DynamicComboBoxModel(modelItems);
        this.namedElementListeners = new CopyOnWriteArrayList<NamedElementListener<T>>();
    }

    public void setApplyAction(AbstractWorker.ApplyAction action) {
        CyApplicationManager applicationManager;
        CyNetworkView networkView;
        if (action == AbstractWorker.ApplyAction.SELECT && this.worker.getApplyAction() != action && (networkView = (applicationManager = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetworkView()) != null) {
            UnHideAllTaskFactory unhideFactory = (UnHideAllTaskFactory)this.serviceRegistrar.getService(UnHideAllTaskFactory.class);
            TaskIterator unhideTasks = unhideFactory.createTaskIterator(networkView);
            SynchronousTaskManager taskManager = (SynchronousTaskManager)this.serviceRegistrar.getService(SynchronousTaskManager.class);
            taskManager.execute(unhideTasks);
        }
        this.worker.setApplyAction(action);
    }

    public JPopupMenu createAddConditionMenu(final CompositeFilterPanel<?> panel) {
        JPopupMenu menu = new JPopupMenu();
        for (final TransformerViewManager.TransformerViewElement element : this.transformerViewManager.getFilterConditionViewElements()) {
            JMenuItem mi = new JMenuItem(element.toString());
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractPanelController.this.handleAddCondition(element, panel);
                }
            });
            menu.add(mi);
        }
        return menu;
    }

    private void handleAddCondition(TransformerViewManager.TransformerViewElement element, CompositeFilterPanel<?> panel) {
        Transformer transformer = this.transformerManager.createTransformer(element.getId());
        Filter filter = (Filter)transformer;
        panel.addFilter((Filter<CyNetwork, CyIdentifiable>)filter);
        panel.updateLayout();
        filter.addListener(this.worker);
        this.worker.handleFilterStructureChanged();
    }

    public void addNamedElementListener(NamedElementListener<T> listener) {
        if (this.namedElementListeners.contains(listener)) {
            return;
        }
        this.namedElementListeners.add(listener);
        for (NamedElement element : this.namedElementComboBoxModel) {
            listener.handleElementAdded(element);
        }
    }

    public void removeNamedElementListener(NamedElementListener<T> listener) {
        this.namedElementListeners.remove(listener);
    }

    void handleDelete() {
        int index = this.namedElementComboBoxModel.getSelectedIndex();
        if (index == -1) {
            return;
        }
        this.handleDelete(index);
    }

    boolean handleDelete(String name) {
        List items = this.namedElementComboBoxModel.items;
        for (int i = 0; i < items.size(); ++i) {
            NamedElement element = (NamedElement)items.get(i);
            if (!element.name.equals(name)) continue;
            this.handleDelete(i);
            return true;
        }
        return false;
    }

    private void handleDelete(int index) {
        this.notifyRemoved((NamedElement)this.namedElementComboBoxModel.remove(index));
    }

    private void notifyRemoved(T element) {
        for (NamedElementListener<T> listener : this.namedElementListeners) {
            try {
                listener.handleElementRemoved(element);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void notifyAdded(T element) {
        for (NamedElementListener<T> listener : this.namedElementListeners) {
            try {
                listener.handleElementAdded(element);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void createNewElement(V panel) {
        String name;
        String defaultName = this.findUniqueName(String.format(this.getElementTemplate(), 1));
        String message = this.getPrompt();
        while (true) {
            if ((name = (String)JOptionPane.showInputDialog(null, message, this.getCreateElementTitle(), 3, null, null, defaultName)) == null) {
                return;
            }
            if (this.validateName(null, name, this.namedElementComboBoxModel)) break;
            message = String.format(this.getElementExistsWarningTemplate(), name);
        }
        this.addNewElement(name);
        this.handleElementSelected(panel);
    }

    protected void handleElementSelected(V panel) {
        NamedElement selected = (NamedElement)this.namedElementComboBoxModel.getSelectedItem();
        if (selected == null) {
            return;
        }
        this.handleElementSelected(selected, panel);
        this.validationManager.runValidation();
    }

    String findUniqueName(String name) {
        Integer largestSuffix = null;
        String prefix = this.getNamePrefix(name);
        Pattern pattern = Pattern.compile(String.format("%s( (\\d+))?", Pattern.quote(prefix)));
        for (NamedElement element : this.namedElementComboBoxModel) {
            Matcher matcher;
            if (element.name == null || !(matcher = pattern.matcher(element.name)).matches()) continue;
            String rawSuffix = matcher.group(2);
            int suffix = rawSuffix == null ? 0 : Integer.parseInt(rawSuffix);
            if (largestSuffix == null) {
                largestSuffix = suffix;
                continue;
            }
            largestSuffix = Math.max(largestSuffix, suffix);
        }
        if (largestSuffix == null) {
            return name;
        }
        return String.format("%s %d", prefix, largestSuffix + 1);
    }

    private String getNamePrefix(String name) {
        Matcher matcher = NAME_PATTERN.matcher(name);
        matcher.matches();
        return matcher.group(1);
    }

    private String promptForName(String defaultName) {
        String name;
        Object message = this.getPrompt();
        while (true) {
            if ((name = (String)JOptionPane.showInputDialog(null, message, this.getRenameElementTitle(), 3, null, null, defaultName)) == null) {
                return null;
            }
            if (this.validateName(defaultName, name, this.namedElementComboBoxModel)) break;
            message = "The name '" + name + "' is already being used by another filter.  Please provide a different name.";
        }
        return name;
    }

    void handleRename() {
        NamedElement selected = (NamedElement)this.namedElementComboBoxModel.getSelectedItem();
        String name = this.promptForName(selected.name);
        if (name != null) {
            selected.name = name;
        }
    }

    public DynamicComboBoxModel<T> getElementComboBoxModel() {
        return this.namedElementComboBoxModel;
    }

    protected boolean validateName(String oldName, String newName, DynamicComboBoxModel<T> comboBoxModel) {
        if (oldName != null && oldName.equalsIgnoreCase(newName)) {
            return true;
        }
        for (NamedElement element : comboBoxModel) {
            if (!element.name.equalsIgnoreCase(newName)) continue;
            return false;
        }
        return true;
    }

    public T addNewElement(String name) {
        T element = this.createElement(name);
        this.namedElementComboBoxModel.add(element);
        this.namedElementComboBoxModel.setSelectedItem(element);
        this.notifyAdded(element);
        return element;
    }

    public T getElementByName(String name) {
        for (NamedElement element : this.namedElementComboBoxModel.items) {
            if (!element.name.equals(name)) continue;
            return (T)element;
        }
        return null;
    }

    public void reset(V view) {
        view.reset();
        while (this.namedElementComboBoxModel.getSize() > 0) {
            this.notifyRemoved((NamedElement)this.namedElementComboBoxModel.items.remove(0));
        }
        this.namedElementComboBoxModel.notifyChanged(0, 0);
    }

    public void handleCancelApply(V view) {
        this.worker.cancel();
    }

    public void handleApplyFilter(V view) {
        this.worker.requestWork();
    }

    public int getElementCount() {
        return this.namedElementComboBoxModel.items.size();
    }

    protected void handleExport() {
        ExportNamedTransformersTask task = new ExportNamedTransformersTask(this.filterIo, this);
        ((TaskManager)this.serviceRegistrar.getService(TaskManager.class)).execute(new TaskIterator(new Task[]{task}));
    }

    protected void handleImport(V view) {
        ImportNamedTransformersTask task = new ImportNamedTransformersTask(this.filterIo, (AbstractPanel)view);
        ((TaskManager)this.serviceRegistrar.getService(TaskManager.class)).execute(new TaskIterator(new Task[]{task}));
    }

    void handleCopy(V view) {
        NamedTransformer<CyNetwork, CyIdentifiable> transformer = this.getSelectedNamedTransformer();
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.filterIo.writeFilters(out, new NamedTransformer[]{transformer});
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            this.filterIo.readTransformers(in, (AbstractPanel)view);
        }
        catch (IOException e) {
            this.logger.error("An unexpected error occurred", (Throwable)e);
        }
    }

    public JComponent getLastHoveredComponent() {
        return this.lastHoveredComponent;
    }

    public void setLastHoveredComponent(JComponent component) {
        this.lastHoveredComponent = component;
    }

    boolean isParentOrSelf(JComponent source, Component target) {
        while (target != null) {
            if (source == target) {
                return true;
            }
            target = target.getParent();
        }
        return false;
    }

    public FilterPanelStyle getStyle() {
        return this.style;
    }

    public IconManager getIconManager() {
        return (IconManager)this.serviceRegistrar.getService(IconManager.class);
    }

    public ValidationManager getValidationManager() {
        return this.validationManager;
    }

    public List<Integer> getPath(V view, JComponent component) {
        if (component == view.getRootPanel()) {
            return Collections.emptyList();
        }
        LinkedList<Integer> path = new LinkedList<Integer>();
        Container current = component;
        Container nextParent = component.getParent();
        while (nextParent instanceof CompositePanelComponent) {
            CompositePanelComponent composite = (CompositePanelComponent)((Object)nextParent);
            if (current == composite.getSeparator()) {
                path.addFirst(-1);
            } else {
                boolean found = false;
                for (int i = 0; i < composite.getTransformerCount(); ++i) {
                    Transformer<CyNetwork, CyIdentifiable> filter = composite.getTransformerAt(i);
                    TransformerElementViewModel<? extends SelectPanelComponent> viewModel = composite.getViewModel(filter);
                    if (current != viewModel.view && current != viewModel.separator && current != viewModel.handle) continue;
                    path.addFirst(i);
                    found = true;
                    break;
                }
                if (!found) {
                    return null;
                }
            }
            current = nextParent;
            nextParent = nextParent.getParent();
        }
        if (path.isEmpty()) {
            return null;
        }
        return path;
    }

    public void handleDelete(V view, JComponent component) {
        if (component == null) {
            return;
        }
        List<Integer> path = this.getPath(view, component);
        int index = path.get(path.size() - 1);
        Container parent = component.getParent();
        if (parent instanceof CompositePanelComponent) {
            CompositePanelComponent compositePanel = (CompositePanelComponent)((Object)parent);
            compositePanel.removeTransformer(index, true);
        }
        CompositePanelComponent root = view.getRootPanel();
        root.updateLayout();
    }

    public JComponent getChild(V view, List<Integer> path) {
        CompositePanelComponent root = view.getRootPanel();
        if (path.isEmpty()) {
            return root.getComponent();
        }
        return this.getChild(root, (List<Integer>)new ArrayList<Integer>(path));
    }

    private JComponent getChild(CompositePanelComponent panel, List<Integer> path) {
        if (path.isEmpty()) {
            return null;
        }
        int index = path.remove(0);
        JComponent view = panel.getViewModel(panel.getTransformerAt((int)index)).view;
        if (path.isEmpty()) {
            return view;
        }
        return this.getChild((CompositePanelComponent)((Object)view), path);
    }

    public boolean supportsDrop(V parent, List<Integer> sourcePath, JComponent source, List<Integer> targetPath, JComponent target) {
        return !this.isParentOrSelf(source, target);
    }

    protected void handleFilterDrop(V parent, JComponent source, List<Integer> sourcePath, JComponent target, List<Integer> targetPath) {
        CompositeFilterPanel sourceParent = (CompositeFilterPanel)source.getParent();
        int sourceIndex = sourcePath.get(sourcePath.size() - 1);
        Filter<CyNetwork, CyIdentifiable> filter = sourceParent.getTransformerAt(sourceIndex);
        TransformerElementViewModel viewModel = sourceParent.getViewModel((Transformer<CyNetwork, CyIdentifiable>)filter);
        sourceParent.removeTransformer(sourceIndex, false);
        if (target instanceof CompositeSeparator) {
            int targetIndex = targetPath.get(targetPath.size() - 1) + 1;
            if (sourcePath.size() == targetPath.size() && sourceIndex < targetIndex) {
                --targetIndex;
            }
            CompositeFilterPanel targetParent = (CompositeFilterPanel)target.getParent();
            targetParent.addViewModel(targetIndex, filter, viewModel);
        } else if (target instanceof CompositeFilterPanel) {
            ((CompositeFilterPanel)target).addViewModel(filter, viewModel);
        } else {
            int targetIndex = targetPath.get(targetPath.size() - 1);
            if (sourceIndex < targetIndex) {
                --targetIndex;
            }
            CompositeFilterPanel targetParent = (CompositeFilterPanel)target.getParent();
            Filter targetFilter = targetParent.getModel().get(targetIndex);
            TransformerElementViewModel targetViewModel = targetParent.getViewModel((Transformer<CyNetwork, CyIdentifiable>)targetFilter);
            targetParent.removeTransformer(targetIndex, false);
            CompositeFilter group = this.transformerManager.createCompositeFilter(CyNetwork.class, CyIdentifiable.class);
            group.addListener(this.worker);
            CompositeFilterPanel groupView = (CompositeFilterPanel)this.createView(parent, (Transformer<CyNetwork, CyIdentifiable>)group, targetParent.getDepth() + 1);
            TransformerElementViewModel<V> groupViewModel = new TransformerElementViewModel<V>(groupView, this, parent);
            targetParent.addViewModel(targetIndex, (Filter<CyNetwork, CyIdentifiable>)group, groupViewModel);
            groupView.addViewModel((Filter<CyNetwork, CyIdentifiable>)targetFilter, targetViewModel);
            groupView.addViewModel(filter, viewModel);
        }
        this.removeOrphans(sourceParent);
    }

    private void removeOrphans(CompositeFilterPanel<V> panel) {
        CompositeFilter<CyNetwork, CyIdentifiable> model = panel.getModel();
        if (model.getLength() > 0) {
            return;
        }
        Container parent = panel.getParent();
        if (!(parent instanceof CompositeFilterPanel)) {
            return;
        }
        CompositeFilterPanel parentPanel = (CompositeFilterPanel)parent;
        CompositeFilter<CyNetwork, CyIdentifiable> parentModel = parentPanel.getModel();
        for (int index = 0; index < parentModel.getLength(); ++index) {
            Filter filter = parentModel.get(index);
            if (model != filter) continue;
            parentPanel.removeTransformer(index, true);
            this.removeOrphans(parentPanel);
            return;
        }
    }

    protected abstract String getElementExistsWarningTemplate();

    protected abstract String getPrompt();

    protected abstract String getCreateElementTitle();

    protected abstract String getRenameElementTitle();

    protected abstract String getElementTemplate();

    protected abstract String getCreateMenuLabel();

    protected abstract String getCopyMenuLabel();

    protected abstract String getRenameMenuLabel();

    protected abstract String getDeleteMenuLabel();

    protected abstract String getExportLabel();

    protected abstract String getImportLabel();

    public abstract String getHandleToolTip();

    protected abstract T createElement(String var1);

    protected abstract void handleElementSelected(T var1, V var2);

    protected abstract void synchronize(V var1);

    public abstract JComponent createView(V var1, Transformer<CyNetwork, CyIdentifiable> var2, int var3);

    public abstract void unregisterView(JComponent var1);

    public abstract void addNamedTransformer(V var1, NamedTransformer<CyNetwork, CyIdentifiable> var2, boolean var3);

    public abstract NamedTransformer<CyNetwork, CyIdentifiable>[] getNamedTransformers();

    public abstract NamedTransformer<CyNetwork, CyIdentifiable> getSelectedNamedTransformer();

    public abstract void handleDrop(V var1, JComponent var2, List<Integer> var3, JComponent var4, List<Integer> var5);

    public abstract boolean isDropMove(V var1, JComponent var2, List<Integer> var3, JComponent var4, List<Integer> var5);
}

