/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.cytoscape.filter.TransformerContainer;
import org.cytoscape.filter.internal.view.AbstractPanelController;
import org.cytoscape.filter.internal.view.DynamicComboBoxModel;
import org.cytoscape.filter.internal.view.NamedElement;
import org.cytoscape.filter.internal.view.SelectPanelComponent;
import org.cytoscape.filter.internal.view.ViewUtil;
import org.cytoscape.filter.internal.work.AbstractWorker;
import org.cytoscape.filter.model.NamedTransformer;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;

public abstract class AbstractPanel<T extends NamedElement, C extends AbstractPanelController>
extends JPanel
implements SelectPanelComponent,
TransformerContainer<CyNetwork, CyIdentifiable> {
    protected C controller;
    protected JComboBox namedElementComboBox;
    protected JButton optionsButton;
    protected Component editControlPanel;
    protected JScrollPane scrollPane;
    protected JButton applyButton;
    protected JButton cancelApplyButton;
    protected JProgressBar progressBar;
    protected JRadioButton selectButton;
    protected JRadioButton filterButton;
    protected JLabel statusLabel;
    protected final CyServiceRegistrar serviceRegistrar;

    public AbstractPanel(C controller, CyServiceRegistrar serviceRegistrar) {
        this.controller = controller;
        this.serviceRegistrar = serviceRegistrar;
        DynamicComboBoxModel model = ((AbstractPanelController)controller).getElementComboBoxModel();
        this.namedElementComboBox = new JComboBox(model);
        this.namedElementComboBox.setRenderer(ViewUtil.createElipsisRenderer(50));
        this.namedElementComboBox.addActionListener(e -> controller.handleElementSelected(this));
        IconManager iconManager = (IconManager)serviceRegistrar.getService(IconManager.class);
        this.optionsButton = new JButton("\uf0c9");
        this.optionsButton.setFont(iconManager.getIconFont(12.0f));
        this.optionsButton.setToolTipText("Options...");
        this.optionsButton.addActionListener(this::handleShowMenu);
        this.applyButton = new JButton("Apply");
        this.applyButton.addActionListener(e -> controller.handleApplyFilter(this));
        this.cancelApplyButton = new JButton("\uf05e");
        this.cancelApplyButton.addActionListener(e -> controller.handleCancelApply(this));
        this.cancelApplyButton.setFont(iconManager.getIconFont(17.0f));
        this.cancelApplyButton.setEnabled(false);
        this.cancelApplyButton.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.cancelApplyButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (AbstractPanel.this.cancelApplyButton.isEnabled()) {
                    AbstractPanel.this.cancelApplyButton.setForeground(UIManager.getColor("Focus.color"));
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (AbstractPanel.this.cancelApplyButton.isEnabled()) {
                    AbstractPanel.this.cancelApplyButton.setForeground(UIManager.getColor("Button.foreground"));
                }
            }
        });
        this.statusLabel = new JLabel(" ");
        this.progressBar = new JProgressBar();
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(Integer.MAX_VALUE);
        this.selectButton = new JRadioButton("select");
        this.filterButton = new JRadioButton("show");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.selectButton);
        buttonGroup.add(this.filterButton);
        this.selectButton.setSelected(true);
        this.selectButton.addActionListener(e -> {
            controller.setApplyAction(AbstractWorker.ApplyAction.SELECT);
            this.applyButton.doClick();
        });
        this.filterButton.addActionListener(e -> {
            controller.setApplyAction(AbstractWorker.ApplyAction.SHOW);
            this.applyButton.doClick();
        });
        LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.statusLabel, this.selectButton, this.filterButton});
    }

    private void handleShowMenu(ActionEvent event) {
        JMenuItem createMenu = new JMenuItem(((AbstractPanelController)this.controller).getCreateMenuLabel());
        createMenu.addActionListener(e -> ((AbstractPanelController)this.controller).createNewElement((AbstractPanel)this));
        JMenuItem renameMenu = new JMenuItem(((AbstractPanelController)this.controller).getRenameMenuLabel());
        renameMenu.addActionListener(e -> ((AbstractPanelController)this.controller).handleRename());
        JMenuItem copyMenu = new JMenuItem(((AbstractPanelController)this.controller).getCopyMenuLabel());
        copyMenu.addActionListener(e -> ((AbstractPanelController)this.controller).handleCopy((AbstractPanel)this));
        JMenuItem deleteMenu = new JMenuItem(((AbstractPanelController)this.controller).getDeleteMenuLabel());
        deleteMenu.addActionListener(e -> ((AbstractPanelController)this.controller).handleDelete());
        JMenuItem exportMenu = new JMenuItem(((AbstractPanelController)this.controller).getExportLabel());
        exportMenu.addActionListener(e -> ((AbstractPanelController)this.controller).handleExport());
        JMenuItem importMenu = new JMenuItem(((AbstractPanelController)this.controller).getImportLabel());
        importMenu.addActionListener(e -> ((AbstractPanelController)this.controller).handleImport((AbstractPanel)this));
        JPopupMenu menu = new JPopupMenu();
        menu.add(createMenu);
        menu.add(renameMenu);
        menu.add(copyMenu);
        menu.add(deleteMenu);
        menu.add(exportMenu);
        menu.add(importMenu);
        DynamicComboBoxModel model = ((AbstractPanelController)this.controller).getElementComboBoxModel();
        NamedElement selected = (NamedElement)model.getSelectedItem();
        renameMenu.setEnabled(selected != null);
        copyMenu.setEnabled(selected != null);
        deleteMenu.setEnabled(model.getSize() > 1);
        Component c = (Component)event.getSource();
        menu.show(c, 0, c.getHeight());
    }

    protected Component createEditPanel() {
        this.scrollPane = new JScrollPane();
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        int row = 0;
        panel.add((Component)this.scrollPane, new GridBagConstraints(0, row++, 1, 1, 1.0, 1.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public Component getEditPanel() {
        return this.editControlPanel;
    }

    protected JPanel createApplyPanel(boolean showButton) {
        JPanel panel = new JPanel();
        panel.setOpaque(!LookAndFeelUtil.isAquaLAF());
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateContainerGaps(false);
        layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
        if (showButton) {
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addGroup(layout.createSequentialGroup().addComponent(this.selectButton, -2, -1, -2).addComponent(this.filterButton, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.applyButton, -2, -1, -2).addComponent(this.progressBar, -1, -1, Short.MAX_VALUE).addComponent(this.cancelApplyButton, -2, -1, -2)).addComponent(this.statusLabel, -1, -1, Short.MAX_VALUE));
            layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.selectButton, -2, -1, -2).addComponent(this.filterButton, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.applyButton, -2, -1, -2).addComponent(this.progressBar, -2, -1, -2).addComponent(this.cancelApplyButton, -2, -1, -2)).addComponent(this.statusLabel, -2, -1, -2));
        } else {
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addGroup(layout.createSequentialGroup().addComponent(this.applyButton, -2, -1, -2).addComponent(this.progressBar, -1, -1, Short.MAX_VALUE).addComponent(this.cancelApplyButton, -2, -1, -2)).addComponent(this.statusLabel, -1, -1, Short.MAX_VALUE));
            layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.applyButton, -2, -1, -2).addComponent(this.progressBar, -2, -1, -2).addComponent(this.cancelApplyButton, -2, -1, -2)).addComponent(this.statusLabel, -2, -1, -2));
        }
        return panel;
    }

    @Override
    public void setStatus(String status) {
        if (status == null || status.isEmpty()) {
            status = " ";
        }
        this.statusLabel.setText(status);
    }

    @Override
    public JComponent getApplyButton() {
        return this.applyButton;
    }

    @Override
    public JComponent getCancelApplyButton() {
        return this.cancelApplyButton;
    }

    @Override
    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public C getController() {
        return this.controller;
    }

    public void addNamedTransformer(NamedTransformer<CyNetwork, CyIdentifiable> transformer) {
        ((AbstractPanelController)this.controller).addNamedTransformer((AbstractPanel)this, transformer, true);
    }

    public NamedTransformer<CyNetwork, CyIdentifiable> getNamedTransformer(String name) {
        if (name == null) {
            return null;
        }
        NamedTransformer<CyNetwork, CyIdentifiable>[] namedTransformers = ((AbstractPanelController)this.controller).getNamedTransformers();
        if (namedTransformers == null) {
            return null;
        }
        for (NamedTransformer<CyNetwork, CyIdentifiable> transformer : namedTransformers) {
            if (!name.equals(transformer.getName())) continue;
            return transformer;
        }
        return null;
    }

    public List<NamedTransformer<CyNetwork, CyIdentifiable>> getNamedTransformers() {
        NamedTransformer<CyNetwork, CyIdentifiable>[] namedTransformers = ((AbstractPanelController)this.controller).getNamedTransformers();
        return Arrays.asList(namedTransformers);
    }

    public boolean removeNamedTransformer(String name) {
        if (name == null) {
            return false;
        }
        return ((AbstractPanelController)this.controller).handleDelete(name);
    }

    protected void styleToolBarButton(JButton btn) {
        btn.setBorderPainted(false);
        btn.setContentAreaFilled(false);
        btn.setOpaque(false);
        btn.setFocusPainted(false);
        btn.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
    }
}

