/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.view;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public abstract class AbstractComboBoxModel
implements ComboBoxModel {
    private List<ListDataListener> listeners = new CopyOnWriteArrayList<ListDataListener>();

    @Override
    public void addListDataListener(ListDataListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListDataListener(ListDataListener listener) {
        this.listeners.removeAll(Collections.singleton(listener));
    }

    void notifyAdded(int startIndex, int endIndex) {
        ListDataEvent event = new ListDataEvent(this, 1, startIndex, endIndex);
        for (ListDataListener listener : this.listeners) {
            listener.contentsChanged(event);
        }
    }

    void notifyRemoved(int startIndex, int endIndex) {
        ListDataEvent event = new ListDataEvent(this, 2, startIndex, endIndex);
        for (ListDataListener listener : this.listeners) {
            listener.contentsChanged(event);
        }
    }

    public void notifyChanged(int start, int end) {
        ListDataEvent event = new ListDataEvent(this, 0, start, end);
        for (ListDataListener listener : this.listeners) {
            listener.contentsChanged(event);
        }
    }
}

