/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.transformers.interaction;

import org.cytoscape.filter.internal.AbstractMemoizableTransformer;
import org.cytoscape.filter.internal.filters.composite.CompositeFilterImpl;
import org.cytoscape.filter.model.CompositeFilter;
import org.cytoscape.filter.model.ElementTransformer;
import org.cytoscape.filter.model.Filter;
import org.cytoscape.filter.model.SubFilterTransformer;
import org.cytoscape.filter.model.TransformerSink;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.work.Tunable;

public class InteractionTransformer
extends AbstractMemoizableTransformer<CyNetwork, CyIdentifiable>
implements ElementTransformer<CyNetwork, CyIdentifiable>,
SubFilterTransformer<CyNetwork, CyIdentifiable> {
    private final CompositeFilter<CyNetwork, CyIdentifiable> nodeFilter;
    @Tunable
    public boolean selectSource;
    @Tunable
    public boolean selectTarget;
    private Action action = Action.ADD;

    public InteractionTransformer() {
        this.nodeFilter = new CompositeFilterImpl<CyNetwork, CyIdentifiable>(CyNetwork.class, CyIdentifiable.class);
        this.nodeFilter.setType(CompositeFilter.Type.ALL);
        this.nodeFilter.addListener(() -> this.notifyListeners());
        this.selectSource = true;
        this.selectTarget = true;
    }

    @Tunable
    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
        this.notifyListeners();
    }

    public String getName() {
        return "Edge Interaction Transformer";
    }

    public String getId() {
        return "org.cytoscape.InteractionTransformer";
    }

    public Class<CyNetwork> getContextType() {
        return CyNetwork.class;
    }

    public Class<CyIdentifiable> getElementType() {
        return CyIdentifiable.class;
    }

    public void apply(CyNetwork network, CyIdentifiable element, TransformerSink<CyIdentifiable> sink) {
        if (this.action == Action.ADD) {
            sink.collect((Object)element);
        }
        if (element instanceof CyEdge) {
            CyNode target;
            CyNode source;
            CyEdge edge = (CyEdge)element;
            Filter memoizedFilter = super.getMemoizedFilter();
            if (this.selectSource && memoizedFilter.accepts((Object)network, (Object)(source = edge.getSource()))) {
                sink.collect((Object)source);
            }
            if (this.selectTarget && memoizedFilter.accepts((Object)network, (Object)(target = edge.getTarget()))) {
                sink.collect((Object)target);
            }
        }
    }

    @Override
    public CompositeFilter<CyNetwork, CyIdentifiable> getCompositeFilter() {
        return this.nodeFilter;
    }

    public boolean hasSubfilters() {
        return this.nodeFilter.getLength() > 0;
    }

    public static enum Action {
        ADD,
        REPLACE;

    }
}

