/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.filters.topology;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cytoscape.filter.internal.AbstractMemoizableTransformer;
import org.cytoscape.filter.internal.ApplyCheck;
import org.cytoscape.filter.internal.filters.composite.CompositeFilterImpl;
import org.cytoscape.filter.internal.predicates.NumericPredicateDelegate;
import org.cytoscape.filter.internal.predicates.PredicateDelegates;
import org.cytoscape.filter.model.CompositeFilter;
import org.cytoscape.filter.model.Filter;
import org.cytoscape.filter.predicates.Predicate;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.work.Tunable;

public class TopologyFilter
extends AbstractMemoizableTransformer<CyNetwork, CyIdentifiable>
implements CompositeFilter<CyNetwork, CyIdentifiable>,
ApplyCheck<CyNetwork, CyIdentifiable> {
    private Integer distance;
    private Integer threshold;
    private Predicate predicate;
    private NumericPredicateDelegate delegate;
    private final CompositeFilter<CyNetwork, CyIdentifiable> neighbourFilter = new CompositeFilterImpl<CyNetwork, CyIdentifiable>(CyNetwork.class, CyIdentifiable.class);

    public TopologyFilter() {
        this.neighbourFilter.setType(CompositeFilter.Type.ALL);
        this.neighbourFilter.addListener(() -> this.notifyListeners());
    }

    @Tunable
    public Integer getDistance() {
        return this.distance;
    }

    public void setDistance(Integer distance) {
        this.distance = distance;
        this.notifyListeners();
    }

    @Tunable
    public Integer getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Integer threshold) {
        this.threshold = threshold;
        this.notifyListeners();
    }

    @Tunable
    public Predicate getPredicate() {
        return this.predicate;
    }

    public void setPredicate(Predicate predicate) {
        this.predicate = predicate;
        this.delegate = PredicateDelegates.getNumericDelegate(predicate);
        this.notifyListeners();
    }

    public String getName() {
        return "Topology Filter";
    }

    public String getId() {
        return "org.cytoscape.TopologyFilter";
    }

    public Class<CyNetwork> getContextType() {
        return CyNetwork.class;
    }

    public Class<CyIdentifiable> getElementType() {
        return CyIdentifiable.class;
    }

    @Override
    protected CompositeFilter<CyNetwork, CyIdentifiable> getCompositeFilter() {
        return this.neighbourFilter;
    }

    @Override
    public boolean appliesTo(CyNetwork context, CyIdentifiable element) {
        return element instanceof CyNode;
    }

    public boolean accepts(CyNetwork network, CyIdentifiable element) {
        int count;
        if (!this.appliesTo(network, element) || this.distance == null || this.threshold == null) {
            return false;
        }
        if (this.getCompositeFilter().isAlwaysFalse()) {
            count = 0;
        } else {
            CyNode startNode = (CyNode)element;
            HashSet<Long> counted = new HashSet<Long>();
            HashMap<Long, Integer> sourceToTarget = new HashMap<Long, Integer>();
            HashMap<Long, Integer> targetToSource = new HashMap<Long, Integer>();
            this.traverse(network, startNode, startNode, this.distance, counted, sourceToTarget, targetToSource);
            count = counted.size();
        }
        return this.delegate.accepts(this.threshold, this.threshold, count);
    }

    private void traverse(CyNetwork network, CyNode startNode, CyNode node, int distance, Set<Long> counted, Map<Long, Integer> sourceToTarget, Map<Long, Integer> targetToSource) {
        Filter memoizedFilter = super.getMemoizedFilter();
        if (!node.equals(startNode) && memoizedFilter.accepts((Object)network, (Object)node)) {
            counted.add(node.getSUID());
        }
        if (distance == 0) {
            return;
        }
        for (CyEdge edge : network.getAdjacentEdgeIterable(node, CyEdge.Type.ANY)) {
            if (counted.size() >= this.threshold) {
                return;
            }
            CyNode next = edge.getTarget();
            Map<Long, Integer> map = sourceToTarget;
            if (next == node) {
                next = edge.getSource();
                map = targetToSource;
            }
            if (!this.traverseEdge(edge, distance, map)) continue;
            this.traverse(network, startNode, next, distance - 1, counted, sourceToTarget, targetToSource);
        }
    }

    private boolean traverseEdge(CyEdge edge, int distance, Map<Long, Integer> edgeTraversal) {
        Integer prevDistance = edgeTraversal.get(edge.getSUID());
        if (prevDistance == null || prevDistance < distance) {
            edgeTraversal.put(edge.getSUID(), distance);
            return true;
        }
        return false;
    }

    public void append(Filter<CyNetwork, CyIdentifiable> filter) {
        this.neighbourFilter.append(filter);
    }

    public void insert(int index, Filter<CyNetwork, CyIdentifiable> filter) {
        this.neighbourFilter.insert(index, filter);
    }

    public Filter<CyNetwork, CyIdentifiable> get(int index) {
        return this.neighbourFilter.get(index);
    }

    public Filter<CyNetwork, CyIdentifiable> remove(int index) {
        return this.neighbourFilter.remove(index);
    }

    public int indexOf(Filter<CyNetwork, CyIdentifiable> filter) {
        return this.neighbourFilter.indexOf(filter);
    }

    public int getLength() {
        return this.neighbourFilter.getLength();
    }

    @Tunable
    public CompositeFilter.Type getType() {
        return this.neighbourFilter.getType();
    }

    public void setType(CompositeFilter.Type type) {
        this.neighbourFilter.setType(type);
    }
}

