/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.filters.degree;

import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;

public class DegreeRange {
    private boolean updated = false;
    private final RangeImpl incoming = new RangeImpl();
    private final RangeImpl outgoing = new RangeImpl();
    private final RangeImpl any = new RangeImpl();

    public void update(CyNetwork network, CyEdge edge) {
        this.update(network, edge.getSource());
        this.update(network, edge.getTarget());
        this.updated = true;
    }

    public void update(CyNetwork network) {
        for (CyNode node : network.getNodeList()) {
            this.update(network, node);
        }
        this.updated = true;
    }

    private void update(CyNetwork network, CyNode node) {
        int inDegree = 0;
        int outDegree = 0;
        long nodeSuid = node.getSUID();
        for (CyEdge edge : network.getAdjacentEdgeIterable(node, CyEdge.Type.ANY)) {
            Long targetSuid = edge.getTarget().getSUID();
            if (nodeSuid == targetSuid) {
                ++inDegree;
                continue;
            }
            ++outDegree;
        }
        this.incoming.update(inDegree);
        this.outgoing.update(outDegree);
        this.any.update(inDegree + outDegree);
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public Range getInRange() {
        return this.incoming;
    }

    public Range getOutRange() {
        return this.outgoing;
    }

    public Range getAnyRange() {
        return this.any;
    }

    public Range getRange(CyEdge.Type type) {
        switch (type) {
            case ANY: {
                return this.getAnyRange();
            }
            case INCOMING: {
                return this.getInRange();
            }
            case OUTGOING: {
                return this.getOutRange();
            }
        }
        throw new IllegalArgumentException();
    }

    private static class RangeImpl
    implements Range {
        int low = Integer.MAX_VALUE;
        int high = Integer.MIN_VALUE;

        private RangeImpl() {
        }

        @Override
        public int getLow() {
            return this.low == Integer.MAX_VALUE ? 0 : this.low;
        }

        @Override
        public int getHigh() {
            return this.high == Integer.MIN_VALUE ? 0 : this.high;
        }

        void update(int degree) {
            this.low = Integer.min(this.low, degree);
            this.high = Integer.max(this.high, degree);
        }
    }

    public static interface Range {
        public int getLow();

        public int getHigh();
    }
}

