/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.filters.degree;

import java.util.LinkedList;
import java.util.List;
import org.cytoscape.filter.internal.ApplyCheck;
import org.cytoscape.filter.internal.predicates.NumericPredicateDelegate;
import org.cytoscape.filter.internal.predicates.PredicateDelegates;
import org.cytoscape.filter.model.AbstractValidatableTransformer;
import org.cytoscape.filter.model.Filter;
import org.cytoscape.filter.model.ValidationWarning;
import org.cytoscape.filter.predicates.Predicate;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.work.Tunable;

public class DegreeFilter
extends AbstractValidatableTransformer<CyNetwork, CyIdentifiable>
implements Filter<CyNetwork, CyIdentifiable>,
ApplyCheck<CyNetwork, CyIdentifiable> {
    private NumericPredicateDelegate delegate;
    private Predicate predicate;
    private CyEdge.Type edgeType;
    private Object rawCriterion;
    private Number lowerBound;
    private Number upperBound;

    @Tunable
    public CyEdge.Type getEdgeType() {
        return this.edgeType;
    }

    public void setEdgeType(CyEdge.Type type) {
        this.edgeType = type;
        this.notifyListeners();
    }

    @Tunable
    public Object getCriterion() {
        return this.rawCriterion;
    }

    public void setCriterion(Object criterion) {
        this.rawCriterion = criterion;
        if (criterion == null) {
            this.lowerBound = null;
            this.upperBound = null;
        } else if (criterion instanceof List) {
            List list = (List)criterion;
            this.lowerBound = (Number)list.get(0);
            this.upperBound = (Number)list.get(1);
            this.rawCriterion = new Number[]{this.lowerBound, this.upperBound};
        } else if (criterion instanceof Number[]) {
            Number[] range = (Number[])criterion;
            this.lowerBound = range[0];
            this.upperBound = range[1];
        } else if (criterion instanceof Number) {
            this.upperBound = this.lowerBound = (Number)criterion;
        }
        this.notifyListeners();
    }

    @Tunable
    public Predicate getPredicate() {
        return this.predicate;
    }

    public void setPredicate(Predicate predicate) {
        this.predicate = predicate;
        this.delegate = PredicateDelegates.getNumericDelegate(predicate);
        this.notifyListeners();
    }

    public String getName() {
        return "Degree Filter";
    }

    public String getId() {
        return "org.cytoscape.DegreeFilter";
    }

    @Override
    public boolean appliesTo(CyNetwork context, CyIdentifiable element) {
        return element instanceof CyNode;
    }

    public boolean accepts(CyNetwork context, CyIdentifiable element) {
        if (!this.appliesTo(context, element)) {
            return false;
        }
        if (this.upperBound == null && this.lowerBound == null) {
            return true;
        }
        CyNode node = (CyNode)element;
        int hits = 0;
        for (CyEdge edge : context.getAdjacentEdgeIterable(node, this.edgeType)) {
            ++hits;
        }
        return this.delegate.accepts(this.lowerBound, this.upperBound, hits);
    }

    public Class<CyNetwork> getContextType() {
        return CyNetwork.class;
    }

    public Class<CyIdentifiable> getElementType() {
        return CyIdentifiable.class;
    }

    public List<ValidationWarning> validateCreation() {
        LinkedList<ValidationWarning> output = new LinkedList<ValidationWarning>();
        if (this.edgeType != CyEdge.Type.ANY && this.edgeType != CyEdge.Type.OUTGOING && this.edgeType != CyEdge.Type.INCOMING) {
            output.add(new ValidationWarning("Invalid edge type: " + this.edgeType + ". Must be one of [DIRECTED, OUTGOING, INCOMING]"));
        }
        return output;
    }
}

