/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.filters.column;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.cytoscape.filter.internal.ModelMonitor;
import org.cytoscape.filter.internal.filters.column.ColumnChooser;
import org.cytoscape.filter.internal.filters.column.ColumnElement;
import org.cytoscape.filter.internal.filters.column.ColumnFilter;
import org.cytoscape.filter.internal.filters.column.ColumnFilterController;
import org.cytoscape.filter.internal.filters.column.ColumnFilterView;
import org.cytoscape.filter.internal.range.RangeChooser;
import org.cytoscape.filter.internal.range.RangeChooserController;
import org.cytoscape.filter.internal.range.RangeListener;
import org.cytoscape.filter.internal.view.BooleanComboBox;
import org.cytoscape.filter.internal.view.ComboItem;
import org.cytoscape.filter.internal.view.DocumentListenerAdapter;
import org.cytoscape.filter.internal.view.ViewUtil;
import org.cytoscape.filter.internal.view.look.FilterPanelStyle;
import org.cytoscape.filter.model.Transformer;
import org.cytoscape.filter.predicates.Predicate;
import org.cytoscape.filter.view.InteractivityChangedListener;
import org.cytoscape.filter.view.TransformerViewFactory;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNode;
import org.cytoscape.service.util.CyServiceRegistrar;

public class ColumnFilterViewFactory
implements TransformerViewFactory {
    private final ModelMonitor modelMonitor;
    private final FilterPanelStyle style;
    private final CyServiceRegistrar serviceRegistrar;

    public ColumnFilterViewFactory(FilterPanelStyle style, ModelMonitor modelMonitor, CyServiceRegistrar serviceRegistrar) {
        this.modelMonitor = modelMonitor;
        this.style = style;
        this.serviceRegistrar = serviceRegistrar;
    }

    public String getId() {
        return "org.cytoscape.ColumnFilter";
    }

    public JComponent createView(Transformer<?, ?> transformer) {
        ColumnFilter filter = (ColumnFilter)transformer;
        filter.setCaseSensitive(false);
        Controller controller = new Controller(filter);
        View view = new View(controller, filter);
        this.modelMonitor.registerColumnFilterView(view, controller);
        return view;
    }

    class Controller
    implements ColumnFilterController {
        private final ColumnFilter filter;
        private final RangeChooserController<Integer> intChooserController;
        private final RangeChooserController<Double> doubleChooserController;

        public Controller(final ColumnFilter filter) {
            this.filter = filter;
            this.intChooserController = RangeChooserController.forInteger(ColumnFilterViewFactory.this.style, new RangeListener<Integer>(){

                @Override
                public void rangeChanged(Integer low, Integer high) {
                    Number[] range = new Number[]{low, high};
                    filter.setCriterion(range);
                }
            });
            this.doubleChooserController = RangeChooserController.forDouble(ColumnFilterViewFactory.this.style, new RangeListener<Double>(){

                @Override
                public void rangeChanged(Double low, Double high) {
                    Number[] range = new Number[]{low, high};
                    filter.setCriterion(range);
                }
            });
        }

        @Override
        public ColumnFilter getFilter() {
            return this.filter;
        }

        @Override
        public void columnsChanged(ColumnFilterView view) {
            view.columnsChanged();
        }

        private void updateIntRange(Number[] criterion) {
            String name = this.filter.getColumnName();
            Class<? extends CyIdentifiable> type = this.filter.getTableType();
            if (name == null || type == null) {
                this.intChooserController.reset(0, 0, 0, 0);
                return;
            }
            Number[] range = ColumnFilterViewFactory.this.modelMonitor.getColumnRange(name, type);
            if (range == null) {
                range = new Number[]{0, 0};
            }
            int min = range[0].intValue();
            int max = range[1].intValue();
            int low = criterion == null ? min : criterion[0].intValue();
            int high = criterion == null ? max : criterion[1].intValue();
            this.intChooserController.reset(low, high, min, max);
        }

        private void updateDoubleRange(Number[] criterion) {
            String name = this.filter.getColumnName();
            Class<? extends CyIdentifiable> type = this.filter.getTableType();
            if (name == null || type == null) {
                this.doubleChooserController.reset(0.0, 0.0, 0.0, 0.0);
                return;
            }
            Number[] range = ColumnFilterViewFactory.this.modelMonitor.getColumnRange(name, type);
            if (range == null) {
                range = new Number[]{0, 0};
            }
            double min = range[0].doubleValue();
            double max = range[1].doubleValue();
            double low = criterion == null ? min : criterion[0].doubleValue();
            double high = criterion == null ? max : criterion[1].doubleValue();
            this.doubleChooserController.reset(low, high, min, max);
        }

        @Override
        public void setSliderBounds(int min, int max) {
            int low = this.intChooserController.getLow();
            int high = this.intChooserController.getHigh();
            this.intChooserController.reset(low, high, min, max);
        }

        @Override
        public void setSliderBounds(double min, double max) {
            double low = this.doubleChooserController.getLow();
            double high = this.doubleChooserController.getHigh();
            this.doubleChooserController.reset(low, high, min, max);
        }
    }

    class View
    extends JPanel
    implements ColumnFilterView,
    InteractivityChangedListener {
        private final Controller controller;
        private final ColumnFilter filter;
        private boolean isInteractive;
        private JTextField textField;
        private JComboBox<ComboItem<Predicate>> predicateComboBox;
        private ColumnChooser columnChooser;
        private JPanel spacerPanel;
        private RangeChooser<Integer> intRangeChooser;
        private RangeChooser<Double> doubleRangeChooser;
        private BooleanComboBox numericNegateComboBox;
        private BooleanComboBox booleanComboBox;
        private BooleanComboBox anyMatchComboBox;
        private JLabel booleanLabel;
        private JPanel booleanPanel;
        private DocumentListenerAdapter textFieldDocumentListener;
        private ActionListener predicateComboBoxActionListener;
        private ActionListener nameComboBoxActionListener;
        private BooleanComboBox.StateChangeListener numericNegateComboBoxStateChangeListener;
        private BooleanComboBox.StateChangeListener booleanComboBoxStateChangeListener;
        private BooleanComboBox.StateChangeListener anyMatchComboBoxStateChangeListener;

        public View(Controller controller, ColumnFilter filter) {
            this.controller = controller;
            this.filter = filter;
            ViewUtil.configureFilterView(this);
            this.textField = ColumnFilterViewFactory.this.style.createTextField();
            this.predicateComboBox = ColumnFilterViewFactory.this.style.createCombo();
            this.predicateComboBox.addItem(new ComboItem<Predicate>(Predicate.CONTAINS, "contains"));
            this.predicateComboBox.addItem(new ComboItem<Predicate>(Predicate.DOES_NOT_CONTAIN, "doesn't contain"));
            this.predicateComboBox.addItem(new ComboItem<Predicate>(Predicate.IS, "is"));
            this.predicateComboBox.addItem(new ComboItem<Predicate>(Predicate.IS_NOT, "is not"));
            this.predicateComboBox.addItem(new ComboItem<Predicate>(Predicate.REGEX, "matches regex"));
            this.columnChooser = new ColumnChooser(ColumnFilterViewFactory.this.style, ColumnFilterViewFactory.this.serviceRegistrar);
            this.numericNegateComboBox = new BooleanComboBox(ColumnFilterViewFactory.this.style, "is", "is not");
            this.booleanComboBox = new BooleanComboBox(ColumnFilterViewFactory.this.style, "true", "false");
            this.anyMatchComboBox = new BooleanComboBox(ColumnFilterViewFactory.this.style, "any element", "every element");
            this.booleanLabel = ColumnFilterViewFactory.this.style.createLabel("is");
            this.booleanPanel = new JPanel();
            this.booleanPanel.setOpaque(false);
            this.booleanPanel.setLayout(new GridBagLayout());
            this.booleanPanel.add((Component)this.booleanLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.booleanPanel.add((Component)this.booleanComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 512, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.spacerPanel = new JPanel();
            this.spacerPanel.setOpaque(false);
            this.intRangeChooser = controller.intChooserController.getRangeChooser();
            this.doubleRangeChooser = controller.doubleChooserController.getRangeChooser();
            this.setLayout(new GridBagLayout());
            this.refreshUI(false, true);
        }

        @Override
        public void columnsChanged() {
            this.refreshUI(true, true);
        }

        private void refreshUI(boolean updateColumnModel, boolean selectColumn) {
            this.removeListeners();
            if (updateColumnModel) {
                this.columnChooser.updateComboBox();
            }
            if (selectColumn) {
                String name = this.filter.getColumnName();
                Class<? extends CyIdentifiable> type = this.filter.getTableType();
                this.columnChooser.select(0, item -> item.getName().equals(name) && item.getTableType().equals(type));
            }
            ColumnElement column = this.columnChooser.getSelectedItem();
            Object criterion = this.filter.getCriterion();
            ColumnElement.SelectedColumnType colType = column.getColType();
            switch (colType) {
                case STRING: {
                    this.textField.setText((String)criterion);
                    this.predicateComboBox.setSelectedItem(new ComboItem<Predicate>(this.filter.getPredicate()));
                    if (column.isList()) {
                        this.anyMatchComboBox.setState(this.filter.getAnyMatch());
                        this.handleStringListColumnSelected();
                        break;
                    }
                    this.handleStringColumnSelected();
                    break;
                }
                case INTEGER: {
                    this.refreshRangeUI(true, (Number[])criterion, column, this.controller.intChooserController);
                    break;
                }
                case DOUBLE: {
                    this.refreshRangeUI(false, (Number[])criterion, column, this.controller.doubleChooserController);
                    break;
                }
                case BOOLEAN: {
                    this.booleanComboBox.setState((Boolean)criterion);
                    this.handleBooleanColumnSelected();
                    break;
                }
                case NONE: {
                    this.handleNoColumnSelected();
                }
            }
            this.addListeners();
        }

        private void refreshRangeUI(boolean isInt, Number[] criterion, ColumnElement column, RangeChooserController<? extends Number> rcc) {
            ColumnFilterViewFactory.this.modelMonitor.recomputeColumnRange(column.getName(), column.getTableType());
            if (isInt) {
                this.controller.updateIntRange(criterion);
            } else {
                this.controller.updateDoubleRange(criterion);
            }
            if (criterion == null) {
                Number[] range = new Number[]{rcc.getLow(), rcc.getHigh()};
                this.filter.setCriterion(range);
            }
            this.numericNegateComboBox.setState(this.filter.getPredicate() != Predicate.IS_NOT_BETWEEN);
            if (column.isList()) {
                this.anyMatchComboBox.setState(this.filter.getAnyMatch());
                this.handleNumericListColumnSelected(isInt);
            } else {
                this.handleNumericColumnSelected(isInt);
            }
        }

        private void handleColumnSelected() {
            ColumnElement selected = this.columnChooser.getSelectedItem();
            if (selected == null) {
                this.filter.setPredicateAndCriterion(null, null);
                this.handleNoColumnSelected();
                this.controller.intChooserController.setInteractive(false);
                this.controller.doubleChooserController.setInteractive(false);
                return;
            }
            this.filter.setCaseSensitive(false);
            this.filter.setColumnName(selected.getName());
            this.setFilterDefaults(selected.getColType());
            Class<?> type = selected.getTableType();
            if (type == null) {
                this.filter.type.setSelectedValue((Object)"nodes+edges");
            } else if (CyNode.class.equals(type)) {
                this.filter.type.setSelectedValue((Object)"nodes");
            } else if (CyEdge.class.equals(type)) {
                this.filter.type.setSelectedValue((Object)"edges");
            }
            this.refreshUI(false, false);
        }

        private void setFilterDefaults(ColumnElement.SelectedColumnType type) {
            if (type == null) {
                this.filter.setPredicateAndCriterion(null, null);
                return;
            }
            switch (type) {
                case BOOLEAN: {
                    this.filter.setPredicateAndCriterion(Predicate.IS, true);
                    break;
                }
                case INTEGER: 
                case DOUBLE: {
                    this.filter.setPredicateAndCriterion(Predicate.BETWEEN, null);
                    break;
                }
                case STRING: {
                    this.filter.setPredicateAndCriterion(Predicate.CONTAINS, "");
                    break;
                }
                case NONE: {
                    this.filter.setPredicateAndCriterion(null, null);
                }
            }
        }

        private void addListeners() {
            this.textFieldDocumentListener = event -> this.filter.setCriterion(this.textField.getText());
            this.textField.getDocument().addDocumentListener(this.textFieldDocumentListener);
            this.predicateComboBoxActionListener = event -> {
                ComboItem<Predicate> selected = this.predicateComboBox.getItemAt(this.predicateComboBox.getSelectedIndex());
                this.filter.setPredicate(selected.getValue());
            };
            this.predicateComboBox.addActionListener(this.predicateComboBoxActionListener);
            this.nameComboBoxActionListener = event -> this.handleColumnSelected();
            this.columnChooser.addActionListener(this.nameComboBoxActionListener);
            this.numericNegateComboBoxStateChangeListener = is -> this.filter.setPredicate(is ? Predicate.BETWEEN : Predicate.IS_NOT_BETWEEN);
            this.numericNegateComboBox.addStateChangeListener(this.numericNegateComboBoxStateChangeListener);
            this.booleanComboBoxStateChangeListener = isTrue -> this.filter.setCriterion(isTrue);
            this.booleanComboBox.addStateChangeListener(this.booleanComboBoxStateChangeListener);
            this.anyMatchComboBoxStateChangeListener = isTrue -> this.filter.setAnyMatch(isTrue);
            this.anyMatchComboBox.addStateChangeListener(this.anyMatchComboBoxStateChangeListener);
        }

        private void removeListeners() {
            this.textField.getDocument().removeDocumentListener(this.textFieldDocumentListener);
            this.predicateComboBox.removeActionListener(this.predicateComboBoxActionListener);
            this.columnChooser.removeActionListener(this.nameComboBoxActionListener);
            this.numericNegateComboBox.removeStateChangeListener(this.numericNegateComboBoxStateChangeListener);
            this.booleanComboBox.removeStateChangeListener(this.booleanComboBoxStateChangeListener);
            this.anyMatchComboBox.removeStateChangeListener(this.anyMatchComboBoxStateChangeListener);
        }

        void handleNumericColumnSelected(boolean isInt) {
            RangeChooser<Number> rangeChooser = isInt ? this.intRangeChooser : this.doubleRangeChooser;
            RangeChooserController<Number> chooserController = isInt ? this.controller.intChooserController : this.controller.doubleChooserController;
            this.removeAll();
            this.add((Component)this.columnChooser, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 512, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.numericNegateComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 512, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add(rangeChooser, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 512, 2, new Insets(0, 0, 3, 3), 0, 0));
            chooserController.setInteractive(this.isInteractive);
            this.revalidate();
            this.validate();
            this.repaint();
        }

        void handleNumericListColumnSelected(boolean isInt) {
            RangeChooser<Number> rangeChooser = isInt ? this.intRangeChooser : this.doubleRangeChooser;
            RangeChooserController<Number> chooserController = isInt ? this.controller.intChooserController : this.controller.doubleChooserController;
            this.removeAll();
            JPanel predicatePanel = new JPanel();
            predicatePanel.setOpaque(false);
            predicatePanel.setLayout(new GridBagLayout());
            predicatePanel.add((Component)this.anyMatchComboBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 512, 0, new Insets(0, 0, 0, 0), 0, 0));
            predicatePanel.add((Component)this.numericNegateComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 512, 0, new Insets(0, 0, 0, 0), 0, 0));
            predicatePanel.add((Component)this.spacerPanel, new GridBagConstraints(2, 0, 1, 1, Double.MIN_VALUE, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.columnChooser, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 512, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)predicatePanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add(rangeChooser, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 512, 2, new Insets(0, 0, 3, 3), 0, 0));
            chooserController.setInteractive(this.isInteractive);
            this.revalidate();
            this.validate();
            this.repaint();
        }

        void handleStringColumnSelected() {
            this.removeAll();
            JPanel predicatePanel = new JPanel();
            predicatePanel.setOpaque(false);
            predicatePanel.setLayout(new GridBagLayout());
            predicatePanel.add((Component)this.columnChooser, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 512, 0, new Insets(0, 0, 0, 0), 0, 0));
            predicatePanel.add(this.predicateComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 512, 0, new Insets(0, 0, 0, 0), 0, 0));
            predicatePanel.add((Component)this.spacerPanel, new GridBagConstraints(2, 0, 1, 1, Double.MIN_VALUE, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)predicatePanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.textField, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 512, 2, new Insets(0, 0, 0, 0), 0, 0));
            predicatePanel.invalidate();
            this.validate();
        }

        void handleStringListColumnSelected() {
            this.removeAll();
            JPanel predicatePanel = new JPanel();
            predicatePanel.setOpaque(false);
            predicatePanel.setLayout(new GridBagLayout());
            predicatePanel.add((Component)this.anyMatchComboBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 512, 0, new Insets(0, 0, 0, 0), 0, 0));
            predicatePanel.add(this.predicateComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 512, 0, new Insets(0, 0, 0, 0), 0, 0));
            predicatePanel.add((Component)this.spacerPanel, new GridBagConstraints(2, 0, 1, 1, Double.MIN_VALUE, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.columnChooser, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 512, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)predicatePanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.textField, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 512, 2, new Insets(0, 0, 0, 0), 0, 0));
            predicatePanel.invalidate();
            this.validate();
        }

        void handleBooleanColumnSelected() {
            this.removeAll();
            this.add((Component)this.columnChooser, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 512, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.spacerPanel, new GridBagConstraints(1, 0, 1, 1, Double.MIN_VALUE, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.booleanPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 512, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.invalidate();
            this.validate();
        }

        private void handleNoColumnSelected() {
            this.removeAll();
            this.add((Component)this.columnChooser, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 512, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.spacerPanel, new GridBagConstraints(1, 0, 1, 1, Double.MIN_VALUE, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.invalidate();
            this.validate();
        }

        public void handleInteractivityChanged(boolean isInteractive) {
            this.isInteractive = isInteractive;
            this.controller.intChooserController.setInteractive(isInteractive);
            this.controller.doubleChooserController.setInteractive(isInteractive);
        }
    }
}

