/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.filters.column;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.cytoscape.filter.internal.ApplyCheck;
import org.cytoscape.filter.internal.predicates.NumericPredicateDelegate;
import org.cytoscape.filter.internal.predicates.PredicateDelegates;
import org.cytoscape.filter.internal.predicates.StringPredicateDelegate;
import org.cytoscape.filter.model.AbstractTransformer;
import org.cytoscape.filter.model.Filter;
import org.cytoscape.filter.model.ValidatableTransformer;
import org.cytoscape.filter.model.ValidationWarning;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.util.ListChangeListener;
import org.cytoscape.work.util.ListSelection;
import org.cytoscape.work.util.ListSingleSelection;

public class ColumnFilter
extends AbstractTransformer<CyNetwork, CyIdentifiable>
implements Filter<CyNetwork, CyIdentifiable>,
ValidatableTransformer<CyNetwork, CyIdentifiable>,
ApplyCheck<CyNetwork, CyIdentifiable> {
    public static final String NODES = "nodes";
    public static final String EDGES = "edges";
    public static final String NODES_AND_EDGES = "nodes+edges";
    @Tunable
    public final ListSingleSelection<String> type = new ListSingleSelection((Object[])new String[]{"nodes", "edges", "nodes+edges"});
    private org.cytoscape.filter.predicates.Predicate predicate;
    private NumericPredicateDelegate numericDelegate;
    private StringPredicateDelegate stringDelegate;
    private boolean caseSensitive;
    private boolean anyMatch = true;
    private String columnName;
    private Object rawCriterion;
    private Number lowerBound;
    private Number upperBound;
    private String stringCriterion;
    private String lowerCaseCriterion;
    private Boolean booleanCriterion;

    public ColumnFilter(String columnName, org.cytoscape.filter.predicates.Predicate predicate, Object criterion) {
        this();
        this.columnName = columnName;
        this.setPredicateImpl(predicate);
        this.setCriterionImpl(criterion);
    }

    public ColumnFilter() {
        this.type.addListener((ListChangeListener)new ListChangeListener<String>(){

            public void selectionChanged(ListSelection<String> source) {
                ColumnFilter.this.notifyListeners();
            }

            public void listChanged(ListSelection<String> source) {
            }
        });
    }

    @Tunable
    public boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        this.notifyListeners();
    }

    @Tunable
    public boolean getAnyMatch() {
        return this.anyMatch;
    }

    public void setAnyMatch(boolean anyMatch) {
        this.anyMatch = anyMatch;
        this.notifyListeners();
    }

    @Tunable
    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String name) {
        this.columnName = name;
        this.notifyListeners();
    }

    @Tunable
    public Object getCriterion() {
        return this.rawCriterion;
    }

    public void setCriterion(Object criterion) {
        try {
            this.setCriterionImpl(criterion);
        }
        finally {
            this.notifyListeners();
        }
    }

    private void setCriterionImpl(Object criterion) {
        this.rawCriterion = null;
        this.lowerBound = null;
        this.upperBound = null;
        this.stringCriterion = null;
        this.lowerCaseCriterion = null;
        if (ColumnFilter.isListOfNumber(criterion)) {
            List list = (List)criterion;
            this.lowerBound = (Number)list.get(0);
            this.upperBound = (Number)list.get(1);
            this.rawCriterion = new Number[]{this.lowerBound, this.upperBound};
        } else if (criterion instanceof Number[]) {
            Number[] range = (Number[])criterion;
            this.lowerBound = range[0];
            this.upperBound = range[1];
            this.rawCriterion = criterion;
        } else if (criterion instanceof Number) {
            this.upperBound = this.lowerBound = (Number)criterion;
            this.rawCriterion = criterion;
        } else if (criterion instanceof String) {
            this.stringCriterion = criterion.toString();
            this.lowerCaseCriterion = this.stringCriterion.toLowerCase();
            this.rawCriterion = criterion;
        } else if (criterion instanceof Boolean) {
            this.booleanCriterion = (Boolean)criterion;
            this.rawCriterion = criterion;
        }
    }

    private static boolean isListOfNumber(Object criterion) {
        if (criterion instanceof List) {
            List list = (List)criterion;
            return list.size() >= 2 && list.get(0) instanceof Number && list.get(1) instanceof Number;
        }
        return false;
    }

    @Tunable
    public org.cytoscape.filter.predicates.Predicate getPredicate() {
        return this.predicate;
    }

    public void setPredicate(org.cytoscape.filter.predicates.Predicate predicate) {
        this.setPredicateImpl(predicate);
        this.notifyListeners();
    }

    private void setPredicateImpl(org.cytoscape.filter.predicates.Predicate predicate) {
        this.predicate = predicate;
        this.numericDelegate = PredicateDelegates.getNumericDelegate(predicate);
        this.stringDelegate = PredicateDelegates.getStringDelegate(predicate);
    }

    public void setPredicateAndCriterion(org.cytoscape.filter.predicates.Predicate predicate, Object criterion) {
        try {
            this.setPredicateImpl(predicate);
            this.setCriterionImpl(criterion);
        }
        finally {
            this.notifyListeners();
        }
    }

    public Class<? extends CyIdentifiable> getTableType() {
        String typeString = (String)this.type.getSelectedValue();
        if (NODES.equals(typeString)) {
            return CyNode.class;
        }
        if (EDGES.equals(typeString)) {
            return CyEdge.class;
        }
        return null;
    }

    public Class<CyNetwork> getContextType() {
        return CyNetwork.class;
    }

    public Class<CyIdentifiable> getElementType() {
        return CyIdentifiable.class;
    }

    public String getId() {
        return "org.cytoscape.ColumnFilter";
    }

    public String getName() {
        return "Column Filter";
    }

    public List<ValidationWarning> validate(CyNetwork context) {
        CyColumn column;
        String tableType;
        CyTable table;
        if (context == null) {
            return Collections.emptyList();
        }
        Class<? extends CyIdentifiable> type = this.getTableType();
        if (CyNode.class.equals(type)) {
            table = context.getDefaultNodeTable();
            tableType = "Node";
        } else if (CyEdge.class.equals(type)) {
            table = context.getDefaultEdgeTable();
            tableType = "Edge";
        } else {
            return Collections.emptyList();
        }
        if (this.columnName != null && (column = table.getColumn(this.columnName)) == null) {
            return ValidationWarning.warn((String[])new String[]{tableType + " table does not have column <b>\"" + this.columnName + "\"</b>"});
        }
        if (this.rawCriterion == null || this.predicate == null) {
            return Collections.emptyList();
        }
        column = table.getColumn(this.columnName);
        Class columnType = column.getType();
        if (columnType.equals(List.class)) {
            columnType = column.getListElementType();
        }
        if (String.class.equals((Object)columnType) && this.stringCriterion == null) {
            return ValidationWarning.warn((String[])new String[]{"Column <b>\"" + this.columnName + "\"</b> in " + tableType + " table is not a String column"});
        }
        if (Number.class.isAssignableFrom(columnType) && (this.lowerBound == null || this.upperBound == null)) {
            return ValidationWarning.warn((String[])new String[]{"Column <b>\"" + this.columnName + "\"</b> in " + tableType + " table is not a Numeric column"});
        }
        if (Boolean.class.equals((Object)columnType) && this.booleanCriterion == null) {
            return ValidationWarning.warn((String[])new String[]{"Column <b>\"" + this.columnName + "\"</b> in " + tableType + " table is not a Boolean column"});
        }
        return Collections.emptyList();
    }

    public List<ValidationWarning> validateCreation() {
        if (this.columnName == null) {
            return ValidationWarning.warn((String[])new String[]{"'columnName' is not set"});
        }
        if (this.predicate == null) {
            return ValidationWarning.warn((String[])new String[]{"'predicate' is not set"});
        }
        if (this.getCriterion() == null) {
            return ValidationWarning.warn((String[])new String[]{"'criterion' is not set. Must be a boolean, string or two element array of numbers."});
        }
        if (this.predicate == org.cytoscape.filter.predicates.Predicate.IS || this.predicate == org.cytoscape.filter.predicates.Predicate.IS_NOT) {
            if (this.stringCriterion == null && this.booleanCriterion == null) {
                return ValidationWarning.warn((String[])new String[]{"predicate IS or IS_NOT requires a string or boolean criterion"});
            }
        } else {
            if (!this.stringDelegate.unsupported() && this.stringCriterion == null) {
                return ValidationWarning.warn((String[])new String[]{"string predicate requires string criterion"});
            }
            if (!(this.numericDelegate.unsupported() || this.lowerBound != null && this.upperBound != null)) {
                return ValidationWarning.warn((String[])new String[]{"numeric predicate requires lower and upper bound, eg [1,2]"});
            }
        }
        return Collections.emptyList();
    }

    public boolean isAlwaysFalse() {
        return this.columnName == null || this.rawCriterion == null || this.predicate == null;
    }

    @Override
    public boolean appliesTo(CyNetwork context, CyIdentifiable element) {
        Class<? extends CyIdentifiable> tableType = this.getTableType();
        if (tableType == null) {
            return true;
        }
        return tableType.isAssignableFrom(element.getClass());
    }

    public boolean accepts(CyNetwork context, CyIdentifiable element) {
        if (this.columnName == null || this.rawCriterion == null || this.predicate == null) {
            return false;
        }
        Class<? extends CyIdentifiable> tableType = this.getTableType();
        if (tableType != null && !tableType.isAssignableFrom(element.getClass())) {
            return false;
        }
        CyRow row = context.getRow(element);
        CyTable table = row.getTable();
        CyColumn column = table.getColumn(this.columnName);
        if (column == null) {
            return false;
        }
        Class columnType = column.getType();
        if (columnType.equals(List.class)) {
            List list;
            Class listElementType = column.getListElementType();
            if (String.class.equals((Object)listElementType)) {
                List list2 = row.getList(this.columnName, String.class);
                return ColumnFilter.listMatch(this.anyMatch, list2, item -> this.stringDelegate.accepts(this.stringCriterion, this.lowerCaseCriterion, (String)item, this.caseSensitive));
            }
            if (Number.class.isAssignableFrom(listElementType)) {
                List list3 = row.getList(this.columnName, listElementType);
                return ColumnFilter.listMatch(this.anyMatch, list3, number -> this.numericDelegate.accepts(this.lowerBound, this.upperBound, (Number)number));
            }
            if (Boolean.class.equals((Object)listElementType) && (list = row.getList(this.columnName, listElementType)) != null) {
                for (Boolean value : list) {
                    if (value == null || !this.booleanCriterion.equals(value)) continue;
                    return true;
                }
            }
        } else {
            if (columnType.equals(String.class)) {
                String value = (String)row.get(this.columnName, String.class);
                return this.stringDelegate.accepts(this.stringCriterion, this.lowerCaseCriterion, value, this.caseSensitive);
            }
            if (Number.class.isAssignableFrom(columnType)) {
                Number value = (Number)row.get(this.columnName, columnType);
                return this.numericDelegate.accepts(this.lowerBound, this.upperBound, value);
            }
            if (Boolean.class.equals((Object)columnType)) {
                Boolean value = (Boolean)row.get(this.columnName, Boolean.class);
                return this.booleanCriterion.equals(value);
            }
        }
        return false;
    }

    private static <T> boolean listMatch(boolean anyMatch, List<T> list, Predicate<T> predicate) {
        if (list == null) {
            return false;
        }
        return anyMatch ? ColumnFilter.anyMatch(list, predicate) : ColumnFilter.allMatch(list, predicate);
    }

    private static <T> boolean anyMatch(List<T> list, Predicate<T> predicate) {
        for (T t : list) {
            if (!predicate.test(t)) continue;
            return true;
        }
        return false;
    }

    private static <T> boolean allMatch(List<T> list, Predicate<T> predicate) {
        for (T t : list) {
            if (predicate.test(t)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        Class<? extends CyIdentifiable> tableType = this.getTableType();
        return "ColumnFilter [type=" + (this.type == null ? null : (String)this.type.getSelectedValue()) + ", elementType=" + (tableType == null ? null : tableType.getSimpleName()) + ", predicate=" + this.predicate + ", caseSensitive=" + this.caseSensitive + ", columnName=" + this.columnName + ", rawCriterion=" + this.rawCriterion + ", lowerBound=" + this.lowerBound + ", upperBound=" + this.upperBound + ", stringCriterion=" + this.stringCriterion + ", lowerCaseCriterion=" + this.lowerCaseCriterion + ", booleanCriterion=" + this.booleanCriterion + "]";
    }
}

