/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal.filters.column;

import java.util.List;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNode;

public class ColumnElement
implements Comparable<ColumnElement> {
    private final Class<?> tableType;
    private final SelectedColumnType colType;
    private final String name;
    private final boolean list;
    private final boolean placeholder;

    public ColumnElement(Class<?> tableType, CyColumn col) {
        this.tableType = tableType;
        this.colType = SelectedColumnType.fromColumn(col);
        this.list = SelectedColumnType.isList(col);
        this.name = col.getName();
        this.placeholder = false;
    }

    public ColumnElement() {
        this.tableType = null;
        this.colType = SelectedColumnType.NONE;
        this.name = "Choose column...";
        this.list = false;
        this.placeholder = true;
    }

    public boolean isPlaceholder() {
        return this.placeholder;
    }

    public Class<?> getTableType() {
        return this.tableType;
    }

    public SelectedColumnType getColType() {
        return this.colType;
    }

    public boolean isList() {
        return this.list;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(ColumnElement other) {
        if (this.tableType == null && other.tableType == null) {
            return String.CASE_INSENSITIVE_ORDER.compare(this.name, other.name);
        }
        if (this.tableType == null) {
            return -1;
        }
        if (other.tableType == null) {
            return 1;
        }
        if (this.tableType.equals(other.tableType)) {
            return String.CASE_INSENSITIVE_ORDER.compare(this.name, other.name);
        }
        if (this.tableType.equals(CyNode.class)) {
            return -1;
        }
        return 1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.colType == null ? 0 : this.colType.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.tableType == null ? 0 : this.tableType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnElement other = (ColumnElement)obj;
        if (this.colType != other.colType) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.tableType == null ? other.tableType != null : !this.tableType.equals(other.tableType));
    }

    public static enum SelectedColumnType {
        NONE,
        INTEGER,
        DOUBLE,
        STRING,
        BOOLEAN;


        private static SelectedColumnType fromColumn(CyColumn col) {
            Class colType = col.getType();
            if (colType.isAssignableFrom(List.class)) {
                colType = col.getListElementType();
            }
            if (colType == Integer.class || colType == Long.class) {
                return INTEGER;
            }
            if (colType == Double.class) {
                return DOUBLE;
            }
            if (colType == Boolean.class) {
                return BOOLEAN;
            }
            if (colType == String.class) {
                return STRING;
            }
            return NONE;
        }

        private static boolean isList(CyColumn col) {
            Class colType = col.getType();
            return colType.isAssignableFrom(List.class);
        }
    }
}

