/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import org.cytoscape.application.events.SetCurrentNetworkEvent;
import org.cytoscape.application.events.SetCurrentNetworkListener;
import org.cytoscape.filter.internal.filters.column.ColumnElement;
import org.cytoscape.filter.internal.filters.column.ColumnFilter;
import org.cytoscape.filter.internal.filters.column.ColumnFilterController;
import org.cytoscape.filter.internal.filters.column.ColumnFilterView;
import org.cytoscape.filter.internal.filters.degree.DegreeFilterController;
import org.cytoscape.filter.internal.filters.degree.DegreeFilterView;
import org.cytoscape.filter.internal.filters.degree.DegreeRange;
import org.cytoscape.filter.view.InteractivityChangedListener;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.events.AboutToRemoveEdgesEvent;
import org.cytoscape.model.events.AboutToRemoveEdgesListener;
import org.cytoscape.model.events.AddedEdgesEvent;
import org.cytoscape.model.events.AddedEdgesListener;
import org.cytoscape.model.events.ColumnCreatedEvent;
import org.cytoscape.model.events.ColumnCreatedListener;
import org.cytoscape.model.events.ColumnDeletedEvent;
import org.cytoscape.model.events.ColumnDeletedListener;
import org.cytoscape.model.events.ColumnNameChangedEvent;
import org.cytoscape.model.events.ColumnNameChangedListener;
import org.cytoscape.model.events.RowSetRecord;
import org.cytoscape.model.events.RowsSetEvent;
import org.cytoscape.model.events.RowsSetListener;

public class ModelMonitor
implements SetCurrentNetworkListener,
RowsSetListener,
ColumnCreatedListener,
ColumnDeletedListener,
ColumnNameChangedListener,
AddedEdgesListener,
AboutToRemoveEdgesListener {
    private static final int INTERACTIVITY_THRESHOLD = 100000;
    CyNetwork network;
    DegreeRange nodeDegreeRange;
    boolean enabled;
    Map<String, double[]> nodeColumnRanges;
    Map<String, double[]> edgeColumnRanges;
    List<ColumnElement> columnNames;
    private final Object lock = new Object();
    private ColumnElement defaultColumnName;
    private Map<DegreeFilterView, DegreeFilterController> degreeViews;
    private Map<ColumnFilterView, ColumnFilterController> columnViews;
    private List<InteractivityChangedListener> interactivityChangedListeners;
    private Map<CyNetwork, Boolean> interactivityState;

    public ModelMonitor() {
        this.nodeDegreeRange = new DegreeRange();
        this.nodeColumnRanges = new HashMap<String, double[]>();
        this.edgeColumnRanges = new HashMap<String, double[]>();
        this.columnNames = new ArrayList<ColumnElement>();
        this.defaultColumnName = new ColumnElement();
        this.columnNames.add(this.defaultColumnName);
        this.interactivityChangedListeners = new CopyOnWriteArrayList<InteractivityChangedListener>();
        this.interactivityState = new WeakHashMap<CyNetwork, Boolean>();
        this.degreeViews = new WeakHashMap<DegreeFilterView, DegreeFilterController>();
        this.columnViews = new WeakHashMap<ColumnFilterView, ColumnFilterController>();
        this.enabled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(RowsSetEvent event) {
        CyTable table = (CyTable)event.getSource();
        Object object = this.lock;
        synchronized (object) {
            Map<String, double[]> ranges;
            if (!this.enabled) {
                return;
            }
            if (this.network == null || table != this.network.getDefaultNodeTable() && table != this.network.getDefaultEdgeTable()) {
                return;
            }
            if (table == this.network.getDefaultNodeTable()) {
                ranges = this.nodeColumnRanges;
            } else if (table == this.network.getDefaultEdgeTable()) {
                ranges = this.edgeColumnRanges;
            } else {
                return;
            }
            boolean changed = false;
            for (RowSetRecord record : event.getPayloadCollection()) {
                Object value;
                String name = record.getColumn();
                double[] range = ranges.get(name);
                if (range == null || (value = record.getValue()) == null) continue;
                CyColumn column = table.getColumn(name);
                Class type = column.getType();
                if (List.class.equals((Object)type) && Number.class.isAssignableFrom(column.getListElementType())) {
                    this.updateRange(range, (List)value);
                } else if (Number.class.isAssignableFrom(type)) {
                    this.updateRange(range, (Number)value);
                }
                changed = true;
            }
            if (changed) {
                this.updateColumnSliders();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(SetCurrentNetworkEvent event) {
        CyNetwork model = event.getNetwork();
        Object object = this.lock;
        synchronized (object) {
            int totalObjects;
            if (model == this.network) {
                return;
            }
            if (model == null) {
                this.network = null;
                return;
            }
            if (model == this.network) {
                return;
            }
            this.network = model;
            boolean isInteractive = this.interactivityState.containsKey(this.network) ? this.interactivityState.get(this.network) : (totalObjects = this.network.getNodeCount() + this.network.getEdgeCount()) < 100000;
            this.setInteractive(isInteractive);
            this.notifyInteractivityListeners(isInteractive);
        }
    }

    public void setInteractive(boolean isInteractive) {
        this.interactivityState.put(this.network, isInteractive);
        this.clearNumericData();
        this.updateColumnNames(this.network);
        if (isInteractive) {
            this.computeNodeDegreeRange();
            this.updateDegreeSliders();
            this.updateColumnSliders();
        }
    }

    private void notifyInteractivityListeners(boolean isInteractive) {
        for (InteractivityChangedListener listener : this.interactivityChangedListeners) {
            listener.handleInteractivityChanged(isInteractive);
        }
    }

    private boolean updateRange(double[] range, Number value) {
        if (value == null) {
            return false;
        }
        double number = value.doubleValue();
        if (!Double.isFinite(number)) {
            return false;
        }
        range[0] = Math.min(range[0], number);
        range[1] = Math.max(range[1], number);
        return true;
    }

    private boolean updateRange(double[] range, List<?> list) {
        if (list == null) {
            return false;
        }
        boolean changed = false;
        for (Object value : list) {
            double number;
            if (value == null || !Double.isFinite(number = ((Number)value).doubleValue())) continue;
            range[0] = Math.min(range[0], number);
            range[1] = Math.max(range[1], number);
            changed = true;
        }
        return changed;
    }

    private void updateColumnSliders() {
        if (this.network == null) {
            return;
        }
        for (ColumnFilterController controller : this.columnViews.values()) {
            CyColumn column;
            Number[] range;
            CyTable table;
            ColumnFilter filter = controller.getFilter();
            Class<? extends CyIdentifiable> columnType = filter.getTableType();
            String name = filter.getColumnName();
            if (name == null) continue;
            if (CyNode.class.equals(columnType)) {
                table = this.network.getDefaultNodeTable();
                range = this.getColumnRange(table, name, this.nodeColumnRanges);
            } else {
                if (!CyEdge.class.equals(columnType)) continue;
                table = this.network.getDefaultEdgeTable();
                range = this.getColumnRange(table, name, this.edgeColumnRanges);
            }
            if ((column = table.getColumn(name)) == null) continue;
            Class type = column.getType();
            if (List.class.equals((Object)type)) {
                type = column.getListElementType();
            }
            if (Integer.class.equals((Object)type) || Long.class.equals((Object)type)) {
                controller.setSliderBounds(range[0].longValue(), range[1].longValue());
                continue;
            }
            controller.setSliderBounds(range[0].doubleValue(), range[1].doubleValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(AddedEdgesEvent event) {
        if (this.network != event.getSource()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            for (CyEdge edge : event.getPayloadCollection()) {
                this.nodeDegreeRange.update(this.network, edge);
            }
            this.updateDegreeSliders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(AboutToRemoveEdgesEvent event) {
        if (this.network != event.getSource()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.clearDegreeData();
            this.computeNodeDegreeRange();
            this.updateDegreeSliders();
        }
    }

    private void updateDegreeSliders() {
        for (DegreeFilterController controller : this.degreeViews.values()) {
            controller.setDegreeBounds(this.nodeDegreeRange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateColumnNames(CyNetwork network) {
        Object object = this.lock;
        synchronized (object) {
            this.columnNames.clear();
            this.columnNames.add(this.defaultColumnName);
            if (network != null) {
                this.addFilterElements(network.getDefaultNodeTable(), CyNode.class);
                this.addFilterElements(network.getDefaultEdgeTable(), CyEdge.class);
                Collections.sort(this.columnNames);
                this.updateColumnViews();
            }
        }
    }

    public boolean isCurrent(ColumnElement column) {
        return this.columnNames.contains(column);
    }

    private void updateColumnViews() {
        for (Map.Entry<ColumnFilterView, ColumnFilterController> entry : this.columnViews.entrySet()) {
            ColumnFilterController controller = entry.getValue();
            controller.columnsChanged(entry.getKey());
        }
    }

    private void addFilterElements(CyTable table, Class<? extends CyIdentifiable> type) {
        if (table == null) {
            return;
        }
        for (CyColumn column : table.getColumns()) {
            Class elementType = column.getType();
            Class listElementType = column.getListElementType();
            if (List.class.equals((Object)elementType) && (String.class.equals((Object)listElementType) || Number.class.isAssignableFrom(listElementType) || Boolean.class.equals((Object)listElementType))) {
                this.columnNames.add(new ColumnElement(type, column));
                continue;
            }
            if (!String.class.equals((Object)elementType) && !Number.class.isAssignableFrom(elementType) && !Boolean.class.equals((Object)elementType)) continue;
            this.columnNames.add(new ColumnElement(type, column));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(ColumnCreatedEvent event) {
        Object object = this.lock;
        synchronized (object) {
            Class<CyNode> type;
            if (this.network == null) {
                return;
            }
            CyTable nodeTable = this.network.getDefaultNodeTable();
            CyTable edgeTable = this.network.getDefaultEdgeTable();
            CyTable table = (CyTable)event.getSource();
            if (table == nodeTable) {
                type = CyNode.class;
            } else if (table == edgeTable) {
                type = CyEdge.class;
            } else {
                return;
            }
            CyColumn column = table.getColumn(event.getColumnName());
            this.columnNames.add(new ColumnElement(type, column));
            Collections.sort(this.columnNames);
            this.updateColumnViews();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(ColumnDeletedEvent event) {
        Object object = this.lock;
        synchronized (object) {
            Class<CyNode> type;
            if (this.network == null) {
                return;
            }
            CyTable nodeTable = this.network.getDefaultNodeTable();
            CyTable edgeTable = this.network.getDefaultEdgeTable();
            CyTable table = (CyTable)event.getSource();
            if (table == nodeTable) {
                type = CyNode.class;
            } else if (table == edgeTable) {
                type = CyEdge.class;
            } else {
                return;
            }
            for (int i = 0; i < this.columnNames.size(); ++i) {
                ColumnElement element = this.columnNames.get(i);
                if (!element.getName().equals(event.getColumnName()) || !type.equals(element.getTableType())) continue;
                this.columnNames.remove(i);
                break;
            }
            this.updateColumnViews();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(ColumnNameChangedEvent event) {
        Object object = this.lock;
        synchronized (object) {
            Class<CyNode> type;
            if (this.network == null) {
                return;
            }
            CyTable nodeTable = this.network.getDefaultNodeTable();
            CyTable edgeTable = this.network.getDefaultEdgeTable();
            CyTable table = (CyTable)event.getSource();
            CyColumn column = table.getColumn(event.getNewColumnName());
            if (table == nodeTable) {
                type = CyNode.class;
            } else if (table == edgeTable) {
                type = CyEdge.class;
            } else {
                return;
            }
            for (int i = 0; i < this.columnNames.size(); ++i) {
                ColumnElement element = this.columnNames.get(i);
                if (!element.getName().equals(event.getOldColumnName()) || !type.equals(element.getTableType())) continue;
                this.columnNames.remove(i);
                this.columnNames.add(new ColumnElement(element.getTableType(), column));
                break;
            }
            Collections.sort(this.columnNames);
            this.updateColumnViews();
        }
    }

    private void clearNumericData() {
        this.clearDegreeData();
        this.nodeColumnRanges.clear();
        this.edgeColumnRanges.clear();
    }

    private void clearDegreeData() {
        this.nodeDegreeRange = new DegreeRange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DegreeRange getDegreeRange() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.nodeDegreeRange.isUpdated()) {
                this.computeNodeDegreeRange();
            }
            return this.nodeDegreeRange;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeNodeDegreeRange() {
        if (this.network == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.nodeDegreeRange.update(this.network);
        }
    }

    public List<ColumnElement> getColumnComboBoxModel() {
        return this.columnNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkType(String name, Class<?> columnType, Class<?> targetType) {
        Object object = this.lock;
        synchronized (object) {
            if (this.network == null) {
                return false;
            }
            CyTable table = this.getTable(columnType);
            if (table == null) {
                return false;
            }
            CyColumn column = table.getColumn(name);
            if (column == null) {
                return false;
            }
            Class type = column.getType();
            if (List.class.equals((Object)type)) {
                return targetType.equals(column.getListElementType());
            }
            return targetType.equals(type);
        }
    }

    private CyTable getTable(Class<?> columnType) {
        if (CyNode.class.equals(columnType)) {
            return this.network.getDefaultNodeTable();
        }
        if (CyEdge.class.equals(columnType)) {
            return this.network.getDefaultEdgeTable();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDegreeFilterView(DegreeFilterView view, DegreeFilterController controller) {
        Object object = this.lock;
        synchronized (object) {
            this.degreeViews.put(view, controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerColumnFilterView(ColumnFilterView view, ColumnFilterController controller) {
        Object object = this.lock;
        synchronized (object) {
            this.columnViews.put(view, controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Number[] getColumnRange(String name, Class<? extends CyIdentifiable> type) {
        Object object = this.lock;
        synchronized (object) {
            if (this.network == null) {
                return null;
            }
            if (CyNode.class.equals(type)) {
                CyTable table = this.network.getDefaultNodeTable();
                return this.getColumnRange(table, name, this.nodeColumnRanges);
            }
            CyTable table = this.network.getDefaultEdgeTable();
            return this.getColumnRange(table, name, this.edgeColumnRanges);
        }
    }

    private Number[] getColumnRange(CyTable table, String name, Map<String, double[]> ranges) {
        Class type;
        double[] range = ranges.get(name);
        CyColumn column = table.getColumn(name);
        if (column == null) {
            return null;
        }
        if (range == null) {
            range = this.computeRange(table, name, column);
            ranges.put(name, range);
        }
        if (List.class.equals((Object)(type = column.getType()))) {
            type = column.getListElementType();
        }
        if (Integer.class.equals((Object)type) || Long.class.equals((Object)type)) {
            return new Number[]{(long)range[0], (long)range[1]};
        }
        return new Number[]{range[0], range[1]};
    }

    private double[] computeRange(CyTable table, String name, CyColumn column) {
        double[] range = new double[]{Double.MAX_VALUE, Double.MIN_VALUE};
        boolean changed = false;
        Class type = column.getType();
        if (List.class.equals((Object)type)) {
            Class elementType = column.getListElementType();
            if (Number.class.isAssignableFrom(elementType)) {
                for (CyRow row : table.getAllRows()) {
                    List list = row.getList(name, elementType);
                    changed |= this.updateRange(range, list);
                }
            }
        } else if (Number.class.isAssignableFrom(type)) {
            for (CyRow row : table.getAllRows()) {
                Object value = row.get(name, type);
                changed |= this.updateRange(range, (Number)value);
            }
        }
        if (!changed) {
            return new double[]{0.0, 0.0};
        }
        return range;
    }

    public void addInteractivityChangedListener(InteractivityChangedListener listener) {
        if (this.interactivityChangedListeners.contains(listener)) {
            return;
        }
        this.interactivityChangedListeners.add(listener);
    }

    public void removeInteractivityChangedListener(InteractivityChangedListener listener) {
        this.interactivityChangedListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recomputeColumnRange(String name, Class<?> type) {
        Object object = this.lock;
        synchronized (object) {
            if (this.network == null) {
                return;
            }
            Map<String, double[]> ranges = type.equals(CyNode.class) ? this.nodeColumnRanges : this.edgeColumnRanges;
            ranges.remove(name);
        }
    }

    public void unregisterView(JComponent elementView) {
        this.degreeViews.remove(elementView);
        this.columnViews.remove(elementView);
    }
}

