/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.cytoscape.filter.internal.view.AbstractPanel;
import org.cytoscape.filter.internal.view.AbstractPanelController;
import org.cytoscape.filter.model.NamedTransformer;
import org.cytoscape.io.read.CyTransformerReader;
import org.cytoscape.io.write.CyTransformerWriter;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;

public class FilterIO {
    private final CyServiceRegistrar serviceRegistrar;

    public FilterIO(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public void readTransformers(File file, AbstractPanel<?, ?> panel) throws IOException {
        this.readTransformers(new FileInputStream(file), panel);
    }

    public void readTransformers(InputStream in, AbstractPanel panel) throws IOException {
        NamedTransformer[] transformers;
        try (BufferedInputStream stream = new BufferedInputStream(in);){
            CyTransformerReader reader = (CyTransformerReader)this.serviceRegistrar.getService(CyTransformerReader.class);
            transformers = reader.read((InputStream)stream);
        }
        Object controller = panel.getController();
        for (NamedTransformer t : transformers) {
            ((AbstractPanelController)controller).addNamedTransformer((AbstractPanel)panel, (NamedTransformer<CyNetwork, CyIdentifiable>)t, false);
        }
    }

    public void writeFilters(File file, NamedTransformer<CyNetwork, CyIdentifiable>[] namedTransformers) throws IOException {
        this.writeFilters(new FileOutputStream(file), namedTransformers);
    }

    public void writeFilters(OutputStream out, NamedTransformer<CyNetwork, CyIdentifiable>[] namedTransformers) throws IOException {
        try (BufferedOutputStream stream = new BufferedOutputStream(out);){
            CyTransformerWriter writer = (CyTransformerWriter)this.serviceRegistrar.getService(CyTransformerWriter.class);
            writer.write((OutputStream)stream, namedTransformers);
        }
    }
}

