/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.filter.internal;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import org.cytoscape.application.swing.CytoPanelComponent2;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.filter.internal.ModelMonitor;
import org.cytoscape.filter.internal.view.FilterPanel;
import org.cytoscape.filter.internal.view.FilterPanelController;
import org.cytoscape.filter.internal.view.SelectPanel;
import org.cytoscape.filter.internal.view.TransformerPanel;
import org.cytoscape.filter.internal.view.TransformerViewManager;
import org.cytoscape.filter.view.InteractivityChangedListener;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.TextIcon;

public class FilterCytoPanelComponent
implements CytoPanelComponent2 {
    private static final String ID = "org.cytoscape.Filter";
    SelectPanel panel;
    private TextIcon icon;
    private final CyServiceRegistrar serviceRegistrar;

    public FilterCytoPanelComponent(TransformerViewManager transformerViewManager, ModelMonitor modelMonitor, final FilterPanel filterPanel, TransformerPanel transformerPanel, CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        filterPanel.setPreferredSize(new Dimension(450, 300));
        modelMonitor.addInteractivityChangedListener(new InteractivityChangedListener(){

            public void handleInteractivityChanged(boolean isInteractive) {
                FilterPanelController filterPanelController = (FilterPanelController)filterPanel.getController();
                filterPanelController.setInteractive(isInteractive, filterPanel);
            }
        });
        this.panel = new SelectPanel(filterPanel, transformerPanel);
    }

    public Component getComponent() {
        return this.panel;
    }

    public CytoPanelName getCytoPanelName() {
        return CytoPanelName.WEST;
    }

    public String getTitle() {
        return "Filter";
    }

    public Icon getIcon() {
        if (this.icon == null) {
            this.icon = new TextIcon("\uf0b0", ((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(14.0f), 16, 16);
        }
        return this.icon;
    }

    public String getIdentifier() {
        return ID;
    }
}

