/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.enhancedGraphics.internal.gradients.radial;

import edu.ucsf.rbvi.enhancedGraphics.internal.gradients.GradientLayer;
import java.awt.Color;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.cytoscape.view.presentation.customgraphics.CustomGraphicLayer;

public class RadialGradientLayer
extends GradientLayer {
    Point2D center = null;
    float radius = 1.0f;
    protected Rectangle2D rectangle = null;

    public RadialGradientLayer(List<Color> colors, List<Float> stops, Point2D center, float radius) {
        super(colors, stops);
        this.center = center;
        this.radius = radius;
        if (this.center == null) {
            this.center = new Point2D.Float(0.5f, 0.5f);
        }
        if (this.radius == 0.0f) {
            this.radius = 1.0f;
        }
        this.rectangle = new Rectangle(0, 0, 1, 1);
    }

    public Paint getPaint(Rectangle2D bounds) {
        double xCenter = bounds.getWidth() * this.center.getX() + bounds.getX();
        double yCenter = bounds.getHeight() * this.center.getY() + bounds.getY();
        Point2D.Float newCenter = new Point2D.Float((float)xCenter, (float)yCenter);
        double newRadius = (double)this.radius * Math.min(bounds.getWidth(), bounds.getHeight());
        this.paint = new RadialGradientPaint(newCenter, (float)newRadius, this.stopArray, this.colorArray);
        return this.paint;
    }

    public Rectangle2D getBounds2D() {
        return this.rectangle;
    }

    public CustomGraphicLayer transform(AffineTransform xform) {
        RadialGradientLayer newLayer = new RadialGradientLayer(this.colorList, this.stopList, this.center, this.radius);
        newLayer.rectangle = xform.createTransformedShape(this.rectangle).getBounds2D();
        return newLayer;
    }
}

