/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.enhancedGraphics.internal.gradients.radial;

import edu.ucsf.rbvi.enhancedGraphics.internal.AbstractEnhancedCustomGraphics;
import edu.ucsf.rbvi.enhancedGraphics.internal.gradients.radial.RadialGradientLayer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Map;
import org.cytoscape.view.presentation.customgraphics.CustomGraphicLayer;

public class RadialGradientCustomGraphics
extends AbstractEnhancedCustomGraphics<RadialGradientLayer> {
    public RadialGradientCustomGraphics(String input) {
        Map<String, String> inputMap = this.parseInput(input);
        Point2D center = new Point2D.Float(0.5f, 0.5f);
        float radius = 1.0f;
        ArrayList<Float> stopList = new ArrayList<Float>();
        ArrayList<Color> colorList = new ArrayList<Color>();
        int nStops = 0;
        if (inputMap.containsKey("center") && (center = this.parsePoint(inputMap.get("center"))) == null) {
            this.logger.error((Object)("Not able to parse center point from '" + inputMap.get("center") + "'"));
            return;
        }
        if (inputMap.containsKey("radius")) {
            try {
                radius = Float.parseFloat(inputMap.get("radius"));
            }
            catch (NumberFormatException nfe) {
                this.logger.error((Object)("Not able to parse radius from '" + inputMap.get("radius") + "'"));
                return;
            }
        }
        if (inputMap.containsKey("stoplist") && (nStops = this.parseStopList(inputMap.get("stoplist"), colorList, stopList)) == 0) {
            this.logger.error((Object)("Not able to stop list from '" + inputMap.get("stoplist") + "'"));
            return;
        }
        RadialGradientLayer cg = new RadialGradientLayer(colorList, stopList, center, radius);
        this.layers.add(cg);
    }

    @Override
    public String toSerializableString() {
        return this.getIdentifier().toString() + "," + this.displayName;
    }

    @Override
    public Image getRenderedImage() {
        CustomGraphicLayer cg = (CustomGraphicLayer)this.layers.get(0);
        Rectangle bounds = cg.getBounds2D().getBounds();
        Ellipse2D.Double shape = new Ellipse2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
        BufferedImage image = new BufferedImage(bounds.width, bounds.height, 2);
        Graphics2D g2d = image.createGraphics();
        g2d.setPaint(cg.getPaint((Rectangle2D)bounds));
        g2d.fill(shape);
        return image;
    }
}

