/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.enhancedGraphics.internal.gradients.linear;

import edu.ucsf.rbvi.enhancedGraphics.internal.gradients.GradientLayer;
import java.awt.Color;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.cytoscape.view.presentation.customgraphics.CustomGraphicLayer;

public class LinearGradientLayer
extends GradientLayer {
    Point2D start = null;
    Point2D end = null;
    protected Rectangle2D rectangle = null;

    public LinearGradientLayer(List<Color> colors, List<Float> stops, Point2D start, Point2D end) {
        super(colors, stops);
        this.start = start;
        this.end = end;
        if (this.start == null) {
            this.start = new Point2D.Float(0.0f, 0.0f);
        }
        if (this.end == null) {
            this.end = new Point2D.Float(1.0f, 0.0f);
        }
        this.rectangle = new Rectangle(0, 0, 100, 100);
    }

    public Paint getPaint(Rectangle2D bounds) {
        this.paint = new LinearGradientPaint(this.scale(this.start, bounds), this.scale(this.end, bounds), this.stopArray, this.colorArray);
        return this.paint;
    }

    public Rectangle2D getBounds2D() {
        return this.rectangle;
    }

    public CustomGraphicLayer transform(AffineTransform xform) {
        LinearGradientLayer newLayer = new LinearGradientLayer(this.colorList, this.stopList, this.start, this.end);
        newLayer.rectangle = xform.createTransformedShape(this.rectangle).getBounds2D();
        return newLayer;
    }
}

