/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.enhancedGraphics.internal.gradients.linear;

import edu.ucsf.rbvi.enhancedGraphics.internal.AbstractEnhancedCustomGraphics;
import edu.ucsf.rbvi.enhancedGraphics.internal.gradients.linear.LinearGradientLayer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Map;
import org.cytoscape.view.presentation.customgraphics.CustomGraphicLayer;

public class LinearGradientCustomGraphics
extends AbstractEnhancedCustomGraphics<LinearGradientLayer> {
    public LinearGradientCustomGraphics(String input) {
        Map<String, String> inputMap = this.parseInput(input);
        Point2D start = new Point2D.Float(0.0f, 0.0f);
        Point2D end = new Point2D.Float(1.0f, 0.0f);
        ArrayList<Float> stopList = new ArrayList<Float>();
        ArrayList<Color> colorList = new ArrayList<Color>();
        int nStops = 0;
        if (inputMap.containsKey("start") && (start = this.parsePoint(inputMap.get("start"))) == null) {
            this.logger.error((Object)("Not able to parse start point from '" + inputMap.get("start") + "'"));
            return;
        }
        if (inputMap.containsKey("end") && (end = this.parsePoint(inputMap.get("end"))) == null) {
            this.logger.error((Object)("Not able to parse end point from '" + inputMap.get("end") + "'"));
            return;
        }
        if (inputMap.containsKey("stoplist") && (nStops = this.parseStopList(inputMap.get("stoplist"), colorList, stopList)) == 0) {
            this.logger.error((Object)("Not able to stop list from '" + inputMap.get("stoplist") + "'"));
            return;
        }
        LinearGradientLayer cg = new LinearGradientLayer(colorList, stopList, start, end);
        this.layers.add(cg);
    }

    @Override
    public String toSerializableString() {
        return this.getIdentifier().toString() + "," + this.displayName;
    }

    @Override
    public Image getRenderedImage() {
        CustomGraphicLayer cg = (CustomGraphicLayer)this.layers.get(0);
        Rectangle rect = cg.getBounds2D().getBounds();
        BufferedImage image = new BufferedImage(rect.width, rect.height, 2);
        Graphics2D g2d = image.createGraphics();
        g2d.setPaint(cg.getPaint((Rectangle2D)rect));
        g2d.fill(rect);
        return image;
    }
}

