/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.enhancedGraphics.internal.charts.stripe;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.cytoscape.view.presentation.customgraphics.PaintedShape;

public class StripeLayer
implements PaintedShape {
    private boolean labelLayer = false;
    private String label;
    private Color color;
    private int fontSize;
    protected Rectangle2D bounds;
    private int stripe;
    private int nStripes;

    public StripeLayer(int stripe, int nStripes, Color color) {
        this.labelLayer = false;
        this.color = color;
        this.stripe = stripe;
        this.nStripes = nStripes;
        this.bounds = new Rectangle2D.Double(0.0, 0.0, 100.0, 50.0);
    }

    public StripeLayer(int stripe, int nStripes, String label, int fontSize) {
        this.labelLayer = true;
        this.stripe = stripe;
        this.nStripes = nStripes;
        this.label = label;
        this.fontSize = fontSize;
        this.color = Color.BLACK;
        this.bounds = new Rectangle2D.Double(0.0, 0.0, 100.0, 50.0);
    }

    public Paint getPaint() {
        return this.color;
    }

    public Paint getPaint(Rectangle2D bounds) {
        return this.color;
    }

    public Shape getShape() {
        if (this.labelLayer) {
            return this.labelShape();
        }
        return this.stripeShape();
    }

    public Stroke getStroke() {
        if (!this.labelLayer) {
            return new BasicStroke(0.1f);
        }
        return null;
    }

    public Paint getStrokePaint() {
        return Color.BLACK;
    }

    public Rectangle2D getBounds2D() {
        return this.bounds;
    }

    public StripeLayer transform(AffineTransform xform) {
        Shape newBounds = xform.createTransformedShape(this.bounds);
        StripeLayer bl = this.labelLayer ? new StripeLayer(this.stripe, this.nStripes, this.label, this.fontSize) : new StripeLayer(this.stripe, this.nStripes, this.color);
        bl.bounds = newBounds.getBounds2D();
        return bl;
    }

    private Shape stripeShape() {
        return this.getStripe(this.stripe, this.nStripes);
    }

    private Shape labelShape() {
        return null;
    }

    private Rectangle2D getStripe(int stripe, int nStripes) {
        double x = this.bounds.getX() - this.bounds.getWidth() / 2.0;
        double y = this.bounds.getY() - this.bounds.getHeight() / 2.0;
        double width = this.bounds.getWidth();
        double height = this.bounds.getHeight();
        return new Rectangle2D.Double(x + (double)stripe * width / (double)nStripes, y, width / (double)nStripes, height);
    }
}

