/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.enhancedGraphics.internal.charts.stripe;

import edu.ucsf.rbvi.enhancedGraphics.internal.charts.AbstractChartCustomGraphics;
import edu.ucsf.rbvi.enhancedGraphics.internal.charts.stripe.StripeLayer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;

public class StripeChart
extends AbstractChartCustomGraphics<StripeLayer> {
    private static final String COLORS = "colorlist";
    private List<Color> colorList = null;
    private int labelSize = 4;
    private String colorString = null;

    public StripeChart(String input) {
        Map<String, String> args = this.parseInput(input);
        if (args.containsKey(COLORS)) {
            if (this.attributes == null) {
                this.colorList = this.convertInputToColor(args.get(COLORS), new ArrayList<Double>());
            } else {
                this.colorString = args.get(COLORS);
            }
        }
    }

    @Override
    public String toSerializableString() {
        return this.getIdentifier().toString() + "," + this.displayName;
    }

    @Override
    public List<StripeLayer> getLayers(CyNetworkView networkView, View nodeView) {
        CyNetwork network = (CyNetwork)networkView.getModel();
        int nStripes = this.colorList.size();
        this.layers = new ArrayList();
        for (int stripe = 0; stripe < nStripes; ++stripe) {
            Color color = this.colorList.get(stripe);
            StripeLayer bl = new StripeLayer(stripe, nStripes, color);
            if (bl == null) continue;
            this.layers.add(bl);
        }
        this.shapeLayers = this.layers;
        return this.layers;
    }
}

