/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.enhancedGraphics.internal.charts.pie;

import edu.ucsf.rbvi.enhancedGraphics.internal.charts.ViewUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.cytoscape.view.presentation.customgraphics.PaintedShape;

public class PieLayer
implements PaintedShape {
    private boolean labelLayer = false;
    private double arcStart;
    private double arc;
    private boolean isClockwise;
    private String label;
    private Color color;
    private Color strokeColor;
    private Font font;
    private double labelWidth = Double.MAX_VALUE;
    private double labelSpacing = 1.0;
    private double borderWidth;
    protected Rectangle2D bounds;

    public PieLayer(double arcStart, double arc, boolean isClockwise, Color color, double borderWidth, Color borderColor) {
        this.labelLayer = false;
        this.arcStart = arcStart;
        this.arc = arc;
        this.isClockwise = isClockwise;
        this.color = color;
        this.bounds = new Rectangle2D.Double(0.0, 0.0, 100.0, 100.0);
        this.borderWidth = borderWidth;
        this.strokeColor = borderColor;
    }

    public PieLayer(double arcStart, double arc, boolean isClockwise, String label, Font font, Color labelColor, double labelWidth, double labelSpacing) {
        this.labelLayer = true;
        this.arcStart = arcStart;
        this.arc = arc;
        this.isClockwise = isClockwise;
        this.label = label;
        this.font = font;
        this.color = labelColor;
        this.strokeColor = labelColor;
        this.labelWidth = labelWidth;
        this.labelSpacing = labelSpacing;
        this.bounds = new Rectangle2D.Double(0.0, 0.0, 100.0, 100.0);
    }

    public Paint getPaint() {
        return this.color;
    }

    public Paint getPaint(Rectangle2D bounds) {
        return this.color;
    }

    public Shape getShape() {
        if (this.labelLayer) {
            return this.labelShape();
        }
        return this.sliceShape();
    }

    public Stroke getStroke() {
        if (!this.labelLayer) {
            return new BasicStroke((float)this.borderWidth);
        }
        return null;
    }

    public Paint getStrokePaint() {
        return this.strokeColor;
    }

    public Rectangle2D getBounds2D() {
        return this.bounds;
    }

    public PieLayer transform(AffineTransform xform) {
        Shape newBounds = xform.createTransformedShape(this.bounds);
        this.bounds = newBounds.getBounds2D();
        return this;
    }

    private Shape sliceShape() {
        double x = this.bounds.getX() - this.bounds.getWidth() / 2.0;
        double y = this.bounds.getY() - this.bounds.getHeight() / 2.0;
        double width = this.bounds.getWidth();
        double height = this.bounds.getHeight();
        Arc2D.Double slice = this.isClockwise ? new Arc2D.Double(x, y, width, height, this.arcStart, -this.arc, 2) : new Arc2D.Double(x, y, width, height, this.arcStart, this.arc, 2);
        return slice;
    }

    private Shape labelShape() {
        double midpointAngle = this.arcStart + this.arc / 2.0;
        if (this.isClockwise) {
            midpointAngle = this.arcStart - this.arc / 2.0;
        }
        ViewUtils.TextAlignment tAlign = this.getLabelAlignment(midpointAngle);
        Shape textShape = ViewUtils.getLabelShape(this.label, this.font, this.labelWidth, this.labelSpacing);
        Point2D labelPosition = this.getLabelPosition(this.bounds, midpointAngle, 1.7);
        if ((textShape = ViewUtils.positionLabel(textShape, labelPosition, tAlign, 0.0, 0.0, 0.0)) == null) {
            return null;
        }
        labelPosition = this.getLabelPosition(this.bounds, midpointAngle, 1.0);
        Shape labelLine = ViewUtils.getLabelLine(textShape.getBounds2D(), labelPosition, tAlign);
        Area textArea = new Area(textShape);
        textArea.add(new Area(labelLine));
        return textArea;
    }

    private Point2D getLabelPosition(Rectangle2D bbox, double angle, double scale) {
        double y;
        double x;
        while (angle < 0.0) {
            angle += 360.0;
        }
        while (angle >= 360.0) {
            angle -= 360.0;
        }
        double midpoint = Math.toRadians(360.0 - angle);
        double w = bbox.getWidth() / 2.0 * scale;
        double h = bbox.getHeight() / 2.0 * scale;
        if (angle == 270.0) {
            x = 0.0;
            y = h;
        } else if (angle == 90.0) {
            x = 0.0;
            y = -h;
        } else {
            x = Math.cos(midpoint) * w;
            y = Math.sin(midpoint) * h;
        }
        return new Point2D.Double(x, y);
    }

    private ViewUtils.TextAlignment getLabelAlignment(double midPointAngle) {
        while (midPointAngle < 0.0) {
            midPointAngle += 360.0;
        }
        while (midPointAngle >= 360.0) {
            midPointAngle -= 360.0;
        }
        if (midPointAngle >= 280.0 || midPointAngle < 80.0) {
            return ViewUtils.TextAlignment.ALIGN_LEFT;
        }
        if (midPointAngle >= 80.0 && midPointAngle < 100.0) {
            return ViewUtils.TextAlignment.ALIGN_CENTER_BOTTOM;
        }
        if (midPointAngle >= 100.0 && midPointAngle < 260.0) {
            return ViewUtils.TextAlignment.ALIGN_RIGHT;
        }
        if (midPointAngle >= 260.0 && midPointAngle < 280.0) {
            return ViewUtils.TextAlignment.ALIGN_CENTER_TOP;
        }
        return ViewUtils.TextAlignment.ALIGN_LEFT;
    }

    private void sortSlicesBySize(List<Double> values, List<Color> colors, List<String> labels, double minimumSlice) {
        Double[] valueArray = values.toArray(new Double[1]);
        values.clear();
        Color[] colorArray = colors.toArray(new Color[1]);
        colors.clear();
        String[] labelArray = labels.toArray(new String[1]);
        labels.clear();
        Integer[] sortedIndex = new Integer[valueArray.length];
        for (int i = 0; i < valueArray.length; ++i) {
            sortedIndex[i] = new Integer(i);
        }
        IndexComparator iCompare = new IndexComparator(valueArray);
        Arrays.sort(sortedIndex, iCompare);
        double otherValues = 0.0;
        for (int index = valueArray.length - 1; index >= 0; --index) {
            if (valueArray[sortedIndex[index]] >= minimumSlice) {
                values.add(valueArray[sortedIndex[index]]);
                colors.add(colorArray[sortedIndex[index]]);
                labels.add(labelArray[sortedIndex[index]]);
                continue;
            }
            otherValues += valueArray[sortedIndex[index]].doubleValue();
        }
        if (otherValues > 0.0) {
            values.add(otherValues);
            colors.add(Color.LIGHT_GRAY);
            labels.add("Other");
        }
    }

    private class IndexComparator
    implements Comparator<Integer> {
        Double[] data = null;
        Integer[] intData = null;

        public IndexComparator(Double[] data) {
            this.data = data;
        }

        public IndexComparator(Integer[] data) {
            this.intData = data;
        }

        @Override
        public int compare(Integer o1, Integer o2) {
            if (this.data != null) {
                if (this.data[o1] < this.data[o2]) {
                    return -1;
                }
                if (this.data[o1] > this.data[o2]) {
                    return 1;
                }
                return 0;
            }
            if (this.intData != null) {
                if (this.intData[o1] < this.intData[o2]) {
                    return -1;
                }
                if (this.intData[o1] > this.intData[o2]) {
                    return 1;
                }
                return 0;
            }
            return 0;
        }
    }
}

