/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.enhancedGraphics.internal.charts.pie;

import edu.ucsf.rbvi.enhancedGraphics.internal.charts.AbstractChartCustomGraphics;
import edu.ucsf.rbvi.enhancedGraphics.internal.charts.pie.PieLayer;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;

public class PieChart
extends AbstractChartCustomGraphics<PieLayer> {
    private static final String COLORS = "colorlist";
    private static final String LABELOFFSET = "labeloffset";
    private static final String SORTSLICES = "sortslices";
    private static final String MINIMUMSLICE = "minimumslice";
    private static final String ARCSTART = "arcstart";
    private static final String ARCDIRECTION = "arcdirection";
    private List<Color> colorList = null;
    private double arcStart = 0.0;
    private boolean isClockwise = false;
    private boolean sortSlices = true;
    private double minimumSlice = 2.0;
    private String colorString = null;

    public PieChart(String input) {
        Map<String, String> args = this.parseInput(input);
        this.populateValues(args);
        if (args.containsKey(COLORS)) {
            if (this.attributes == null) {
                this.colorList = this.convertInputToColor(args.get(COLORS), this.values);
            } else {
                this.colorString = args.get(COLORS);
            }
        }
        if (args.containsKey(SORTSLICES)) {
            this.sortSlices = this.getBooleanValue(args.get(SORTSLICES));
        }
        if (args.containsKey(ARCSTART)) {
            this.arcStart = this.getDoubleValue(args.get(ARCSTART));
        }
        if (args.containsKey(ARCDIRECTION)) {
            String direction = args.get(ARCDIRECTION).trim().toLowerCase();
            this.isClockwise = direction.equals("clockwise") || direction.equals("cw") || direction.equals("clock");
        }
    }

    @Override
    public String toSerializableString() {
        return this.getIdentifier().toString() + "," + this.displayName;
    }

    @Override
    public List<PieLayer> getLayers(CyNetworkView networkView, View<? extends CyIdentifiable> nodeView) {
        CyNetwork network = (CyNetwork)networkView.getModel();
        if (!(nodeView.getModel() instanceof CyNode)) {
            return null;
        }
        this.layers = new ArrayList();
        CyNode node = (CyNode)nodeView.getModel();
        if (this.attributes != null && this.attributes.size() > 0) {
            CyRow nodeRow;
            CyTable nodeTable;
            boolean noLabels;
            boolean bl = noLabels = this.labels == null || this.labels.isEmpty();
            if (this.values == null || this.values.size() == 0) {
                this.values = this.getDataFromAttributes(network, node, this.attributes, this.labels);
                this.colorList = this.convertInputToColor(this.colorString, this.values);
            } else {
                boolean foundColors = false;
                List<Double> attrValues = this.getDataFromAttributes(network, node, this.attributes, this.labels);
                if (this.colorString != null && this.colorString.indexOf(59) > 0) {
                    this.colorList = new ArrayList<Color>();
                    String[] colors = this.colorString.split(";");
                    if (colors.length != attrValues.size()) {
                        this.logger.error((Object)"piechart: number of colors must match the number of attributes");
                        return null;
                    }
                    int colorIndex = 0;
                    for (Double value : attrValues) {
                        if (value == null) {
                            this.colorList.add(null);
                            continue;
                        }
                        foundColors = true;
                        this.colorList.addAll(this.convertInputToColor(colors[colorIndex++], Collections.singletonList(value)));
                    }
                    if (!foundColors) {
                        this.logger.error((Object)"piechart: no colors found");
                        return null;
                    }
                } else {
                    this.colorList = this.convertInputToColor(this.colorString, attrValues);
                }
            }
            if (noLabels && this.attributes.size() == 1 && (nodeTable = (nodeRow = network.getRow((CyIdentifiable)node)).getTable()).getColumn((String)this.attributes.get(0)) != null && nodeTable.getColumn((String)this.attributes.get(0)).getType().equals(List.class)) {
                this.labels = null;
            }
        }
        if (this.attributes == null && this.values == null) {
            this.logger.error((Object)"piechart: no attribute nor values found");
            return null;
        }
        if (this.colorList == null || this.colorList.isEmpty()) {
            this.logger.error((Object)"piechart: no colors found");
            return null;
        }
        this.values = this.convertData(this.values);
        if (this.labels != null && this.labels.size() > 0 && (this.labels.size() != this.values.size() || this.labels.size() != this.colorList.size())) {
            this.logger.error((Object)("piechart: number of labels (" + this.labels.size() + "), values (" + this.values.size() + "), and colors (" + this.colorList.size() + ") don't match"));
            return null;
        }
        ArrayList<PieLayer> labelList = new ArrayList<PieLayer>();
        Font font = this.getFont();
        int nSlices = this.values.size();
        double arc = this.arcStart;
        for (int slice = 0; slice < nSlices; ++slice) {
            PieLayer labelLayer;
            PieLayer pl;
            String label = null;
            if (this.labels != null && this.labels.size() > 0) {
                label = (String)this.labels.get(slice);
            }
            if ((Double)this.values.get(slice) == 0.0 || (pl = new PieLayer(arc, (Double)this.values.get(slice), this.isClockwise, this.colorList.get(slice), this.borderWidth, this.borderColor)) == null) continue;
            this.layers.add(pl);
            if (label != null && label.length() > 0 && (labelLayer = new PieLayer(arc, (Double)this.values.get(slice), this.isClockwise, label, font, this.labelColor, this.labelWidth, this.labelSpacing)) != null) {
                labelList.add(labelLayer);
            }
            if (this.isClockwise) {
                arc -= ((Double)this.values.get(slice)).doubleValue();
                continue;
            }
            arc += ((Double)this.values.get(slice)).doubleValue();
        }
        if (labelList != null && labelList.size() > 0) {
            this.layers.addAll(labelList);
        }
        this.shapeLayers = this.layers;
        return this.layers;
    }

    private List<Double> convertData(List<Double> values) {
        double totalSize = 0.0;
        int nValues = values.size();
        for (Double d : values) {
            totalSize += d.doubleValue();
        }
        for (int index = 0; index < nValues; ++index) {
            double v = values.get(index);
            values.set(index, v * 360.0 / totalSize);
        }
        return values;
    }
}

