/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsf.rbvi.enhancedGraphics.internal.charts.line;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.cytoscape.view.presentation.customgraphics.PaintedShape;

public class LineLayer
implements PaintedShape {
    private boolean labelLayer = false;
    private String label;
    private Color color;
    private int fontSize;
    protected Rectangle2D bounds;
    private double value1;
    private double value2;
    private double maxValue;
    private double minValue;
    private float lineWidth;
    private int point;
    private int nPoints;

    public LineLayer(int point, int nPoints, double value1, double value2, double minValue, double maxValue, Color color, float lineWidth) {
        this.labelLayer = false;
        this.color = color;
        this.point = point;
        this.nPoints = nPoints;
        this.value1 = value1;
        this.value2 = value2;
        this.lineWidth = lineWidth;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.bounds = new Rectangle2D.Double(0.0, 0.0, 100.0, 50.0);
    }

    public LineLayer(int point, int nPoints, double minValue, double maxValue, String label, int fontSize) {
        this.labelLayer = true;
        this.point = point;
        this.nPoints = nPoints;
        this.label = label;
        this.fontSize = fontSize;
        this.color = Color.BLACK;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.bounds = new Rectangle2D.Double(0.0, 0.0, 100.0, 50.0);
    }

    public Paint getPaint() {
        return this.color;
    }

    public Paint getPaint(Rectangle2D bounds) {
        return this.color;
    }

    public Shape getShape() {
        if (this.labelLayer) {
            return this.labelShape();
        }
        return this.lineShape();
    }

    public Stroke getStroke() {
        if (!this.labelLayer) {
            return new BasicStroke(this.lineWidth);
        }
        return null;
    }

    public Paint getStrokePaint() {
        return this.color;
    }

    public Rectangle2D getBounds2D() {
        return this.bounds;
    }

    public LineLayer transform(AffineTransform xform) {
        Shape newBounds = xform.createTransformedShape(this.bounds);
        LineLayer bl = this.labelLayer ? new LineLayer(this.point, this.nPoints, this.minValue, this.maxValue, this.label, this.fontSize) : new LineLayer(this.point, this.nPoints, this.value1, this.value2, this.minValue, this.maxValue, this.color, this.lineWidth);
        bl.bounds = newBounds.getBounds2D();
        return bl;
    }

    private Shape lineShape() {
        return this.getLine(this.value1, this.value2);
    }

    private Shape labelShape() {
        return null;
    }

    private Line2D getLine(double val1, double val2) {
        double x = this.bounds.getX() - this.bounds.getWidth() / 2.0;
        double y = this.bounds.getY() - this.bounds.getHeight() / 2.0;
        double width = this.bounds.getWidth();
        double height = this.bounds.getHeight();
        double yMid = y + 0.5 * height;
        double pointSize = width / (double)(this.nPoints - 1);
        double divisor = 1.0;
        if (this.maxValue > this.minValue) {
            divisor = (this.maxValue - this.minValue) / (height - 1.0);
        }
        double px1 = x + (double)this.point * pointSize;
        double px2 = x + (double)(this.point + 1) * pointSize;
        double py1 = y + (height - (val1 - this.minValue) / divisor);
        double py2 = y + (height - (val2 - this.minValue) / divisor);
        return new Line2D.Double(px1, py1, px2, py2);
    }
}

